/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.javaprop;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsFactory;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper$Builder;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsSchema;
import com.fasterxml.jackson.dataformat.javaprop.PackageVersion;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class JavaPropsMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;

    public JavaPropsMapper() {
        this(new JavaPropsFactory());
    }

    public JavaPropsMapper(JavaPropsFactory javaPropsFactory) {
        super(javaPropsFactory);
        this.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        this.coercionConfigDefaults().setAcceptBlankAsEmpty(Boolean.TRUE).setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsEmpty);
    }

    protected JavaPropsMapper(JavaPropsMapper javaPropsMapper) {
        super(javaPropsMapper);
    }

    public static JavaPropsMapper$Builder builder() {
        return new JavaPropsMapper$Builder(new JavaPropsMapper());
    }

    public static JavaPropsMapper$Builder builder(JavaPropsFactory javaPropsFactory) {
        return new JavaPropsMapper$Builder(new JavaPropsMapper(javaPropsFactory));
    }

    @Override
    public JavaPropsMapper copy() {
        this._checkInvalidCopy(JavaPropsMapper.class);
        return new JavaPropsMapper(this);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public JavaPropsFactory getFactory() {
        return (JavaPropsFactory)this._jsonFactory;
    }

    public <T> T readPropertiesAs(Properties object, JavaPropsSchema javaPropsSchema, Class<T> clazz) {
        object = this.getFactory().createParser((Map<?, ?>)object);
        ((JsonParser)object).setSchema(javaPropsSchema);
        return ((ObjectCodec)this).readValue((JsonParser)object, clazz);
    }

    public <T> T readPropertiesAs(Properties object, JavaPropsSchema javaPropsSchema, JavaType javaType) {
        object = this.getFactory().createParser((Map<?, ?>)object);
        ((JsonParser)object).setSchema(javaPropsSchema);
        return this.readValue((JsonParser)object, javaType);
    }

    public <T> T readPropertiesAs(Properties properties, Class<T> clazz) {
        return this.readPropertiesAs(properties, JavaPropsSchema.emptySchema(), clazz);
    }

    public <T> T readPropertiesAs(Properties properties, JavaType javaType) {
        return this.readPropertiesAs(properties, JavaPropsSchema.emptySchema(), javaType);
    }

    public <T> T readMapAs(Map<String, String> object, JavaPropsSchema javaPropsSchema, Class<T> clazz) {
        object = this.getFactory().createParser((Map<?, ?>)object);
        ((JsonParser)object).setSchema(javaPropsSchema);
        return ((ObjectCodec)this).readValue((JsonParser)object, clazz);
    }

    public <T> T readMapAs(Map<String, String> object, JavaPropsSchema javaPropsSchema, JavaType javaType) {
        object = this.getFactory().createParser((Map<?, ?>)object);
        ((JsonParser)object).setSchema(javaPropsSchema);
        return this.readValue((JsonParser)object, javaType);
    }

    public <T> T readMapAs(Map<String, String> map, Class<T> clazz) {
        return this.readMapAs(map, JavaPropsSchema.emptySchema(), clazz);
    }

    public <T> T readMapAs(Map<String, String> map, JavaType javaType) {
        return this.readMapAs(map, JavaPropsSchema.emptySchema(), javaType);
    }

    public <T> T readSystemPropertiesAs(JavaPropsSchema javaPropsSchema, Class<T> clazz) {
        return this.readPropertiesAs(System.getProperties(), javaPropsSchema, clazz);
    }

    public <T> T readSystemPropertiesAs(JavaPropsSchema javaPropsSchema, JavaType javaType) {
        return this.readPropertiesAs(System.getProperties(), javaPropsSchema, javaType);
    }

    public <T> T readEnvVariablesAs(JavaPropsSchema javaPropsSchema, Class<T> clazz) {
        JavaPropsMapper javaPropsMapper = this;
        return javaPropsMapper.readPropertiesAs(javaPropsMapper._env(), javaPropsSchema, clazz);
    }

    public <T> T readEnvVariablesAs(JavaPropsSchema javaPropsSchema, JavaType javaType) {
        JavaPropsMapper javaPropsMapper = this;
        return javaPropsMapper.readPropertiesAs(javaPropsMapper._env(), javaPropsSchema, javaType);
    }

    protected Properties _env() {
        Properties properties = new Properties();
        properties.putAll(System.getenv());
        return properties;
    }

    public void writeValue(Map<?, ?> object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException("Can not pass `null` target");
        }
        object = this.getFactory().createGenerator((Map<?, ?>)object, null);
        Throwable throwable = null;
        try {
            ((ObjectCodec)this).writeValue((JsonGenerator)object, object2);
            if (object != null) {
                ((JsonGenerator)object).close();
                return;
            }
        }
        catch (Throwable throwable2) {
            try {
                object2 = throwable2;
                throwable = throwable2;
                throw object2;
            }
            catch (Throwable throwable3) {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((JsonGenerator)object).close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        ((JsonGenerator)object).close();
                    }
                }
                throw throwable3;
            }
        }
    }

    public void writeValue(Map<?, ?> object, Object object2, JavaPropsSchema javaPropsSchema) {
        if (object == null) {
            throw new IllegalArgumentException("Can not pass `null` target");
        }
        object = this.getFactory().createGenerator((Map<?, ?>)object, javaPropsSchema);
        Throwable throwable = null;
        try {
            if (javaPropsSchema != null) {
                ((JsonGenerator)object).setSchema(javaPropsSchema);
            }
            ((ObjectCodec)this).writeValue((JsonGenerator)object, object2);
            if (object != null) {
                ((JsonGenerator)object).close();
                return;
            }
        }
        catch (Throwable throwable2) {
            try {
                object2 = throwable2;
                throwable = throwable2;
                throw object2;
            }
            catch (Throwable throwable3) {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((JsonGenerator)object).close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        ((JsonGenerator)object).close();
                    }
                }
                throw throwable3;
            }
        }
    }

    @Deprecated
    public void writeValue(Properties properties, Object object) {
        this.writeValue((Map<?, ?>)properties, object);
    }

    @Deprecated
    public void writeValue(Properties properties, Object object, JavaPropsSchema javaPropsSchema) {
        this.writeValue((Map<?, ?>)properties, object, javaPropsSchema);
    }

    public Properties writeValueAsProperties(Object object) {
        Properties properties = new Properties();
        this.writeValue(properties, object);
        return properties;
    }

    public Properties writeValueAsProperties(Object object, JavaPropsSchema javaPropsSchema) {
        Properties properties = new Properties();
        this.writeValue(properties, object, javaPropsSchema);
        return properties;
    }

    public Map<String, String> writeValueAsMap(Object object) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        this.writeValue(linkedHashMap, object);
        return linkedHashMap;
    }

    public Map<String, String> writeValueAsMap(Object object, JavaPropsSchema javaPropsSchema) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        this.writeValue(linkedHashMap, object, javaPropsSchema);
        return linkedHashMap;
    }
}

