/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.javaprop;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonParser$NumberType;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsSchema;
import com.fasterxml.jackson.dataformat.javaprop.PackageVersion;
import com.fasterxml.jackson.dataformat.javaprop.io.JPropReadContext;
import com.fasterxml.jackson.dataformat.javaprop.util.JPropNode;
import com.fasterxml.jackson.dataformat.javaprop.util.JPropNodeBuilder;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.Properties;

public class JavaPropsParser
extends ParserMinimalBase {
    protected static final JavaPropsSchema DEFAULT_SCHEMA = new JavaPropsSchema();
    protected static final JacksonFeatureSet<StreamReadCapability> STREAM_READ_CAPABILITIES = DEFAULT_READ_CAPABILITIES.with(StreamReadCapability.UNTYPED_SCALARS);
    protected ObjectCodec _objectCodec;
    protected final Object _inputSource;
    protected final Map<?, ?> _sourceContent;
    protected JavaPropsSchema _schema = DEFAULT_SCHEMA;
    protected JPropReadContext _readContext;
    protected boolean _closed;
    protected ByteArrayBuilder _byteArrayBuilder;
    protected byte[] _binaryValue;

    @Deprecated
    public JavaPropsParser(IOContext iOContext, Object object, int n2, ObjectCodec objectCodec, Properties properties) {
        this(iOContext, n2, object, objectCodec, properties);
    }

    public JavaPropsParser(IOContext iOContext, int n2, Object object, ObjectCodec objectCodec, Map<?, ?> map) {
        super(n2);
        this._objectCodec = objectCodec;
        this._inputSource = object;
        this._sourceContent = map;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public void setSchema(FormatSchema formatSchema) {
        if (formatSchema instanceof JavaPropsSchema) {
            this._schema = (JavaPropsSchema)formatSchema;
            return;
        }
        super.setSchema(formatSchema);
    }

    @Override
    public JavaPropsSchema getSchema() {
        return this._schema;
    }

    @Override
    public void close() {
        this._closed = true;
        this._readContext = null;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public Object getInputSource() {
        return this._inputSource;
    }

    @Override
    public boolean canUseSchema(FormatSchema formatSchema) {
        return formatSchema instanceof JavaPropsSchema;
    }

    @Override
    public boolean requiresCustomCodec() {
        return false;
    }

    @Override
    public boolean canReadObjectId() {
        return false;
    }

    @Override
    public boolean canReadTypeId() {
        return false;
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return STREAM_READ_CAPABILITIES;
    }

    @Override
    public JsonStreamContext getParsingContext() {
        return this._readContext;
    }

    @Override
    public void overrideCurrentName(String string) {
        this._readContext.overrideCurrentName(string);
    }

    @Override
    public String getCurrentName() {
        JPropReadContext jPropReadContext;
        if (this._readContext == null) {
            return null;
        }
        if ((this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) && (jPropReadContext = this._readContext.getParent()) != null) {
            return ((JsonStreamContext)jPropReadContext).getCurrentName();
        }
        return ((JsonStreamContext)this._readContext).getCurrentName();
    }

    @Override
    public JsonToken nextToken() {
        this._binaryValue = null;
        if (this._readContext == null) {
            if (this._closed) {
                return null;
            }
            this._closed = true;
            JPropNode jPropNode = JPropNodeBuilder.build(this._sourceContent, this._schema);
            this._readContext = JPropReadContext.create(jPropNode);
        }
        while ((this._currToken = this._readContext.nextToken()) == null) {
            this._readContext = this._readContext.nextContext();
            if (this._readContext != null) continue;
            return null;
        }
        return this._currToken;
    }

    @Override
    public String getText() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            return this._readContext.getCurrentText();
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            return ((JsonStreamContext)this._readContext).getCurrentName();
        }
        if (jsonToken == null) {
            return null;
        }
        return jsonToken.asString();
    }

    @Override
    public boolean hasTextCharacters() {
        return false;
    }

    @Override
    public char[] getTextCharacters() {
        String string = ((JsonParser)this).getText();
        if (string == null) {
            return null;
        }
        return string.toCharArray();
    }

    @Override
    public int getTextLength() {
        String string = ((JsonParser)this).getText();
        if (string == null) {
            return 0;
        }
        return string.length();
    }

    @Override
    public int getTextOffset() {
        return 0;
    }

    @Override
    public int getText(Writer writer) {
        String string = ((JsonParser)this).getText();
        if (string == null) {
            return 0;
        }
        writer.write(string);
        return string.length();
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) {
        if (this._binaryValue == null) {
            if (this._currToken != JsonToken.VALUE_STRING) {
                this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING, can not access as binary");
            }
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            JavaPropsParser javaPropsParser = this;
            javaPropsParser._decodeBase64(((JsonParser)javaPropsParser).getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    public ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    @Override
    public Object getEmbeddedObject() {
        return null;
    }

    @Override
    public JsonLocation getTokenLocation() {
        return JsonLocation.NA;
    }

    @Override
    public JsonLocation getCurrentLocation() {
        return JsonLocation.NA;
    }

    @Override
    public Number getNumberValue() {
        return (Number)this._noNumbers();
    }

    @Override
    public JsonParser$NumberType getNumberType() {
        return (JsonParser$NumberType)((Object)this._noNumbers());
    }

    @Override
    public int getIntValue() {
        return (Integer)this._noNumbers();
    }

    @Override
    public long getLongValue() {
        return (Long)this._noNumbers();
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return (BigInteger)this._noNumbers();
    }

    @Override
    public float getFloatValue() {
        return ((Float)this._noNumbers()).floatValue();
    }

    @Override
    public double getDoubleValue() {
        return (Double)this._noNumbers();
    }

    @Override
    public BigDecimal getDecimalValue() {
        return (BigDecimal)this._noNumbers();
    }

    protected <T> T _noNumbers() {
        this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not numeric, can not use numeric value accessors");
        return null;
    }

    @Override
    public void _handleEOF() {
        if (this._readContext != null && !this._readContext.inRoot()) {
            this._reportInvalidEOF(": expected close marker for " + this._readContext.typeDesc(), null);
        }
    }
}

