/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.javaprop;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.dataformat.javaprop.util.JPropPathSplitter;
import com.fasterxml.jackson.dataformat.javaprop.util.Markers;
import java.io.Serializable;

public class JavaPropsSchema
implements FormatSchema,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Markers DEFAULT_INDEX_MARKER = Markers.create("[", "]");
    protected static final JavaPropsSchema EMPTY = new JavaPropsSchema();
    protected transient JPropPathSplitter _splitter;
    protected int _firstArrayOffset = 1;
    protected String _pathSeparator = ".";
    protected Markers _indexMarker = DEFAULT_INDEX_MARKER;
    protected boolean _parseSimpleIndexes = true;
    protected boolean _writeIndexUsingMarkers;
    protected String _lineIndentation = "";
    protected String _keyValueSeparator = "=";
    protected String _lineEnding = "\n";
    protected String _header = "";
    protected String _prefix;

    public JavaPropsSchema() {
    }

    public JavaPropsSchema(JavaPropsSchema javaPropsSchema) {
        this._firstArrayOffset = javaPropsSchema._firstArrayOffset;
        this._pathSeparator = javaPropsSchema._pathSeparator;
        this._indexMarker = javaPropsSchema._indexMarker;
        this._parseSimpleIndexes = javaPropsSchema._parseSimpleIndexes;
        this._writeIndexUsingMarkers = javaPropsSchema._writeIndexUsingMarkers;
        this._lineIndentation = javaPropsSchema._lineIndentation;
        this._keyValueSeparator = javaPropsSchema._keyValueSeparator;
        this._lineEnding = javaPropsSchema._lineEnding;
        this._header = javaPropsSchema._header;
        this._prefix = javaPropsSchema._prefix;
    }

    public JPropPathSplitter pathSplitter() {
        JPropPathSplitter jPropPathSplitter = this._splitter;
        if (jPropPathSplitter == null) {
            this._splitter = jPropPathSplitter = JPropPathSplitter.create(this);
        }
        return jPropPathSplitter;
    }

    public JavaPropsSchema withFirstArrayOffset(int n2) {
        if (n2 == this._firstArrayOffset) {
            return this;
        }
        JavaPropsSchema javaPropsSchema = new JavaPropsSchema(this);
        new JavaPropsSchema(this)._firstArrayOffset = n2;
        return javaPropsSchema;
    }

    public JavaPropsSchema withPathSeparator(String string) {
        if (string == null) {
            string = "";
        }
        if (this._equals(string, this._pathSeparator)) {
            return this;
        }
        JavaPropsSchema javaPropsSchema = new JavaPropsSchema(this);
        new JavaPropsSchema(this)._pathSeparator = string;
        return javaPropsSchema;
    }

    public JavaPropsSchema withoutPathSeparator() {
        if ("".equals(this._pathSeparator)) {
            return this;
        }
        JavaPropsSchema javaPropsSchema = new JavaPropsSchema(this);
        new JavaPropsSchema(this)._pathSeparator = "";
        return javaPropsSchema;
    }

    public JavaPropsSchema withIndexMarker(Markers markers) {
        if (this._equals(markers, this._indexMarker)) {
            return this;
        }
        JavaPropsSchema javaPropsSchema = new JavaPropsSchema(this);
        new JavaPropsSchema(this)._indexMarker = markers;
        return javaPropsSchema;
    }

    public JavaPropsSchema withoutIndexMarker() {
        if (this._indexMarker == null) {
            return this;
        }
        JavaPropsSchema javaPropsSchema = new JavaPropsSchema(this);
        new JavaPropsSchema(this)._indexMarker = null;
        return javaPropsSchema;
    }

    public JavaPropsSchema withParseSimpleIndexes(boolean bl) {
        if (bl == this._parseSimpleIndexes) {
            return this;
        }
        JavaPropsSchema javaPropsSchema = new JavaPropsSchema(this);
        new JavaPropsSchema(this)._parseSimpleIndexes = bl;
        return javaPropsSchema;
    }

    public JavaPropsSchema withWriteIndexUsingMarkers(boolean bl) {
        if (bl == this._writeIndexUsingMarkers) {
            return this;
        }
        JavaPropsSchema javaPropsSchema = new JavaPropsSchema(this);
        new JavaPropsSchema(this)._writeIndexUsingMarkers = bl;
        return javaPropsSchema;
    }

    public JavaPropsSchema withLineIndentation(String string) {
        if (this._equals(string, this._lineIndentation)) {
            return this;
        }
        JavaPropsSchema javaPropsSchema = new JavaPropsSchema(this);
        new JavaPropsSchema(this)._lineIndentation = string;
        return javaPropsSchema;
    }

    public JavaPropsSchema withoutLineIndentation() {
        return this.withLineIndentation("");
    }

    public JavaPropsSchema withKeyValueSeparator(String string) {
        if (this._equals(string, this._keyValueSeparator)) {
            return this;
        }
        JavaPropsSchema javaPropsSchema = new JavaPropsSchema(this);
        new JavaPropsSchema(this)._keyValueSeparator = string;
        return javaPropsSchema;
    }

    public JavaPropsSchema withLineEnding(String string) {
        if (this._equals(string, this._lineEnding)) {
            return this;
        }
        JavaPropsSchema javaPropsSchema = new JavaPropsSchema(this);
        new JavaPropsSchema(this)._lineEnding = string;
        return javaPropsSchema;
    }

    public JavaPropsSchema withPrefix(String string) {
        if (this._equals(string, this._prefix)) {
            return this;
        }
        JavaPropsSchema javaPropsSchema = new JavaPropsSchema(this);
        new JavaPropsSchema(this)._prefix = string;
        return javaPropsSchema;
    }

    public JavaPropsSchema withHeader(String string) {
        if (this._equals(string, this._header)) {
            return this;
        }
        JavaPropsSchema javaPropsSchema = new JavaPropsSchema(this);
        new JavaPropsSchema(this)._header = string;
        return javaPropsSchema;
    }

    public JavaPropsSchema withoutHeader() {
        return this.withHeader("");
    }

    @Override
    public String getSchemaType() {
        return "JavaProps";
    }

    public static JavaPropsSchema emptySchema() {
        return EMPTY;
    }

    public int firstArrayOffset() {
        return this._firstArrayOffset;
    }

    public String header() {
        return this._header;
    }

    public Markers indexMarker() {
        return this._indexMarker;
    }

    public String lineEnding() {
        return this._lineEnding;
    }

    public String lineIndentation() {
        return this._lineIndentation;
    }

    public String keyValueSeparator() {
        return this._keyValueSeparator;
    }

    public boolean parseSimpleIndexes() {
        return this._parseSimpleIndexes;
    }

    public String pathSeparator() {
        return this._pathSeparator;
    }

    public String prefix() {
        return this._prefix;
    }

    public boolean writeIndexUsingMarkers() {
        return this._writeIndexUsingMarkers && this._indexMarker != null;
    }

    private <V> boolean _equals(V v2, V v3) {
        if (v2 == null) {
            return v3 == null;
        }
        return v3 != null && v2.equals(v3);
    }
}

