/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.javaprop.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsGenerator;
import com.fasterxml.jackson.dataformat.javaprop.io.JPropEscapes;
import java.io.Writer;

public class WriterBackedGenerator
extends JavaPropsGenerator {
    protected final Writer _out;
    protected char[] _outputBuffer;
    protected int _outputTail = 0;
    protected final int _outputEnd;

    public WriterBackedGenerator(IOContext iOContext, Writer writer, int n2, ObjectCodec objectCodec) {
        super(iOContext, n2, objectCodec);
        this._out = writer;
        this._outputBuffer = iOContext.allocConcatBuffer();
        this._outputEnd = this._outputBuffer.length;
    }

    @Override
    public Object getOutputTarget() {
        return this._out;
    }

    @Override
    public void close() {
        super.close();
        this._flushBuffer();
        this._outputTail = 0;
        if (this._out != null) {
            if (this._ioContext.isResourceManaged() || ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.AUTO_CLOSE_TARGET)) {
                this._out.close();
            } else if (((JsonGenerator)this).isEnabled(JsonGenerator$Feature.FLUSH_PASSED_TO_STREAM)) {
                this._out.flush();
            }
        }
        this._releaseBuffers();
    }

    @Override
    public void flush() {
        this._flushBuffer();
        if (this._out != null && ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.FLUSH_PASSED_TO_STREAM)) {
            this._out.flush();
        }
    }

    @Override
    public void _releaseBuffers() {
        char[] cArray = this._outputBuffer;
        if (this._outputBuffer != null) {
            this._outputBuffer = null;
            this._ioContext.releaseConcatBuffer(cArray);
        }
    }

    protected void _flushBuffer() {
        if (this._outputTail > 0) {
            this._out.write(this._outputBuffer, 0, this._outputTail);
            this._outputTail = 0;
        }
    }

    @Override
    public void _appendFieldName(StringBuilder stringBuilder, String string) {
        JPropEscapes.appendKey(this._basePath, string);
    }

    @Override
    public void _writeEscapedEntry(String string) {
        WriterBackedGenerator writerBackedGenerator = this;
        writerBackedGenerator._writeRaw(writerBackedGenerator._basePath);
        WriterBackedGenerator writerBackedGenerator2 = this;
        writerBackedGenerator2._writeRaw(writerBackedGenerator2._schema.keyValueSeparator());
        this._writeEscaped(string);
        this._writeLinefeed();
    }

    @Override
    public void _writeEscapedEntry(char[] cArray, int n2, int n3) {
        WriterBackedGenerator writerBackedGenerator = this;
        writerBackedGenerator._writeRaw(writerBackedGenerator._basePath);
        WriterBackedGenerator writerBackedGenerator2 = this;
        writerBackedGenerator2._writeRaw(writerBackedGenerator2._schema.keyValueSeparator());
        this._writeEscaped(cArray, n2, n3);
        this._writeLinefeed();
    }

    @Override
    public void _writeUnescapedEntry(String string) {
        WriterBackedGenerator writerBackedGenerator = this;
        writerBackedGenerator._writeRaw(writerBackedGenerator._basePath);
        WriterBackedGenerator writerBackedGenerator2 = this;
        writerBackedGenerator2._writeRaw(writerBackedGenerator2._schema.keyValueSeparator());
        this._writeRaw(string);
        this._writeLinefeed();
    }

    protected void _writeEscaped(String string) {
        StringBuilder stringBuilder = JPropEscapes.appendValue(string);
        if (stringBuilder == null) {
            this._writeRaw(string);
            return;
        }
        this._writeRaw(stringBuilder);
    }

    protected void _writeEscaped(char[] cArray, int n2, int n3) {
        this._writeEscaped(new String(cArray, n2, n3));
    }

    protected void _writeLinefeed() {
        WriterBackedGenerator writerBackedGenerator = this;
        writerBackedGenerator._writeRaw(writerBackedGenerator._schema.lineEnding());
    }

    @Override
    public void _writeRaw(char c2) {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = c2;
    }

    @Override
    public void _writeRaw(String string) {
        int n2 = string.length();
        int n3 = this._outputEnd - this._outputTail;
        if (n3 == 0) {
            this._flushBuffer();
            n3 = this._outputEnd - this._outputTail;
        }
        if (n3 >= n2) {
            string.getChars(0, n2, this._outputBuffer, this._outputTail);
            this._outputTail += n2;
            return;
        }
        this._writeRawLong(string);
    }

    @Override
    public void _writeRaw(StringBuilder stringBuilder) {
        int n2 = stringBuilder.length();
        int n3 = this._outputEnd - this._outputTail;
        if (n3 == 0) {
            this._flushBuffer();
            n3 = this._outputEnd - this._outputTail;
        }
        if (n3 >= n2) {
            stringBuilder.getChars(0, n2, this._outputBuffer, this._outputTail);
            this._outputTail += n2;
            return;
        }
        this._writeRawLong(stringBuilder);
    }

    @Override
    public void _writeRaw(char[] cArray, int n2, int n3) {
        if (n3 < 100) {
            int n4 = this._outputEnd - this._outputTail;
            if (n3 > n4) {
                this._flushBuffer();
            }
            System.arraycopy(cArray, n2, this._outputBuffer, this._outputTail, n3);
            this._outputTail += n3;
            return;
        }
        this._flushBuffer();
        this._out.write(cArray, n2, n3);
    }

    protected void _writeRawLong(String string) {
        int n2;
        int n3 = this._outputEnd - this._outputTail;
        string.getChars(0, n3, this._outputBuffer, this._outputTail);
        this._outputTail += n3;
        this._flushBuffer();
        int n4 = n3;
        for (n3 = string.length() - n3; n3 > this._outputEnd; n3 -= n2) {
            n2 = this._outputEnd;
            int n5 = n4;
            string.getChars(n5, n5 + n2, this._outputBuffer, 0);
            this._outputTail = n2;
            this._flushBuffer();
            n4 += n2;
        }
        int n6 = n4;
        string.getChars(n6, n6 + n3, this._outputBuffer, 0);
        this._outputTail = n3;
    }

    protected void _writeRawLong(StringBuilder stringBuilder) {
        int n2;
        int n3 = this._outputEnd - this._outputTail;
        stringBuilder.getChars(0, n3, this._outputBuffer, this._outputTail);
        this._outputTail += n3;
        this._flushBuffer();
        int n4 = n3;
        for (n3 = stringBuilder.length() - n3; n3 > this._outputEnd; n3 -= n2) {
            n2 = this._outputEnd;
            int n5 = n4;
            stringBuilder.getChars(n5, n5 + n2, this._outputBuffer, 0);
            this._outputTail = n2;
            this._flushBuffer();
            n4 += n2;
        }
        int n6 = n4;
        stringBuilder.getChars(n6, n6 + n3, this._outputBuffer, 0);
        this._outputTail = n3;
    }
}

