/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.javaprop.io;

import java.util.Arrays;

public class JPropEscapes {
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();
    private static final int UNICODE_ESCAPE = -1;
    private static final int[] sValueEscapes;
    private static final int[] sKeyEscapes;

    public static void appendKey(StringBuilder stringBuilder, String string) {
        char c2;
        int n2 = string.length();
        if (n2 == 0) {
            return;
        }
        int[] nArray = sKeyEscapes;
        int n3 = 0;
        while ((c2 = string.charAt(n3)) <= '\u00ff' && nArray[c2] == 0) {
            stringBuilder.append(c2);
            if (++n3 != n2) continue;
            return;
        }
        JPropEscapes._appendWithEscapes(stringBuilder, string, nArray, n3);
    }

    public static StringBuilder appendValue(String string) {
        char c2;
        int n2 = string.length();
        if (n2 == 0) {
            return null;
        }
        int[] nArray = sValueEscapes;
        int n3 = 0;
        while ((c2 = string.charAt(n3)) <= '\u00ff' && nArray[c2] == 0) {
            if (++n3 != n2) continue;
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(n2 + 5 + (n2 >> 3));
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuilder.append(string.charAt(n2));
        }
        JPropEscapes._appendWithEscapes(stringBuilder, string, nArray, n3);
        return stringBuilder;
    }

    private static void _appendWithEscapes(StringBuilder stringBuilder, String string, int[] nArray, int n2) {
        int n3 = string.length();
        do {
            char c2;
            int n4;
            if ((n4 = (c2 = string.charAt(n2)) > '\u00ff' ? -1 : nArray[c2]) == 0) {
                stringBuilder.append(c2);
                continue;
            }
            if (n4 == -1) {
                stringBuilder.append('\\');
                stringBuilder.append('u');
                stringBuilder.append(HEX[c2 >>> 12]);
                stringBuilder.append(HEX[c2 >> 8 & 0xF]);
                stringBuilder.append(HEX[c2 >> 4 & 0xF]);
                stringBuilder.append(HEX[c2 & 0xF]);
                continue;
            }
            stringBuilder.append('\\');
            stringBuilder.append((char)n4);
        } while (++n2 < n3);
    }

    static {
        int[] nArray = new int[256];
        for (int i2 = 0; i2 < 32; ++i2) {
            nArray[i2] = -1;
            nArray[i2 + 128] = -1;
        }
        nArray[127] = -1;
        nArray[9] = 116;
        nArray[13] = 114;
        nArray[10] = 110;
        nArray[92] = 92;
        sValueEscapes = nArray;
        int[] nArray2 = Arrays.copyOf(nArray, 256);
        nArray = nArray2;
        nArray2[35] = 35;
        nArray[33] = 33;
        nArray[61] = 61;
        nArray[58] = 58;
        nArray[32] = 32;
        sKeyEscapes = nArray;
    }
}

