/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.javaprop.io;

import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.javaprop.io.JPropReadContext$ArrayContext;
import com.fasterxml.jackson.dataformat.javaprop.io.JPropReadContext$ObjectContext;
import com.fasterxml.jackson.dataformat.javaprop.util.JPropNode;

public abstract class JPropReadContext
extends JsonStreamContext {
    protected final JPropReadContext _parent;
    protected String _currentName;
    protected String _currentText;
    protected Object _currentValue;
    protected JPropNode _nextNode;
    protected String _branchText;
    protected int _state;

    public JPropReadContext(int n2, JPropReadContext jPropReadContext, JPropNode jPropNode) {
        this._type = n2;
        this._index = -1;
        this._parent = jPropReadContext;
        this._branchText = jPropNode.getValue();
    }

    public static JPropReadContext create(JPropNode jPropNode) {
        if (jPropNode.isArray()) {
            return new JPropReadContext$ArrayContext(null, jPropNode);
        }
        return new JPropReadContext$ObjectContext(null, jPropNode);
    }

    @Override
    public final JPropReadContext getParent() {
        return this._parent;
    }

    @Override
    public final String getCurrentName() {
        return this._currentName;
    }

    public void overrideCurrentName(String string) {
        this._currentName = string;
    }

    @Override
    public Object getCurrentValue() {
        return this._currentValue;
    }

    @Override
    public void setCurrentValue(Object object) {
        this._currentValue = object;
    }

    public abstract JsonToken nextToken();

    public JPropReadContext nextContext() {
        JPropNode jPropNode = this._nextNode;
        if (jPropNode == null) {
            return this._parent;
        }
        this._nextNode = null;
        if (jPropNode.isArray()) {
            return new JPropReadContext$ArrayContext(this, jPropNode);
        }
        return new JPropReadContext$ObjectContext(this, jPropNode);
    }

    public String getCurrentText() {
        return this._currentText;
    }
}

