/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.javaprop.io;

import com.fasterxml.jackson.core.JsonStreamContext;

public class JPropWriteContext
extends JsonStreamContext {
    protected final JPropWriteContext _parent;
    protected JPropWriteContext _child = null;
    protected Object _currentValue;
    protected boolean _gotName;
    protected String _currentName;
    protected int _basePathLength;

    protected JPropWriteContext(int n2, JPropWriteContext jPropWriteContext, int n3) {
        this._type = n2;
        this._parent = jPropWriteContext;
        this._basePathLength = n3;
        this._index = -1;
    }

    private void reset(int n2, int n3) {
        this._type = n2;
        this._basePathLength = n3;
        this._currentValue = null;
        this._index = -1;
    }

    public static JPropWriteContext createRootContext() {
        return new JPropWriteContext(0, null, 0);
    }

    public static JPropWriteContext createRootContext(int n2) {
        return new JPropWriteContext(0, null, n2);
    }

    public JPropWriteContext createChildArrayContext(int n2) {
        JPropWriteContext jPropWriteContext = this._child;
        if (jPropWriteContext == null) {
            this._child = jPropWriteContext = new JPropWriteContext(1, this, n2);
            return jPropWriteContext;
        }
        jPropWriteContext.reset(1, n2);
        return jPropWriteContext;
    }

    public JPropWriteContext createChildObjectContext(int n2) {
        JPropWriteContext jPropWriteContext = this._child;
        if (jPropWriteContext == null) {
            this._child = jPropWriteContext = new JPropWriteContext(2, this, n2);
            return jPropWriteContext;
        }
        jPropWriteContext.reset(2, n2);
        return jPropWriteContext;
    }

    public boolean writeFieldName(String string) {
        if (this._gotName) {
            return false;
        }
        this._gotName = true;
        this._currentName = string;
        return true;
    }

    public boolean writeValue() {
        if (this._type == 2) {
            if (!this._gotName) {
                return false;
            }
            this._gotName = false;
        }
        ++this._index;
        return true;
    }

    public void truncatePath(StringBuilder stringBuilder) {
        int n2 = stringBuilder.length();
        if (n2 != this._basePathLength) {
            if (n2 < this._basePathLength) {
                throw new IllegalStateException(String.format("Internal error: base path length %d, buffered %d, trying to truncate", this._basePathLength, n2));
            }
            stringBuilder.setLength(this._basePathLength);
        }
    }

    @Override
    public final JPropWriteContext getParent() {
        return this._parent;
    }

    @Override
    public String getCurrentName() {
        return this._currentName;
    }

    @Override
    public Object getCurrentValue() {
        return this._currentValue;
    }

    @Override
    public void setCurrentValue(Object object) {
        this._currentValue = object;
    }

    public StringBuilder appendDesc(StringBuilder stringBuilder) {
        if (this._parent != null) {
            stringBuilder = this._parent.appendDesc(stringBuilder);
            stringBuilder.append('/');
        }
        switch (this._type) {
            case 2: {
                if (this._currentName == null) break;
                stringBuilder.append(this._currentName);
                break;
            }
            case 1: {
                stringBuilder.append(this.getCurrentIndex());
            }
        }
        return stringBuilder;
    }

    @Override
    public final String toString() {
        return this.appendDesc(new StringBuilder(64)).toString();
    }
}

