/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.javaprop.io;

import com.fasterxml.jackson.core.io.IOContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public final class Latin1Reader
extends Reader {
    private final IOContext _ioContext;
    private InputStream _inputSource;
    private byte[] _inputBuffer;
    private int _inputPtr;
    private int _inputEnd;
    private int _charCount = 0;
    private char[] _tmpBuffer = null;

    public Latin1Reader(byte[] byArray, int n2, int n3) {
        super(new Object());
        this._ioContext = null;
        this._inputSource = null;
        this._inputBuffer = byArray;
        this._inputPtr = n2;
        this._inputEnd = n2 + n3;
    }

    public Latin1Reader(IOContext iOContext, InputStream inputStream) {
        super(inputStream);
        this._ioContext = iOContext;
        this._inputSource = inputStream;
        this._inputBuffer = iOContext.allocReadIOBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
    }

    public final int getReadCharsCount() {
        return this._charCount;
    }

    @Override
    public final void close() {
        InputStream inputStream = this._inputSource;
        if (inputStream != null) {
            this._inputSource = null;
            this.freeBuffers();
            inputStream.close();
        }
    }

    @Override
    public final int read() {
        if (this._tmpBuffer == null) {
            this._tmpBuffer = new char[1];
        }
        Latin1Reader latin1Reader = this;
        if (latin1Reader.read(latin1Reader._tmpBuffer, 0, 1) <= 0) {
            return -1;
        }
        return this._tmpBuffer[0];
    }

    @Override
    public final int read(char[] cArray) {
        return this.read(cArray, 0, cArray.length);
    }

    @Override
    public final int read(char[] cArray, int n2, int n3) {
        if (this._inputBuffer == null) {
            return -1;
        }
        if (n3 <= 0) {
            return n3;
        }
        int n4 = this._inputEnd - this._inputPtr;
        if (n4 <= 0) {
            if (!this.loadMore()) {
                return -1;
            }
            n4 = this._inputEnd - this._inputPtr;
        }
        if (n4 > n3) {
            n4 = n3;
        }
        byte[] byArray = this._inputBuffer;
        int n5 = this._inputPtr;
        int n6 = n5 + n4;
        do {
            cArray[n2++] = (char)byArray[n5++];
        } while (n5 < n6);
        this._inputPtr = n5;
        return n4;
    }

    private boolean loadMore() {
        this._charCount += this._inputEnd;
        this._inputPtr = 0;
        this._inputEnd = 0;
        if (this._inputSource == null) {
            this.freeBuffers();
            return false;
        }
        int n2 = this._inputSource.read(this._inputBuffer, 0, this._inputBuffer.length);
        if (n2 <= 0) {
            this.freeBuffers();
            if (n2 < 0) {
                return false;
            }
            throw new IOException("Strange I/O stream, returned 0 bytes on read");
        }
        this._inputEnd = n2;
        return true;
    }

    private final void freeBuffers() {
        if (this._ioContext != null) {
            byte[] byArray = this._inputBuffer;
            if (this._inputBuffer != null) {
                this._inputBuffer = null;
                this._ioContext.releaseReadIOBuffer(byArray);
            }
        }
    }
}

