/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.javaprop.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class JPropNode {
    protected String _value;
    protected TreeMap<Integer, JPropNode> _byIndex;
    protected Map<String, JPropNode> _byName;
    protected boolean _hasContents = false;

    public JPropNode setValue(String string) {
        this._value = string;
        return this;
    }

    public JPropNode addByIndex(int n2) {
        Integer n3;
        JPropNode jPropNode;
        if (this._byName != null) {
            return this.addByName(String.valueOf(n2));
        }
        this._hasContents = true;
        if (this._byIndex == null) {
            this._byIndex = new TreeMap();
        }
        if ((jPropNode = this._byIndex.get(n3 = Integer.valueOf(n2))) == null) {
            jPropNode = new JPropNode();
            this._byIndex.put(n3, jPropNode);
        }
        return jPropNode;
    }

    public JPropNode addByName(String string) {
        Object object;
        this._hasContents = true;
        if (this._byIndex != null) {
            if (this._byName == null) {
                this._byName = new LinkedHashMap<String, JPropNode>();
            }
            for (Map.Entry entry : this._byIndex.entrySet()) {
                this._byName.put(((Integer)entry.getKey()).toString(), (JPropNode)entry.getValue());
            }
            this._byIndex = null;
        }
        if (this._byName == null) {
            this._byName = new LinkedHashMap<String, JPropNode>();
        } else {
            object = this._byName.get(string);
            if (object != null) {
                return object;
            }
        }
        object = new JPropNode();
        this._byName.put(string, (JPropNode)object);
        return object;
    }

    public boolean isLeaf() {
        return !this._hasContents && this._value != null;
    }

    public boolean isArray() {
        return this._byIndex != null;
    }

    public String getValue() {
        return this._value;
    }

    public Iterator<JPropNode> arrayContents() {
        return this._byIndex.values().iterator();
    }

    public Iterator<Map.Entry<String, JPropNode>> objectContents() {
        if (this._byName == null) {
            return Collections.emptyIterator();
        }
        return this._byName.entrySet().iterator();
    }

    public Object asRaw() {
        if (this.isArray()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (this._value != null) {
                arrayList.add(this._value);
            }
            for (JPropNode jPropNode : this._byIndex.values()) {
                arrayList.add(jPropNode.asRaw());
            }
            return arrayList;
        }
        if (this._byName != null) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            if (this._value != null) {
                linkedHashMap.put("", this._value);
            }
            for (Map.Entry<String, JPropNode> entry : this._byName.entrySet()) {
                linkedHashMap.put(entry.getKey(), entry.getValue().asRaw());
            }
            return linkedHashMap;
        }
        return this._value;
    }
}

