/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.javaprop.util;

import com.fasterxml.jackson.dataformat.javaprop.JavaPropsSchema;
import com.fasterxml.jackson.dataformat.javaprop.util.JPropNode;
import com.fasterxml.jackson.dataformat.javaprop.util.JPropPathSplitter$CharPathOnlySplitter;
import com.fasterxml.jackson.dataformat.javaprop.util.JPropPathSplitter$FullSplitter;
import com.fasterxml.jackson.dataformat.javaprop.util.JPropPathSplitter$IndexOnlySplitter;
import com.fasterxml.jackson.dataformat.javaprop.util.JPropPathSplitter$NonSplitting;
import com.fasterxml.jackson.dataformat.javaprop.util.JPropPathSplitter$StringPathOnlySplitter;
import com.fasterxml.jackson.dataformat.javaprop.util.Markers;

public abstract class JPropPathSplitter {
    protected final boolean _useSimpleIndex;

    protected JPropPathSplitter(boolean bl) {
        this._useSimpleIndex = bl;
    }

    public static JPropPathSplitter create(JavaPropsSchema javaPropsSchema) {
        String string = javaPropsSchema.pathSeparator();
        Markers markers = javaPropsSchema.indexMarker();
        if (markers == null) {
            return JPropPathSplitter.pathOnlySplitter(javaPropsSchema);
        }
        if (string.isEmpty()) {
            return new JPropPathSplitter$IndexOnlySplitter(javaPropsSchema.parseSimpleIndexes(), markers);
        }
        return new JPropPathSplitter$FullSplitter(string, javaPropsSchema.parseSimpleIndexes(), markers, JPropPathSplitter.pathOnlySplitter(javaPropsSchema), javaPropsSchema.prefix());
    }

    private static JPropPathSplitter pathOnlySplitter(JavaPropsSchema javaPropsSchema) {
        String string = javaPropsSchema.pathSeparator();
        if (string.isEmpty()) {
            return JPropPathSplitter$NonSplitting.instance;
        }
        if (string.length() == 1) {
            return new JPropPathSplitter$CharPathOnlySplitter(string.charAt(0), javaPropsSchema.parseSimpleIndexes());
        }
        return new JPropPathSplitter$StringPathOnlySplitter(string, javaPropsSchema.parseSimpleIndexes());
    }

    public abstract JPropNode splitAndAdd(JPropNode var1, String var2, String var3);

    protected JPropNode _addSegment(JPropNode jPropNode, String string) {
        int n2;
        if (this._useSimpleIndex && (n2 = this._asInt(string)) >= 0) {
            return jPropNode.addByIndex(n2);
        }
        return jPropNode.addByName(string);
    }

    protected JPropNode _lastSegment(JPropNode jPropNode, String string, int n2, int n3) {
        if (n2 < n3) {
            if (n2 > 0) {
                string = string.substring(n2);
            }
            jPropNode = this._addSegment(jPropNode, string);
        }
        return jPropNode;
    }

    protected int _asInt(String string) {
        int n2 = string.length();
        if (n2 == 0 || n2 > 9) {
            return -1;
        }
        char c2 = string.charAt(0);
        if (c2 > '9' || c2 < '0') {
            return -1;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            c2 = string.charAt(i2);
            if (c2 <= '9' && c2 >= '0') continue;
            return -1;
        }
        return Integer.parseInt(string);
    }
}

