/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.yaml;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.yaml.PackageVersion;
import com.fasterxml.jackson.dataformat.yaml.UTF8Reader;
import com.fasterxml.jackson.dataformat.yaml.UTF8Writer;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactoryBuilder;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator$Feature;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser$Feature;
import com.fasterxml.jackson.dataformat.yaml.util.StringQuotingChecker;
import com.fasterxml.jackson.dataformat.yaml.util.StringQuotingChecker$Default;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import org.yaml.snakeyaml.DumperOptions;

public class YAMLFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String FORMAT_NAME_YAML = "YAML";
    protected static final int DEFAULT_YAML_PARSER_FEATURE_FLAGS = YAMLParser$Feature.collectDefaults();
    protected static final int DEFAULT_YAML_GENERATOR_FEATURE_FLAGS = YAMLGenerator$Feature.collectDefaults();
    private static final byte UTF8_BOM_1 = -17;
    private static final byte UTF8_BOM_2 = -69;
    private static final byte UTF8_BOM_3 = -65;
    protected int _yamlParserFeatures = DEFAULT_YAML_PARSER_FEATURE_FLAGS;
    protected int _yamlGeneratorFeatures = DEFAULT_YAML_GENERATOR_FEATURE_FLAGS;
    protected final DumperOptions.Version _version;
    protected final StringQuotingChecker _quotingChecker;

    public YAMLFactory() {
        this((ObjectCodec)null);
    }

    public YAMLFactory(ObjectCodec objectCodec) {
        super(objectCodec);
        this._yamlParserFeatures = DEFAULT_YAML_PARSER_FEATURE_FLAGS;
        this._yamlGeneratorFeatures = DEFAULT_YAML_GENERATOR_FEATURE_FLAGS;
        this._version = null;
        this._quotingChecker = StringQuotingChecker$Default.instance();
    }

    public YAMLFactory(YAMLFactory yAMLFactory, ObjectCodec objectCodec) {
        super(yAMLFactory, objectCodec);
        this._yamlParserFeatures = yAMLFactory._yamlParserFeatures;
        this._yamlGeneratorFeatures = yAMLFactory._yamlGeneratorFeatures;
        this._version = yAMLFactory._version;
        this._quotingChecker = yAMLFactory._quotingChecker;
    }

    protected YAMLFactory(YAMLFactoryBuilder yAMLFactoryBuilder) {
        super(yAMLFactoryBuilder, false);
        this._yamlGeneratorFeatures = yAMLFactoryBuilder.formatGeneratorFeaturesMask();
        this._version = yAMLFactoryBuilder.yamlVersionToWrite();
        this._quotingChecker = yAMLFactoryBuilder.stringQuotingChecker();
    }

    public YAMLFactoryBuilder rebuild() {
        return new YAMLFactoryBuilder(this);
    }

    public static YAMLFactoryBuilder builder() {
        return new YAMLFactoryBuilder();
    }

    @Override
    public YAMLFactory copy() {
        this._checkInvalidCopy(YAMLFactory.class);
        return new YAMLFactory(this, null);
    }

    @Override
    public Object readResolve() {
        YAMLFactory yAMLFactory = this;
        return new YAMLFactory(yAMLFactory, yAMLFactory._objectCodec);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public boolean canUseCharArrays() {
        return false;
    }

    public Class<YAMLParser$Feature> getFormatReadFeatureType() {
        return YAMLParser$Feature.class;
    }

    public Class<YAMLGenerator$Feature> getFormatWriteFeatureType() {
        return YAMLGenerator$Feature.class;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME_YAML;
    }

    @Override
    public MatchStrength hasFormat(InputAccessor inputAccessor) {
        if (!inputAccessor.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte by = inputAccessor.nextByte();
        if (by == -17) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -69) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -65) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            by = inputAccessor.nextByte();
        }
        if (by == 45 && inputAccessor.hasMoreBytes() && inputAccessor.nextByte() == 45 && inputAccessor.hasMoreBytes() && inputAccessor.nextByte() == 45) {
            return MatchStrength.FULL_MATCH;
        }
        return MatchStrength.INCONCLUSIVE;
    }

    public final YAMLFactory configure(YAMLParser$Feature yAMLParser$Feature, boolean bl) {
        if (bl) {
            this.enable(yAMLParser$Feature);
        } else {
            this.disable(yAMLParser$Feature);
        }
        return this;
    }

    public YAMLFactory enable(YAMLParser$Feature yAMLParser$Feature) {
        this._yamlParserFeatures |= yAMLParser$Feature.getMask();
        return this;
    }

    public YAMLFactory disable(YAMLParser$Feature yAMLParser$Feature) {
        this._yamlParserFeatures &= ~yAMLParser$Feature.getMask();
        return this;
    }

    public final boolean isEnabled(YAMLParser$Feature yAMLParser$Feature) {
        return (this._yamlParserFeatures & yAMLParser$Feature.getMask()) != 0;
    }

    @Override
    public int getFormatParserFeatures() {
        return this._yamlParserFeatures;
    }

    public final YAMLFactory configure(YAMLGenerator$Feature yAMLGenerator$Feature, boolean bl) {
        if (bl) {
            this.enable(yAMLGenerator$Feature);
        } else {
            this.disable(yAMLGenerator$Feature);
        }
        return this;
    }

    public YAMLFactory enable(YAMLGenerator$Feature yAMLGenerator$Feature) {
        this._yamlGeneratorFeatures |= yAMLGenerator$Feature.getMask();
        return this;
    }

    public YAMLFactory disable(YAMLGenerator$Feature yAMLGenerator$Feature) {
        this._yamlGeneratorFeatures &= ~yAMLGenerator$Feature.getMask();
        return this;
    }

    public final boolean isEnabled(YAMLGenerator$Feature yAMLGenerator$Feature) {
        return (this._yamlGeneratorFeatures & yAMLGenerator$Feature.getMask()) != 0;
    }

    @Override
    public int getFormatGeneratorFeatures() {
        return this._yamlGeneratorFeatures;
    }

    @Override
    public YAMLParser createParser(String string) {
        return this.createParser(new StringReader(string));
    }

    @Override
    public YAMLParser createParser(File file) {
        YAMLFactory yAMLFactory = this;
        IOContext iOContext = yAMLFactory._createContext(yAMLFactory._createContentReference(file), true);
        YAMLFactory yAMLFactory2 = this;
        return yAMLFactory2._createParser(yAMLFactory2._decorate(new FileInputStream(file), iOContext), iOContext);
    }

    @Override
    public YAMLParser createParser(URL uRL) {
        YAMLFactory yAMLFactory = this;
        IOContext iOContext = yAMLFactory._createContext(yAMLFactory._createContentReference(uRL), true);
        YAMLFactory yAMLFactory2 = this;
        return yAMLFactory2._createParser(yAMLFactory2._decorate(this._optimizedStreamFromURL(uRL), iOContext), iOContext);
    }

    @Override
    public YAMLParser createParser(InputStream inputStream) {
        YAMLFactory yAMLFactory = this;
        IOContext iOContext = yAMLFactory._createContext(yAMLFactory._createContentReference(inputStream), false);
        YAMLFactory yAMLFactory2 = this;
        return yAMLFactory2._createParser(yAMLFactory2._decorate(inputStream, iOContext), iOContext);
    }

    @Override
    public YAMLParser createParser(Reader reader) {
        YAMLFactory yAMLFactory = this;
        IOContext iOContext = yAMLFactory._createContext(yAMLFactory._createContentReference(reader), false);
        YAMLFactory yAMLFactory2 = this;
        return yAMLFactory2._createParser(yAMLFactory2._decorate(reader, iOContext), iOContext);
    }

    @Override
    public YAMLParser createParser(char[] cArray) {
        return this.createParser(cArray, 0, cArray.length);
    }

    @Override
    public YAMLParser createParser(char[] cArray, int n2, int n3) {
        return this.createParser(new CharArrayReader(cArray, n2, n3));
    }

    @Override
    public YAMLParser createParser(byte[] byArray) {
        InputStream inputStream;
        YAMLFactory yAMLFactory = this;
        IOContext iOContext = yAMLFactory._createContext(yAMLFactory._createContentReference(byArray), true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, 0, byArray.length)) != null) {
            return this._createParser(inputStream, iOContext);
        }
        return this._createParser(byArray, 0, byArray.length, iOContext);
    }

    @Override
    public YAMLParser createParser(byte[] byArray, int n2, int n3) {
        InputStream inputStream;
        YAMLFactory yAMLFactory = this;
        IOContext iOContext = yAMLFactory._createContext(yAMLFactory._createContentReference(byArray, n2, n3), true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, n2, n3)) != null) {
            return this._createParser(inputStream, iOContext);
        }
        return this._createParser(byArray, n2, n3, iOContext);
    }

    @Override
    public YAMLGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) {
        YAMLFactory yAMLFactory = this;
        IOContext iOContext = yAMLFactory._createContext(yAMLFactory._createContentReference(outputStream), false);
        iOContext.setEncoding(jsonEncoding);
        YAMLFactory yAMLFactory2 = this;
        return yAMLFactory2._createGenerator(yAMLFactory2._createWriter(this._decorate(outputStream, iOContext), jsonEncoding, iOContext), iOContext);
    }

    @Override
    public YAMLGenerator createGenerator(OutputStream outputStream) {
        YAMLFactory yAMLFactory = this;
        IOContext iOContext = yAMLFactory._createContext(yAMLFactory._createContentReference(outputStream), false);
        YAMLFactory yAMLFactory2 = this;
        return yAMLFactory2._createGenerator(yAMLFactory2._createWriter(this._decorate(outputStream, iOContext), JsonEncoding.UTF8, iOContext), iOContext);
    }

    @Override
    public YAMLGenerator createGenerator(Writer writer) {
        YAMLFactory yAMLFactory = this;
        IOContext iOContext = yAMLFactory._createContext(yAMLFactory._createContentReference(writer), false);
        YAMLFactory yAMLFactory2 = this;
        return yAMLFactory2._createGenerator(yAMLFactory2._decorate(writer, iOContext), iOContext);
    }

    @Override
    public JsonGenerator createGenerator(File object, JsonEncoding jsonEncoding) {
        FileOutputStream fileOutputStream = new FileOutputStream((File)object);
        YAMLFactory yAMLFactory = this;
        object = yAMLFactory._createContext(yAMLFactory._createContentReference(object), true);
        ((IOContext)object).setEncoding(jsonEncoding);
        YAMLFactory yAMLFactory2 = this;
        return yAMLFactory2._createGenerator(yAMLFactory2._createWriter(this._decorate(fileOutputStream, (IOContext)object), jsonEncoding, (IOContext)object), (IOContext)object);
    }

    @Override
    protected YAMLParser _createParser(InputStream inputStream, IOContext iOContext) {
        return new YAMLParser(iOContext, this._getBufferRecycler(), this._parserFeatures, this._yamlParserFeatures, this._objectCodec, this._createReader(inputStream, null, iOContext));
    }

    @Override
    protected YAMLParser _createParser(Reader reader, IOContext iOContext) {
        return new YAMLParser(iOContext, this._getBufferRecycler(), this._parserFeatures, this._yamlParserFeatures, this._objectCodec, reader);
    }

    @Override
    protected YAMLParser _createParser(char[] cArray, int n2, int n3, IOContext iOContext, boolean bl) {
        return new YAMLParser(iOContext, this._getBufferRecycler(), this._parserFeatures, this._yamlParserFeatures, this._objectCodec, new CharArrayReader(cArray, n2, n3));
    }

    @Override
    protected YAMLParser _createParser(byte[] byArray, int n2, int n3, IOContext iOContext) {
        return new YAMLParser(iOContext, this._getBufferRecycler(), this._parserFeatures, this._yamlParserFeatures, this._objectCodec, this._createReader(byArray, n2, n3, null, iOContext));
    }

    @Override
    protected YAMLGenerator _createGenerator(Writer closeable, IOContext iOContext) {
        int n2 = this._yamlGeneratorFeatures;
        closeable = new YAMLGenerator(iOContext, this._generatorFeatures, n2, this._quotingChecker, this._objectCodec, (Writer)closeable, this._version);
        return closeable;
    }

    @Override
    protected YAMLGenerator _createUTF8Generator(OutputStream outputStream, IOContext iOContext) {
        throw new IllegalStateException();
    }

    @Override
    public Writer _createWriter(OutputStream outputStream, JsonEncoding jsonEncoding, IOContext iOContext) {
        if (jsonEncoding == JsonEncoding.UTF8) {
            return new UTF8Writer(outputStream);
        }
        return new OutputStreamWriter(outputStream, jsonEncoding.getJavaName());
    }

    protected Reader _createReader(InputStream inputStream, JsonEncoding jsonEncoding, IOContext iOContext) {
        if (jsonEncoding == null) {
            jsonEncoding = JsonEncoding.UTF8;
        }
        if (jsonEncoding == JsonEncoding.UTF8) {
            boolean bl = iOContext.isResourceManaged() || ((TokenStreamFactory)this).isEnabled(JsonParser$Feature.AUTO_CLOSE_SOURCE);
            return new UTF8Reader(inputStream, bl);
        }
        return new InputStreamReader(inputStream, jsonEncoding.getJavaName());
    }

    protected Reader _createReader(byte[] object, int n2, int n3, JsonEncoding jsonEncoding, IOContext iOContext) {
        if (jsonEncoding == null) {
            jsonEncoding = JsonEncoding.UTF8;
        }
        if (jsonEncoding == null || jsonEncoding == JsonEncoding.UTF8) {
            return new UTF8Reader((byte[])object, n2, n3, true);
        }
        object = new ByteArrayInputStream((byte[])object, n2, n3);
        return new InputStreamReader((InputStream)object, jsonEncoding.getJavaName());
    }
}

