/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.yaml;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamWriteCapability;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.dataformat.yaml.PackageVersion;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator$Feature;
import com.fasterxml.jackson.dataformat.yaml.util.StringQuotingChecker;
import com.fasterxml.jackson.dataformat.yaml.util.StringQuotingChecker$Default;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.DumperOptions$FlowStyle;
import org.yaml.snakeyaml.DumperOptions$LineBreak;
import org.yaml.snakeyaml.DumperOptions$ScalarStyle;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ImplicitTuple;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;
import org.yaml.snakeyaml.nodes.Tag;

public class YAMLGenerator
extends GeneratorBase {
    protected static final long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    protected static final long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    protected static final Pattern PLAIN_NUMBER_P = Pattern.compile("-?[0-9]*(\\.[0-9]*)?");
    protected static final String TAG_BINARY = Tag.BINARY.toString();
    protected final IOContext _ioContext;
    protected int _formatFeatures;
    protected Writer _writer;
    protected DumperOptions _outputOptions;
    protected final DumperOptions.Version _docVersion;
    private static final DumperOptions$ScalarStyle STYLE_UNQUOTED_NAME = DumperOptions$ScalarStyle.PLAIN;
    private static final DumperOptions$ScalarStyle STYLE_SCALAR = DumperOptions$ScalarStyle.PLAIN;
    private static final DumperOptions$ScalarStyle STYLE_QUOTED = DumperOptions$ScalarStyle.DOUBLE_QUOTED;
    private static final DumperOptions$ScalarStyle STYLE_LITERAL;
    private static final DumperOptions$ScalarStyle STYLE_BASE64;
    private static final DumperOptions$ScalarStyle STYLE_PLAIN;
    protected Emitter _emitter;
    protected String _objectId;
    protected String _typeId;
    protected int _rootValueCount;
    protected final StringQuotingChecker _quotingChecker;
    private static final ImplicitTuple NO_TAGS;
    private static final ImplicitTuple EXPLICIT_TAGS;

    public YAMLGenerator(IOContext iOContext, int n2, int n3, StringQuotingChecker stringQuotingChecker, ObjectCodec objectCodec, Writer writer, DumperOptions.Version version) {
        super(n2, objectCodec);
        this._ioContext = iOContext;
        this._formatFeatures = n3;
        this._quotingChecker = stringQuotingChecker == null ? StringQuotingChecker$Default.instance() : stringQuotingChecker;
        this._writer = writer;
        this._docVersion = version;
        this._outputOptions = this.buildDumperOptions(n2, n3, version);
        this._emitter = new Emitter(this._writer, this._outputOptions);
        this._emit(new StreamStartEvent(null, null));
        this._emitStartDocument();
    }

    @Deprecated
    public YAMLGenerator(IOContext iOContext, int n2, int n3, ObjectCodec objectCodec, Writer writer, DumperOptions.Version version) {
        this(iOContext, n2, n3, null, objectCodec, writer, version);
    }

    protected DumperOptions buildDumperOptions(int n2, int n3, DumperOptions.Version version) {
        DumperOptions dumperOptions = new DumperOptions();
        if (YAMLGenerator$Feature.CANONICAL_OUTPUT.enabledIn(this._formatFeatures)) {
            dumperOptions.setCanonical(true);
        } else {
            dumperOptions.setCanonical(false);
            dumperOptions.setDefaultFlowStyle(DumperOptions$FlowStyle.BLOCK);
        }
        dumperOptions.setSplitLines(YAMLGenerator$Feature.SPLIT_LINES.enabledIn(this._formatFeatures));
        if (YAMLGenerator$Feature.INDENT_ARRAYS.enabledIn(this._formatFeatures)) {
            dumperOptions.setIndicatorIndent(1);
            dumperOptions.setIndent(2);
        }
        if (YAMLGenerator$Feature.INDENT_ARRAYS_WITH_INDICATOR.enabledIn(this._formatFeatures)) {
            dumperOptions.setIndicatorIndent(2);
            dumperOptions.setIndentWithIndicator(true);
        }
        if (YAMLGenerator$Feature.USE_PLATFORM_LINE_BREAKS.enabledIn(this._formatFeatures)) {
            dumperOptions.setLineBreak(DumperOptions$LineBreak.getPlatformLineBreak());
        }
        return dumperOptions;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public YAMLGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public YAMLGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        return this;
    }

    @Override
    public Object getOutputTarget() {
        return this._writer;
    }

    @Override
    public int getOutputBuffered() {
        return -1;
    }

    @Override
    public int getFormatFeatures() {
        return this._formatFeatures;
    }

    @Override
    public JsonGenerator overrideFormatFeatures(int n2, int n3) {
        this._formatFeatures = this._formatFeatures & ~n3 | n2 & n3;
        return this;
    }

    @Override
    public boolean canUseSchema(FormatSchema formatSchema) {
        return false;
    }

    @Override
    public boolean canWriteFormattedNumbers() {
        return true;
    }

    @Override
    public JacksonFeatureSet<StreamWriteCapability> getWriteCapabilities() {
        return DEFAULT_TEXTUAL_WRITE_CAPABILITIES;
    }

    public YAMLGenerator enable(YAMLGenerator$Feature yAMLGenerator$Feature) {
        this._formatFeatures |= yAMLGenerator$Feature.getMask();
        return this;
    }

    public YAMLGenerator disable(YAMLGenerator$Feature yAMLGenerator$Feature) {
        this._formatFeatures &= ~yAMLGenerator$Feature.getMask();
        return this;
    }

    public final boolean isEnabled(YAMLGenerator$Feature yAMLGenerator$Feature) {
        return (this._formatFeatures & yAMLGenerator$Feature.getMask()) != 0;
    }

    public YAMLGenerator configure(YAMLGenerator$Feature yAMLGenerator$Feature, boolean bl) {
        if (bl) {
            this.enable(yAMLGenerator$Feature);
        } else {
            this.disable(yAMLGenerator$Feature);
        }
        return this;
    }

    @Override
    public final void writeFieldName(String string) {
        if (this._writeContext.writeFieldName(string) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string);
    }

    @Override
    public final void writeFieldName(SerializableString serializableString) {
        if (this._writeContext.writeFieldName(serializableString.getValue()) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(serializableString.getValue());
    }

    @Override
    public void writeFieldId(long l2) {
        String string = Long.valueOf(l2).toString();
        if (this._writeContext.writeFieldName(string) == 4) {
            this._reportError("Can not write a field id, expecting a value");
        }
        this._writeScalar(string, "int", STYLE_SCALAR);
    }

    private final void _writeFieldName(String string) {
        this._writeScalar(string, "string", this._quotingChecker.needToQuoteName(string) ? STYLE_QUOTED : STYLE_UNQUOTED_NAME);
    }

    @Override
    public final void flush() {
        if (((JsonGenerator)this).isEnabled(JsonGenerator$Feature.FLUSH_PASSED_TO_STREAM)) {
            this._writer.flush();
        }
    }

    @Override
    public void close() {
        if (!((JsonGenerator)this).isClosed()) {
            this._emitEndDocument();
            this._emit(new StreamEndEvent(null, null));
            super.close();
            if (this._writer != null) {
                if (this._ioContext.isResourceManaged() || ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.AUTO_CLOSE_TARGET)) {
                    this._writer.close();
                    return;
                }
                if (((JsonGenerator)this).isEnabled(JsonGenerator$Feature.FLUSH_PASSED_TO_STREAM)) {
                    this._writer.flush();
                }
            }
        }
    }

    @Override
    public final void writeStartArray() {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        DumperOptions$FlowStyle dumperOptions$FlowStyle = this._outputOptions.getDefaultFlowStyle();
        String string = this._typeId;
        boolean bl = string == null;
        String string2 = this._objectId;
        if (string2 != null) {
            this._objectId = null;
        }
        this._emit(new SequenceStartEvent(string2, string, bl, null, null, dumperOptions$FlowStyle));
    }

    @Override
    public final void writeEndArray() {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not Array but " + this._writeContext.typeDesc());
        }
        this._typeId = null;
        this._writeContext = this._writeContext.getParent();
        this._emit(new SequenceEndEvent(null, null));
    }

    @Override
    public final void writeStartObject() {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        DumperOptions$FlowStyle dumperOptions$FlowStyle = this._outputOptions.getDefaultFlowStyle();
        String string = this._typeId;
        boolean bl = string == null;
        String string2 = this._objectId;
        if (string2 != null) {
            this._objectId = null;
        }
        this._emit(new MappingStartEvent(string2, string, bl, null, null, dumperOptions$FlowStyle));
    }

    @Override
    public final void writeEndObject() {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not Object but " + this._writeContext.typeDesc());
        }
        this._typeId = null;
        this._writeContext = this._writeContext.getParent();
        this._emit(new MappingEndEvent(null, null));
    }

    @Override
    public void writeString(String string) {
        if (string == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        if (string.isEmpty()) {
            this._writeScalar(string, "string", STYLE_QUOTED);
            return;
        }
        DumperOptions$ScalarStyle scalarStyle = YAMLGenerator$Feature.MINIMIZE_QUOTES.enabledIn(this._formatFeatures) ? (string.indexOf(10) >= 0 ? STYLE_LITERAL : (this._quotingChecker.needToQuoteValue(string) || YAMLGenerator$Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS.enabledIn(this._formatFeatures) && PLAIN_NUMBER_P.matcher(string).matches() ? STYLE_QUOTED : STYLE_PLAIN)) : (YAMLGenerator$Feature.LITERAL_BLOCK_STYLE.enabledIn(this._formatFeatures) && string.indexOf(10) >= 0 ? STYLE_LITERAL : STYLE_QUOTED);
        this._writeScalar(string, "string", scalarStyle);
    }

    @Override
    public void writeString(char[] cArray, int n2, int n3) {
        ((JsonGenerator)this).writeString(new String(cArray, n2, n3));
    }

    @Override
    public final void writeString(SerializableString serializableString) {
        ((JsonGenerator)this).writeString(serializableString.toString());
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public final void writeUTF8String(byte[] byArray, int n2, int n3) {
        ((JsonGenerator)this).writeString(new String(byArray, n2, n3, "UTF-8"));
    }

    @Override
    public void writeRaw(String string) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(String string, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char c2) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(String string) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(String string, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(char[] cArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (n2 > 0 || n2 + n3 != byArray.length) {
            int n4 = n2;
            byArray = Arrays.copyOfRange(byArray, n4, n4 + n3);
        }
        this._writeScalarBinary(base64Variant, byArray);
    }

    @Override
    public void writeBoolean(boolean bl) {
        this._verifyValueWrite("write boolean value");
        this._writeScalar(bl ? "true" : "false", "bool", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(int n2) {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(n2), "int", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(long l2) {
        if (l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE) {
            ((JsonGenerator)this).writeNumber((int)l2);
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(l2), "long", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(BigInteger bigInteger) {
        if (bigInteger == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(bigInteger.toString()), "java.math.BigInteger", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(double d2) {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(d2), "double", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(float f2) {
        this._verifyValueWrite("write number");
        this._writeScalar(String.valueOf(f2), "float", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(BigDecimal object) {
        if (object == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        object = ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.WRITE_BIGDECIMAL_AS_PLAIN) ? ((BigDecimal)object).toPlainString() : ((BigDecimal)object).toString();
        this._writeScalar((String)object, "java.math.BigDecimal", STYLE_SCALAR);
    }

    @Override
    public void writeNumber(String string) {
        if (string == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeScalar(string, "number", STYLE_SCALAR);
    }

    @Override
    public void writeNull() {
        this._verifyValueWrite("write null value");
        this._writeScalar("null", "object", STYLE_SCALAR);
    }

    @Override
    public boolean canWriteObjectId() {
        return YAMLGenerator$Feature.USE_NATIVE_OBJECT_ID.enabledIn(this._formatFeatures);
    }

    @Override
    public boolean canWriteTypeId() {
        return YAMLGenerator$Feature.USE_NATIVE_TYPE_ID.enabledIn(this._formatFeatures);
    }

    @Override
    public void writeTypeId(Object object) {
        this._typeId = String.valueOf(object);
    }

    @Override
    public void writeObjectRef(Object object) {
        this._verifyValueWrite("write Object reference");
        object = new AliasEvent(String.valueOf(object), null, null);
        this._emit((Event)object);
    }

    @Override
    public void writeObjectId(Object object) {
        this._objectId = object == null ? null : String.valueOf(object);
    }

    @Override
    public final void _verifyValueWrite(String string) {
        int n2 = this._writeContext.writeValue();
        if (n2 == 5) {
            this._reportError("Can not " + string + ", expecting field name");
        }
        if (this._writeContext.inRoot() && this._writeContext.getCurrentIndex() > 0) {
            this._emitEndDocument();
            this._emitStartDocument();
        }
    }

    @Override
    public void _releaseBuffers() {
    }

    protected void _writeScalar(String string, String string2, DumperOptions$ScalarStyle scalarStyle) {
        YAMLGenerator yAMLGenerator = this;
        yAMLGenerator._emit(yAMLGenerator._scalarEvent(string, scalarStyle));
    }

    private void _writeScalarBinary(Base64Variant object, byte[] byArray) {
        if (object == Base64Variants.getDefaultVariant()) {
            object = Base64Variants.MIME;
        }
        String string = this._lf();
        object = this._base64encode((Base64Variant)object, byArray, string);
        this._emit(new ScalarEvent(null, TAG_BINARY, EXPLICIT_TAGS, (String)object, null, null, STYLE_BASE64));
    }

    protected ScalarEvent _scalarEvent(String string, DumperOptions$ScalarStyle dumperOptions$ScalarStyle) {
        String string2;
        String string3 = this._typeId;
        if (string3 != null) {
            this._typeId = null;
        }
        if ((string2 = this._objectId) != null) {
            this._objectId = null;
        }
        return new ScalarEvent(string2, string3, NO_TAGS, string, null, null, dumperOptions$ScalarStyle);
    }

    private String _base64encode(Base64Variant base64Variant, byte[] byArray, String string) {
        int n2;
        int n3;
        int n4 = n3 = byArray.length;
        StringBuilder stringBuilder = new StringBuilder(n4 + (n4 >> 2) + (n3 >> 3));
        int n5 = base64Variant.getMaxLineLength() >> 2;
        int n6 = 0;
        int n7 = n3 - 3;
        while (n6 <= n7) {
            n2 = byArray[n6++] << 8;
            n2 |= byArray[n6++] & 0xFF;
            n2 = n2 << 8 | byArray[n6++] & 0xFF;
            base64Variant.encodeBase64Chunk(stringBuilder, n2);
            if (--n5 > 0) continue;
            stringBuilder.append(string);
            n5 = base64Variant.getMaxLineLength() >> 2;
        }
        n2 = n3 - n6;
        if (n2 > 0) {
            int n8 = byArray[n6++] << 16;
            if (n2 == 2) {
                n8 |= (byArray[n6] & 0xFF) << 8;
            }
            base64Variant.encodeBase64Partial(stringBuilder, n8, n2);
        }
        return stringBuilder.toString();
    }

    protected String _lf() {
        return this._outputOptions.getLineBreak().getString();
    }

    protected void _emitStartDocument() {
        Map<String, String> map = Collections.emptyMap();
        boolean bl = YAMLGenerator$Feature.WRITE_DOC_START_MARKER.enabledIn(this._formatFeatures);
        this._emit(new DocumentStartEvent(null, null, bl, this._docVersion, map));
    }

    protected void _emitEndDocument() {
        this._emit(new DocumentEndEvent(null, null, false));
    }

    protected final void _emit(Event event) {
        this._emitter.emit(event);
    }

    static {
        STYLE_BASE64 = STYLE_LITERAL = DumperOptions$ScalarStyle.LITERAL;
        STYLE_PLAIN = DumperOptions$ScalarStyle.PLAIN;
        NO_TAGS = new ImplicitTuple(true, true);
        EXPLICIT_TAGS = new ImplicitTuple(false, false);
    }
}

