/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.yaml;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.dataformat.yaml.JacksonYAMLParseException;
import com.fasterxml.jackson.dataformat.yaml.PackageVersion;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser$Feature;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.error.MarkedYAMLException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.CollectionStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.Event$ID;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.NodeEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.resolver.Resolver;

public class YAMLParser
extends ParserBase {
    protected ObjectCodec _objectCodec;
    protected int _formatFeatures;
    protected boolean _cfgEmptyStringsToNull;
    protected final Reader _reader;
    protected final ParserImpl _yamlParser;
    protected final Resolver _yamlResolver = new Resolver();
    protected Event _lastEvent;
    protected Event _lastTagEvent;
    protected String _textValue;
    protected String _cleanedTextValue;
    protected String _currentFieldName;
    protected boolean _currentIsAlias;
    protected String _currentAnchor;

    public YAMLParser(IOContext iOContext, BufferRecycler bufferRecycler, int n2, int n3, ObjectCodec objectCodec, Reader reader) {
        super(iOContext, n2);
        this._objectCodec = objectCodec;
        this._formatFeatures = n3;
        this._reader = reader;
        this._yamlParser = new ParserImpl(new StreamReader(reader));
        this._cfgEmptyStringsToNull = YAMLParser$Feature.EMPTY_STRING_AS_NULL.enabledIn(n3);
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    public boolean isCurrentAlias() {
        return this._currentIsAlias;
    }

    @Deprecated
    public String getCurrentAnchor() {
        return this._currentAnchor;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public boolean requiresCustomCodec() {
        return false;
    }

    @Override
    public boolean canReadObjectId() {
        return true;
    }

    @Override
    public boolean canReadTypeId() {
        return true;
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return DEFAULT_READ_CAPABILITIES;
    }

    @Override
    public void _closeInput() {
        if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser$Feature.AUTO_CLOSE_SOURCE)) {
            this._reader.close();
        }
    }

    @Override
    public int getFormatFeatures() {
        return this._formatFeatures;
    }

    @Override
    public JsonParser overrideFormatFeatures(int n2, int n3) {
        this._formatFeatures = this._formatFeatures & ~n3 | n2 & n3;
        this._cfgEmptyStringsToNull = YAMLParser$Feature.EMPTY_STRING_AS_NULL.enabledIn(this._formatFeatures);
        return this;
    }

    public JsonParser enable(YAMLParser$Feature yAMLParser$Feature) {
        this._formatFeatures |= yAMLParser$Feature.getMask();
        this._cfgEmptyStringsToNull = YAMLParser$Feature.EMPTY_STRING_AS_NULL.enabledIn(this._formatFeatures);
        return this;
    }

    public JsonParser disable(YAMLParser$Feature yAMLParser$Feature) {
        this._formatFeatures &= ~yAMLParser$Feature.getMask();
        this._cfgEmptyStringsToNull = YAMLParser$Feature.EMPTY_STRING_AS_NULL.enabledIn(this._formatFeatures);
        return this;
    }

    public JsonParser configure(YAMLParser$Feature yAMLParser$Feature, boolean bl) {
        if (bl) {
            this.enable(yAMLParser$Feature);
        } else {
            this.disable(yAMLParser$Feature);
        }
        return this;
    }

    public boolean isEnabled(YAMLParser$Feature yAMLParser$Feature) {
        return (this._formatFeatures & yAMLParser$Feature.getMask()) != 0;
    }

    @Override
    public JsonLocation getTokenLocation() {
        if (this._lastEvent == null) {
            return JsonLocation.NA;
        }
        YAMLParser yAMLParser = this;
        return yAMLParser._locationFor(yAMLParser._lastEvent.getStartMark());
    }

    @Override
    public JsonLocation getCurrentLocation() {
        if (this._lastEvent == null) {
            return JsonLocation.NA;
        }
        YAMLParser yAMLParser = this;
        return yAMLParser._locationFor(yAMLParser._lastEvent.getEndMark());
    }

    protected JsonLocation _locationFor(Mark mark) {
        if (mark == null) {
            return new JsonLocation(this._ioContext.contentReference(), -1L, -1, -1);
        }
        return new JsonLocation(this._ioContext.contentReference(), (long)mark.getIndex(), mark.getLine() + 1, mark.getColumn() + 1);
    }

    @Override
    public JsonToken nextToken() {
        this._currentIsAlias = false;
        this._binaryValue = null;
        if (this._closed) {
            return null;
        }
        while (true) {
            Object object;
            try {
                object = this._yamlParser.getEvent();
            }
            catch (YAMLException yAMLException) {
                YAMLException yAMLException2 = yAMLException;
                if (yAMLException instanceof org.yaml.snakeyaml.error.MarkedYAMLException) {
                    throw MarkedYAMLException.from((JsonParser)this, (org.yaml.snakeyaml.error.MarkedYAMLException)yAMLException2);
                }
                throw new JacksonYAMLParseException((JsonParser)this, yAMLException2.getMessage(), yAMLException2);
            }
            if (object == null) {
                this._currentAnchor = null;
                this._lastTagEvent = null;
                this._currToken = null;
                return null;
            }
            this._lastEvent = object;
            if (this._parsingContext.inObject()) {
                if (this._currToken != JsonToken.FIELD_NAME) {
                    boolean bl;
                    if (!((Event)object).is(Event$ID.Scalar)) {
                        this._currentAnchor = null;
                        this._lastTagEvent = null;
                        if (((Event)object).is(Event$ID.MappingEnd)) {
                            if (!this._parsingContext.inObject()) {
                                this._reportMismatchedEndMarker(125, ']');
                            }
                            this._parsingContext = this._parsingContext.getParent();
                            this._currToken = JsonToken.END_OBJECT;
                            return this._currToken;
                        }
                        this._reportError("Expected a field name (Scalar value in YAML), got this instead: " + object);
                    }
                    ScalarEvent scalarEvent = (ScalarEvent)object;
                    String string = scalarEvent.getAnchor();
                    boolean bl2 = bl = this._currToken == JsonToken.START_OBJECT;
                    if (string != null || !bl) {
                        this._currentAnchor = scalarEvent.getAnchor();
                    }
                    if (!bl) {
                        this._lastTagEvent = object;
                    }
                    this._currentFieldName = object = scalarEvent.getValue();
                    this._parsingContext.setCurrentName((String)object);
                    this._currToken = JsonToken.FIELD_NAME;
                    return this._currToken;
                }
            } else if (this._parsingContext.inArray()) {
                this._parsingContext.expectComma();
            }
            this._currentAnchor = null;
            this._lastTagEvent = object;
            if (((Event)object).is(Event$ID.Scalar)) {
                JsonToken jsonToken;
                this._currToken = jsonToken = this._decodeScalar((ScalarEvent)object);
                return jsonToken;
            }
            if (((Event)object).is(Event$ID.MappingStart)) {
                Mark mark = ((Event)object).getStartMark();
                MappingStartEvent mappingStartEvent = (MappingStartEvent)object;
                this._currentAnchor = mappingStartEvent.getAnchor();
                this._parsingContext = this._parsingContext.createChildObjectContext(mark.getLine(), mark.getColumn());
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            if (((Event)object).is(Event$ID.MappingEnd)) {
                this._reportError("Not expecting END_OBJECT but a value");
            }
            if (((Event)object).is(Event$ID.SequenceStart)) {
                Mark mark = ((Event)object).getStartMark();
                this._currentAnchor = ((NodeEvent)object).getAnchor();
                this._parsingContext = this._parsingContext.createChildArrayContext(mark.getLine(), mark.getColumn());
                this._currToken = JsonToken.START_ARRAY;
                return this._currToken;
            }
            if (((Event)object).is(Event$ID.SequenceEnd)) {
                if (!this._parsingContext.inArray()) {
                    this._reportMismatchedEndMarker(93, '}');
                }
                this._parsingContext = this._parsingContext.getParent();
                this._currToken = JsonToken.END_ARRAY;
                return this._currToken;
            }
            if (((Event)object).is(Event$ID.DocumentEnd) || ((Event)object).is(Event$ID.DocumentStart)) continue;
            if (((Event)object).is(Event$ID.Alias)) {
                AliasEvent aliasEvent = (AliasEvent)object;
                this._currentIsAlias = true;
                this._textValue = aliasEvent.getAnchor();
                this._cleanedTextValue = null;
                this._currToken = JsonToken.VALUE_STRING;
                return this._currToken;
            }
            if (((Event)object).is(Event$ID.StreamEnd)) {
                ((JsonParser)this).close();
                this._currToken = null;
                return null;
            }
            if (((Event)object).is(Event$ID.StreamStart)) continue;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected JsonToken _decodeScalar(ScalarEvent object) {
        String string;
        this._textValue = string = ((ScalarEvent)object).getValue();
        this._cleanedTextValue = null;
        if (!this._cfgEmptyStringsToNull && string.isEmpty()) {
            return JsonToken.VALUE_STRING;
        }
        String string2 = ((ScalarEvent)object).getTag();
        int n2 = string.length();
        if (string2 == null || string2.equals("!")) {
            if ((object = this._yamlResolver.resolve(NodeId.scalar, string, ((ScalarEvent)object).getImplicit().canOmitTagInPlainScalar())) == Tag.STR) {
                return JsonToken.VALUE_STRING;
            }
            if (object == Tag.INT) {
                return this._decodeNumberScalar(string, n2);
            }
            if (object == Tag.FLOAT) {
                this._numTypesValid = 0;
                return this._cleanYamlFloat(string);
            }
            if (object == Tag.BOOL) {
                object = this._matchYAMLBoolean(string, n2);
                if (object == null) return JsonToken.VALUE_STRING;
                if (!((Boolean)object).booleanValue()) return JsonToken.VALUE_FALSE;
                return JsonToken.VALUE_TRUE;
            }
            if (object != Tag.NULL) return JsonToken.VALUE_STRING;
            return JsonToken.VALUE_NULL;
        }
        if (string2.startsWith("tag:yaml.org,2002:") && (string2 = string2.substring(18)).contains(",")) {
            string2 = string2.split(",")[0];
        }
        if ("binary".equals(string2)) {
            string = string.trim();
            try {
                this._binaryValue = Base64Variants.MIME.decode(string);
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._reportError(illegalArgumentException.getMessage());
            }
            return JsonToken.VALUE_EMBEDDED_OBJECT;
        }
        if ("bool".equals(string2)) {
            object = this._matchYAMLBoolean(string, n2);
            if (object == null) return JsonToken.VALUE_STRING;
            if (!((Boolean)object).booleanValue()) return JsonToken.VALUE_FALSE;
            return JsonToken.VALUE_TRUE;
        }
        if ("int".equals(string2)) {
            return this._decodeNumberScalar(string, n2);
        }
        if ("float".equals(string2)) {
            this._numTypesValid = 0;
            return this._cleanYamlFloat(string);
        }
        if (!"null".equals(string2)) return JsonToken.VALUE_STRING;
        return JsonToken.VALUE_NULL;
    }

    protected Boolean _matchYAMLBoolean(String string, int n2) {
        switch (n2) {
            case 1: {
                switch (string.charAt(0)) {
                    case 'Y': 
                    case 'y': {
                        return Boolean.TRUE;
                    }
                    case 'N': 
                    case 'n': {
                        return Boolean.FALSE;
                    }
                }
                break;
            }
            case 2: {
                if ("no".equalsIgnoreCase(string)) {
                    return Boolean.FALSE;
                }
                if (!"on".equalsIgnoreCase(string)) break;
                return Boolean.TRUE;
            }
            case 3: {
                if ("yes".equalsIgnoreCase(string)) {
                    return Boolean.TRUE;
                }
                if (!"off".equalsIgnoreCase(string)) break;
                return Boolean.FALSE;
            }
            case 4: {
                if (!"true".equalsIgnoreCase(string)) break;
                return Boolean.TRUE;
            }
            case 5: {
                if (!"false".equalsIgnoreCase(string)) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected JsonToken _decodeNumberScalar(String string, int n2) {
        block15: {
            int n3;
            char c2 = string.charAt(0);
            if (c2 == '-') {
                this._numberNegative = true;
                n3 = 1;
            } else if (c2 == '+') {
                this._numberNegative = false;
                if (n2 == 1) {
                    return null;
                }
                n3 = 1;
            } else {
                this._numberNegative = false;
                n3 = 0;
            }
            if (n2 == n3) {
                return null;
            }
            if (string.charAt(n3) == '0') {
                if (++n3 == n2) {
                    this._numberInt = 0;
                    this._numTypesValid = 1;
                    return JsonToken.VALUE_NUMBER_INT;
                }
                c2 = string.charAt(n3);
                switch (c2) {
                    case 'B': 
                    case 'b': {
                        return this._decodeNumberIntBinary(string, n3 + 1, n2, this._numberNegative);
                    }
                    case 'X': 
                    case 'x': {
                        return this._decodeNumberIntHex(string, n3 + 1, n2, this._numberNegative);
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case '_': {
                        return this._decodeNumberIntOctal(string, n3, n2, this._numberNegative);
                    }
                }
                return JsonToken.VALUE_STRING;
            }
            c2 = '\u0000';
            do {
                char c3;
                if ((c3 = string.charAt(n3)) <= '9' && c3 >= '0') continue;
                if (c3 != '_') break block15;
                c2 = '\u0001';
            } while (++n3 != n2);
            this._numTypesValid = 0;
            if (c2 != '\u0000') {
                return this._cleanYamlInt(string);
            }
            this._cleanedTextValue = this._textValue;
            return JsonToken.VALUE_NUMBER_INT;
        }
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _decodeNumberIntBinary(String string, int n2, int n3, boolean bl) {
        if ((n2 = (string = this._cleanUnderscores(string, n2, n3)).length()) <= 31) {
            int n4 = Integer.parseInt(string, 2);
            if (bl) {
                n4 = -n4;
            }
            this._numberInt = n4;
            this._numTypesValid = 1;
            return JsonToken.VALUE_NUMBER_INT;
        }
        if (n2 <= 63) {
            return this._decodeFromLong(Long.parseLong(string, 2), bl, n2 == 32);
        }
        return this._decodeFromBigInteger(new BigInteger(string, 2), bl);
    }

    protected JsonToken _decodeNumberIntOctal(String string, int n2, int n3, boolean bl) {
        if ((n2 = (string = this._cleanUnderscores(string, n2, n3)).length()) <= 10) {
            int n4 = Integer.parseInt(string, 8);
            if (bl) {
                n4 = -n4;
            }
            this._numberInt = n4;
            this._numTypesValid = 1;
            return JsonToken.VALUE_NUMBER_INT;
        }
        if (n2 <= 21) {
            return this._decodeFromLong(Long.parseLong(string, 8), bl, false);
        }
        return this._decodeFromBigInteger(new BigInteger(string, 8), bl);
    }

    protected JsonToken _decodeNumberIntHex(String string, int n2, int n3, boolean bl) {
        if ((n2 = (string = this._cleanUnderscores(string, n2, n3)).length()) <= 7) {
            int n4 = Integer.parseInt(string, 16);
            if (bl) {
                n4 = -n4;
            }
            this._numberInt = n4;
            this._numTypesValid = 1;
            return JsonToken.VALUE_NUMBER_INT;
        }
        if (n2 <= 15) {
            return this._decodeFromLong(Long.parseLong(string, 16), bl, n2 == 8);
        }
        return this._decodeFromBigInteger(new BigInteger(string, 16), bl);
    }

    private JsonToken _decodeFromLong(long l2, boolean bl, boolean bl2) {
        long l3;
        if (bl) {
            l3 = -l2;
            if (bl2 && l3 >= Integer.MIN_VALUE) {
                this._numberInt = (int)l3;
                this._numTypesValid = 1;
                return JsonToken.VALUE_NUMBER_INT;
            }
        } else {
            if (bl2 && l2 < Integer.MAX_VALUE) {
                this._numberInt = (int)l2;
                this._numTypesValid = 1;
                return JsonToken.VALUE_NUMBER_INT;
            }
            l3 = l2;
        }
        this._numberLong = l3;
        this._numTypesValid = 2;
        return JsonToken.VALUE_NUMBER_INT;
    }

    private JsonToken _decodeFromBigInteger(BigInteger bigInteger, boolean bl) {
        this._numberBigInt = bl ? bigInteger.negate() : bigInteger;
        this._numTypesValid = 4;
        return JsonToken.VALUE_NUMBER_INT;
    }

    @Override
    public boolean hasTextCharacters() {
        return false;
    }

    @Override
    public String getText() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textValue;
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._currentFieldName;
        }
        if (this._currToken != null) {
            if (this._currToken.isScalarValue()) {
                return this._textValue;
            }
            return this._currToken.asString();
        }
        return null;
    }

    @Override
    public String getCurrentName() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._currentFieldName;
        }
        return super.getCurrentName();
    }

    @Override
    public char[] getTextCharacters() {
        String string = ((JsonParser)this).getText();
        if (string == null) {
            return null;
        }
        return string.toCharArray();
    }

    @Override
    public int getTextLength() {
        String string = ((JsonParser)this).getText();
        if (string == null) {
            return 0;
        }
        return string.length();
    }

    @Override
    public int getTextOffset() {
        return 0;
    }

    @Override
    public int getText(Writer writer) {
        String string = ((JsonParser)this).getText();
        if (string == null) {
            return 0;
        }
        writer.write(string);
        return string.length();
    }

    @Override
    public Object getEmbeddedObject() {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return this._binaryValue;
        }
        return null;
    }

    @Override
    public int readBinaryValue(Base64Variant object, OutputStream outputStream) {
        object = ((JsonParser)this).getBinaryValue((Base64Variant)object);
        outputStream.write((byte[])object);
        return ((Object)object).length;
    }

    @Override
    public void _parseNumericValue(int n2) {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            int n3 = this._cleanedTextValue.length();
            if (this._numberNegative) {
                --n3;
            }
            if (n3 <= 9) {
                this._numberInt = Integer.parseInt(this._cleanedTextValue);
                this._numTypesValid = 1;
                return;
            }
            if (n3 <= 18) {
                long l2 = Long.parseLong(this._cleanedTextValue);
                if (n3 == 10) {
                    if (this._numberNegative) {
                        if (l2 >= Integer.MIN_VALUE) {
                            this._numberInt = (int)l2;
                            this._numTypesValid = 1;
                            return;
                        }
                    } else if (l2 <= Integer.MAX_VALUE) {
                        this._numberInt = (int)l2;
                        this._numTypesValid = 1;
                        return;
                    }
                }
                this._numberLong = l2;
                this._numTypesValid = 2;
                return;
            }
            try {
                BigInteger bigInteger = new BigInteger(this._cleanedTextValue);
                if (n3 == 19 && bigInteger.bitLength() <= 63) {
                    this._numberLong = bigInteger.longValue();
                    this._numTypesValid = 2;
                    return;
                }
                this._numberBigInt = bigInteger;
                this._numTypesValid = 4;
                return;
            }
            catch (NumberFormatException numberFormatException) {
                this._wrapError("Malformed numeric value '" + this._textValue + "'", numberFormatException);
            }
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            String string = this._cleanedTextValue;
            try {
                if (n2 != 16) {
                    this._numberDouble = Double.parseDouble(string);
                    this._numTypesValid = 8;
                    return;
                }
                this._numberBigDecimal = new BigDecimal(string);
                this._numTypesValid = 16;
            }
            catch (NumberFormatException numberFormatException) {
                this._wrapError("Malformed numeric value '" + this._textValue + "'", numberFormatException);
            }
            return;
        }
        this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not numeric, can not use numeric value accessors");
    }

    @Override
    public int _parseIntValue() {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            int n2 = this._cleanedTextValue.length();
            if (this._numberNegative) {
                --n2;
            }
            if (n2 <= 9) {
                this._numTypesValid = 1;
                this._numberInt = Integer.parseInt(this._cleanedTextValue);
                return this._numberInt;
            }
        }
        this._parseNumericValue(1);
        if ((this._numTypesValid & 1) == 0) {
            this.convertNumberToInt();
        }
        return this._numberInt;
    }

    @Override
    public String getObjectId() {
        return this._currentAnchor;
    }

    @Override
    public String getTypeId() {
        String string;
        if (this._lastTagEvent instanceof CollectionStartEvent) {
            string = ((CollectionStartEvent)this._lastTagEvent).getTag();
        } else if (this._lastTagEvent instanceof ScalarEvent) {
            string = ((ScalarEvent)this._lastTagEvent).getTag();
        } else {
            return null;
        }
        if (string != null) {
            while (string.startsWith("!")) {
                string = string.substring(1);
            }
            return string;
        }
        return null;
    }

    private JsonToken _cleanYamlInt(String string) {
        int n2;
        int n3 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n3);
        int n4 = n2 = string.charAt(0) == '+' ? 1 : 0;
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            if (c2 != '_') {
                stringBuilder.append(c2);
            }
            ++n2;
        }
        this._cleanedTextValue = stringBuilder.toString();
        return JsonToken.VALUE_NUMBER_INT;
    }

    private String _cleanUnderscores(String string, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder(n3);
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            if (c2 != '_') {
                stringBuilder.append(c2);
            }
            ++n2;
        }
        if (stringBuilder.length() == n3) {
            return string;
        }
        return stringBuilder.toString();
    }

    private JsonToken _cleanYamlFloat(String string) {
        int n2;
        int n3 = string.length();
        int n4 = string.indexOf(95);
        if (n4 < 0 || n3 == 0) {
            this._cleanedTextValue = string;
            return JsonToken.VALUE_NUMBER_FLOAT;
        }
        StringBuilder stringBuilder = new StringBuilder(n3);
        int n5 = n2 = string.charAt(0) == '+' ? 1 : 0;
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            if (c2 != '_') {
                stringBuilder.append(c2);
            }
            ++n2;
        }
        this._cleanedTextValue = stringBuilder.toString();
        return JsonToken.VALUE_NUMBER_FLOAT;
    }
}

