/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.yaml.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class StringQuotingChecker
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Set<String> RESERVED_KEYWORDS = new HashSet<String>(Arrays.asList("false", "False", "FALSE", "n", "N", "no", "No", "NO", "null", "Null", "NULL", "on", "On", "ON", "off", "Off", "OFF", "true", "True", "TRUE", "y", "Y", "yes", "Yes", "YES"));

    public abstract boolean needToQuoteName(String var1);

    public abstract boolean needToQuoteValue(String var1);

    protected boolean isReservedKeyword(String string) {
        if (string.length() == 0) {
            return true;
        }
        return this._isReservedKeyword(string.charAt(0), string);
    }

    protected boolean _isReservedKeyword(int n2, String string) {
        switch (n2) {
            case 70: 
            case 78: 
            case 79: 
            case 84: 
            case 89: 
            case 102: 
            case 110: 
            case 111: 
            case 116: 
            case 121: {
                return RESERVED_KEYWORDS.contains(string);
            }
            case 126: {
                return true;
            }
        }
        return false;
    }

    protected boolean looksLikeYAMLNumber(String string) {
        if (string.length() > 0) {
            return this._looksLikeYAMLNumber(string.charAt(0), string);
        }
        return false;
    }

    protected boolean _looksLikeYAMLNumber(int n2, String string) {
        switch (n2) {
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return true;
            }
        }
        return false;
    }

    protected boolean valueHasQuotableChar(String string) {
        int n2 = string.length();
        block5: for (int i2 = 0; i2 < n2; ++i2) {
            switch (string.charAt(i2)) {
                case ',': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    return true;
                }
                case '#': {
                    char c2;
                    if (i2 <= 0 || ' ' != (c2 = string.charAt(i2 - 1)) && '\t' != c2) continue block5;
                    return true;
                }
                case ':': {
                    char c2;
                    if (i2 >= n2 - 1 || ' ' != (c2 = string.charAt(i2 + 1)) && '\t' != c2) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean nameHasQuotableChar(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= ' ') continue;
            return true;
        }
        return false;
    }
}

