/*
 * Decompiled with CFR 0.152.
 */
package com.studiohartman.jamepad;

import com.studiohartman.jamepad.ControllerAxis;
import com.studiohartman.jamepad.ControllerButton;
import com.studiohartman.jamepad.ControllerPowerLevel;
import com.studiohartman.jamepad.ControllerUnpluggedException;

public final class ControllerIndex {
    private static final float AXIS_MAX_VAL = 32767.0f;
    private int index;
    private long controllerPtr;
    private boolean[] heldDownButtons;
    private boolean[] justPressedButtons;

    ControllerIndex(int n2) {
        this.index = n2;
        this.heldDownButtons = new boolean[ControllerButton.values().length];
        this.justPressedButtons = new boolean[ControllerButton.values().length];
        for (n2 = 0; n2 < this.heldDownButtons.length; ++n2) {
            this.heldDownButtons[n2] = false;
            this.justPressedButtons[n2] = false;
        }
        this.connectController();
    }

    private void connectController() {
        this.controllerPtr = this.nativeConnectController(this.index);
    }

    private native long nativeConnectController(int var1);

    public final void close() {
        if (this.controllerPtr != 0L) {
            ControllerIndex controllerIndex = this;
            controllerIndex.nativeClose(controllerIndex.controllerPtr);
            this.controllerPtr = 0L;
        }
    }

    private native void nativeClose(long var1);

    public final boolean reconnectController() {
        this.close();
        this.connectController();
        return this.isConnected();
    }

    public final boolean isConnected() {
        if (this.controllerPtr != 0L) {
            ControllerIndex controllerIndex = this;
            if (controllerIndex.nativeIsConnected(controllerIndex.controllerPtr)) {
                return true;
            }
        }
        return false;
    }

    private native boolean nativeIsConnected(long var1);

    public final int getIndex() {
        return this.index;
    }

    public final boolean canVibrate() {
        this.ensureConnected();
        ControllerIndex controllerIndex = this;
        return controllerIndex.nativeCanVibrate(controllerIndex.controllerPtr);
    }

    private native boolean nativeCanVibrate(long var1);

    private native boolean nativeDoVibration(long var1, int var3, int var4, int var5);

    public final boolean doVibration(float f2, float f3, int n2) {
        boolean bl;
        this.ensureConnected();
        boolean bl2 = f2 >= 0.0f && f2 <= 1.0f;
        boolean bl3 = bl = f3 >= 0.0f && f3 <= 1.0f;
        if (!bl2 || !bl) {
            throw new IllegalArgumentException("The passed values are not in the range 0 to 1!");
        }
        ControllerIndex controllerIndex = this;
        return controllerIndex.nativeDoVibration(controllerIndex.controllerPtr, (int)(65535.0f * f2), (int)(65535.0f * f3), n2);
    }

    public final boolean isButtonPressed(ControllerButton controllerButton) {
        this.updateButton(controllerButton.ordinal());
        return this.heldDownButtons[controllerButton.ordinal()];
    }

    public final boolean isButtonJustPressed(ControllerButton controllerButton) {
        this.updateButton(controllerButton.ordinal());
        return this.justPressedButtons[controllerButton.ordinal()];
    }

    private void updateButton(int n2) {
        this.ensureConnected();
        ControllerIndex controllerIndex = this;
        boolean bl = controllerIndex.nativeCheckButton(controllerIndex.controllerPtr, n2);
        this.justPressedButtons[n2] = bl && !this.heldDownButtons[n2];
        this.heldDownButtons[n2] = bl;
    }

    private native boolean nativeCheckButton(long var1, int var3);

    public final boolean isButtonAvailable(ControllerButton controllerButton) {
        this.ensureConnected();
        ControllerIndex controllerIndex = this;
        return controllerIndex.nativeButtonAvailable(controllerIndex.controllerPtr, controllerButton.ordinal());
    }

    private native boolean nativeButtonAvailable(long var1, int var3);

    public final float getAxisState(ControllerAxis controllerAxis) {
        this.ensureConnected();
        ControllerIndex controllerIndex = this;
        return (float)controllerIndex.nativeCheckAxis(controllerIndex.controllerPtr, controllerAxis.ordinal()) / 32767.0f;
    }

    private native int nativeCheckAxis(long var1, int var3);

    public final boolean isAxisAvailable(ControllerAxis controllerAxis) {
        this.ensureConnected();
        ControllerIndex controllerIndex = this;
        return controllerIndex.nativeAxisAvailable(controllerIndex.controllerPtr, controllerAxis.ordinal());
    }

    private native boolean nativeAxisAvailable(long var1, int var3);

    public final String getName() {
        this.ensureConnected();
        ControllerIndex controllerIndex = this;
        String string = controllerIndex.nativeGetName(controllerIndex.controllerPtr);
        if (string == null) {
            return "Unnamed Controller";
        }
        return string;
    }

    private native String nativeGetName(long var1);

    public final int getPlayerIndex() {
        this.ensureConnected();
        ControllerIndex controllerIndex = this;
        return controllerIndex.nativeGetPlayerIndex(controllerIndex.controllerPtr);
    }

    private native int nativeGetPlayerIndex(long var1);

    public final void setPlayerIndex(int n2) {
        this.ensureConnected();
        ControllerIndex controllerIndex = this;
        controllerIndex.nativeSetPlayerIndex(controllerIndex.controllerPtr, n2);
    }

    private native void nativeSetPlayerIndex(long var1, int var3);

    public final ControllerPowerLevel getPowerLevel() {
        this.ensureConnected();
        ControllerIndex controllerIndex = this;
        return ControllerPowerLevel.valueOf(controllerIndex.nativeGetPowerLevel(controllerIndex.controllerPtr));
    }

    private native int nativeGetPowerLevel(long var1);

    private void ensureConnected() {
        if (!this.isConnected()) {
            throw new ControllerUnpluggedException("Controller at index " + this.index + " is not connected!");
        }
    }
}

