/*
 * Decompiled with CFR 0.152.
 */
package com.studiohartman.jamepad;

import com.badlogic.gdx.utils.SharedLibraryLoader;
import com.studiohartman.jamepad.Configuration;
import com.studiohartman.jamepad.ControllerIndex;
import com.studiohartman.jamepad.ControllerState;
import com.studiohartman.jamepad.ControllerUnpluggedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class ControllerManager {
    private final Configuration configuration;
    private String mappingsPath;
    private boolean isInitialized;
    private ControllerIndex[] controllers;

    public ControllerManager() {
        this(new Configuration(), "/gamecontrollerdb.txt");
    }

    public ControllerManager(Configuration configuration) {
        this(configuration, "/gamecontrollerdb.txt");
    }

    public ControllerManager(Configuration configuration, String string) {
        this.configuration = configuration;
        this.mappingsPath = string;
        this.isInitialized = false;
        this.controllers = new ControllerIndex[configuration.maxNumControllers];
        if (configuration.loadNativeLibrary) {
            new SharedLibraryLoader().load("jamepad");
        }
    }

    public void initSDLGamepad() {
        if (this.isInitialized) {
            throw new IllegalStateException("SDL is already initialized!");
        }
        ControllerManager controllerManager = this;
        if (!controllerManager.nativeInitSDLGamepad(!controllerManager.configuration.useRawInput)) {
            throw new IllegalStateException("Failed to initialize SDL in native method!");
        }
        this.isInitialized = true;
        try {
            ControllerManager controllerManager2 = this;
            controllerManager2.addMappingsFromFile(controllerManager2.mappingsPath);
        }
        catch (IOException | IllegalStateException exception) {
            System.err.println("Failed to load mapping with original location \"" + this.mappingsPath + "\", Falling back of SDL's built in mappings");
            exception.printStackTrace();
        }
        for (int i2 = 0; i2 < this.controllers.length; ++i2) {
            this.controllers[i2] = new ControllerIndex(i2);
        }
    }

    private native boolean nativeInitSDLGamepad(boolean var1);

    public void quitSDLGamepad() {
        ControllerIndex[] controllerIndexArray = this.controllers;
        int n2 = this.controllers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ControllerIndex controllerIndex = controllerIndexArray[i2];
            controllerIndex.close();
        }
        this.nativeCloseSDLGamepad();
        this.controllers = new ControllerIndex[0];
        this.isInitialized = false;
    }

    private native void nativeCloseSDLGamepad();

    public ControllerState getState(int n2) {
        this.verifyInitialized();
        if (n2 < this.controllers.length && n2 >= 0) {
            this.update();
            return ControllerState.getInstanceFromController(this.controllers[n2]);
        }
        return ControllerState.getDisconnectedControllerInstance();
    }

    public boolean doVibration(int n2, float f2, float f3, int n3) {
        this.verifyInitialized();
        if (n2 < this.controllers.length && n2 >= 0) {
            try {
                return this.controllers[n2].doVibration(f2, f3, n3);
            }
            catch (ControllerUnpluggedException controllerUnpluggedException) {
                return false;
            }
        }
        return false;
    }

    public ControllerIndex getControllerIndex(int n2) {
        this.verifyInitialized();
        return this.controllers[n2];
    }

    public int getNumControllers() {
        this.verifyInitialized();
        return this.nativeGetNumRollers();
    }

    private native int nativeGetNumRollers();

    public void update() {
        this.verifyInitialized();
        if (this.nativeControllerConnectedOrDisconnected()) {
            for (int i2 = 0; i2 < this.controllers.length; ++i2) {
                this.controllers[i2].reconnectController();
            }
        }
    }

    private native boolean nativeControllerConnectedOrDisconnected();

    public void addMappingsFromFile(String object) {
        InputStream inputStream = this.getClass().getResourceAsStream((String)object);
        if (inputStream == null) {
            inputStream = ClassLoader.getSystemResourceAsStream((String)object);
        }
        if (inputStream == null) {
            throw new IOException("Cannot open resource from classpath " + (String)object);
        }
        if (this.configuration.loadDatabaseInMemory) {
            int n2;
            object = new ByteArrayOutputStream();
            byte[] byArray = new byte[4096];
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                ((ByteArrayOutputStream)object).write(byArray, 0, n2);
            }
            Object object2 = object = (Object)((ByteArrayOutputStream)object).toByteArray();
            if (!this.nativeAddMappingsFromBuffer((byte[])object2, ((Object)object2).length)) {
                throw new IllegalStateException("Failed to set SDL controller mappings! Falling back to build in SDL mappings.");
            }
            return;
        }
        object = Files.createTempFile(null, null, new FileAttribute[0]).toAbsolutePath();
        Files.copy(inputStream, (Path)object, StandardCopyOption.REPLACE_EXISTING);
        if (!this.nativeAddMappingsFromFile(object.toString())) {
            throw new IllegalStateException("Failed to set SDL controller mappings! Falling back to build in SDL mappings.");
        }
        Files.delete((Path)object);
    }

    private native boolean nativeAddMappingsFromFile(String var1);

    private native boolean nativeAddMappingsFromBuffer(byte[] var1, int var2);

    public native String getLastNativeError();

    private boolean verifyInitialized() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SDL_GameController is not initialized!");
        }
        return true;
    }
}

