/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.regexp;

import com.sun.msv.datatype.regexp.REUtil;
import java.text.CharacterIterator;

final class Match
implements Cloneable {
    int[] beginpos = null;
    int[] endpos = null;
    int nofgroups = 0;
    CharacterIterator ciSource = null;
    String strSource = null;
    char[] charSource = null;

    public final synchronized Object clone() {
        Match match = new Match();
        if (this.nofgroups > 0) {
            match.setNumberOfGroups(this.nofgroups);
            if (this.ciSource != null) {
                match.setSource(this.ciSource);
            }
            if (this.strSource != null) {
                match.setSource(this.strSource);
            }
            for (int i2 = 0; i2 < this.nofgroups; ++i2) {
                match.setBeginning(i2, this.getBeginning(i2));
                match.setEnd(i2, this.getEnd(i2));
            }
        }
        return match;
    }

    protected final void setNumberOfGroups(int n2) {
        int n3 = this.nofgroups;
        this.nofgroups = n2;
        if (n3 <= 0 || n3 < n2 || n2 << 1 < n3) {
            this.beginpos = new int[n2];
            this.endpos = new int[n2];
        }
        for (n3 = 0; n3 < n2; ++n3) {
            this.beginpos[n3] = -1;
            this.endpos[n3] = -1;
        }
    }

    protected final void setSource(CharacterIterator characterIterator) {
        this.ciSource = characterIterator;
        this.strSource = null;
        this.charSource = null;
    }

    protected final void setSource(String string) {
        this.ciSource = null;
        this.strSource = string;
        this.charSource = null;
    }

    protected final void setSource(char[] cArray) {
        this.ciSource = null;
        this.strSource = null;
        this.charSource = cArray;
    }

    protected final void setBeginning(int n2, int n3) {
        this.beginpos[n2] = n3;
    }

    protected final void setEnd(int n2, int n3) {
        this.endpos[n2] = n3;
    }

    public final int getNumberOfGroups() {
        if (this.nofgroups <= 0) {
            throw new IllegalStateException("A result is not set.");
        }
        return this.nofgroups;
    }

    public final int getBeginning(int n2) {
        if (this.beginpos == null) {
            throw new IllegalStateException("A result is not set.");
        }
        if (n2 < 0 || this.nofgroups <= n2) {
            throw new IllegalArgumentException("The parameter must be less than " + this.nofgroups + ": " + n2);
        }
        return this.beginpos[n2];
    }

    public final int getEnd(int n2) {
        if (this.endpos == null) {
            throw new IllegalStateException("A result is not set.");
        }
        if (n2 < 0 || this.nofgroups <= n2) {
            throw new IllegalArgumentException("The parameter must be less than " + this.nofgroups + ": " + n2);
        }
        return this.endpos[n2];
    }

    public final String getCapturedText(int n2) {
        if (this.beginpos == null) {
            throw new IllegalStateException("match() has never been called.");
        }
        if (n2 < 0 || this.nofgroups <= n2) {
            throw new IllegalArgumentException("The parameter must be less than " + this.nofgroups + ": " + n2);
        }
        int n3 = this.beginpos[n2];
        n2 = this.endpos[n2];
        if (n3 < 0 || n2 < 0) {
            return null;
        }
        String string = this.ciSource != null ? REUtil.substring(this.ciSource, n3, n2) : (this.strSource != null ? this.strSource.substring(n3, n2) : new String(this.charSource, n3, n2 - n3));
        return string;
    }
}

