/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.regexp;

import com.sun.msv.datatype.regexp.Token;
import java.io.Serializable;

final class RangeToken
extends Token
implements Serializable {
    int[] ranges;
    boolean sorted;
    boolean compacted;
    RangeToken icaseCache = null;
    int[] map = null;
    int nonMapIndex;
    private static final int MAPSIZE = 256;

    RangeToken(int n2) {
        super(n2);
        this.setSorted(false);
    }

    protected final void addRange(int n2, int n3) {
        int n4;
        this.icaseCache = null;
        if (n2 <= n3) {
            n4 = n2;
            n2 = n3;
        } else {
            n4 = n3;
        }
        if (this.ranges == null) {
            this.ranges = new int[2];
            this.ranges[0] = n4;
            this.ranges[1] = n2;
            this.setSorted(true);
            return;
        }
        n3 = this.ranges.length;
        if (this.ranges[n3 - 1] + 1 == n4) {
            this.ranges[n3 - 1] = n2;
            return;
        }
        int[] nArray = new int[n3 + 2];
        System.arraycopy(this.ranges, 0, nArray, 0, n3);
        this.ranges = nArray;
        if (this.ranges[n3 - 1] >= n4) {
            this.setSorted(false);
        }
        this.ranges[n3++] = n4;
        this.ranges[n3] = n2;
        if (!this.sorted) {
            this.sortRanges();
        }
    }

    private final boolean isSorted() {
        return this.sorted;
    }

    private final void setSorted(boolean bl) {
        this.sorted = bl;
        if (!bl) {
            this.compacted = false;
        }
    }

    private final boolean isCompacted() {
        return this.compacted;
    }

    private final void setCompacted() {
        this.compacted = true;
    }

    protected final void sortRanges() {
        if (this.isSorted()) {
            return;
        }
        if (this.ranges == null) {
            return;
        }
        for (int i2 = this.ranges.length - 4; i2 >= 0; i2 -= 2) {
            for (int i3 = 0; i3 <= i2; i3 += 2) {
                if (this.ranges[i3] <= this.ranges[i3 + 2] && (this.ranges[i3] != this.ranges[i3 + 2] || this.ranges[i3 + 1] <= this.ranges[i3 + 3])) continue;
                int n2 = this.ranges[i3 + 2];
                this.ranges[i3 + 2] = this.ranges[i3];
                this.ranges[i3] = n2;
                n2 = this.ranges[i3 + 3];
                this.ranges[i3 + 3] = this.ranges[i3 + 1];
                this.ranges[i3 + 1] = n2;
            }
        }
        this.setSorted(true);
    }

    protected final void compactRanges() {
        if (this.ranges == null || this.ranges.length <= 2) {
            return;
        }
        if (this.isCompacted()) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.ranges.length) {
            if (n2 != n3) {
                this.ranges[n2] = this.ranges[n3++];
                this.ranges[n2 + 1] = this.ranges[n3++];
            } else {
                n3 += 2;
            }
            int n4 = this.ranges[n2 + 1];
            while (n3 < this.ranges.length && n4 + 1 >= this.ranges[n3]) {
                if (n4 + 1 == this.ranges[n3]) {
                    this.ranges[n2 + 1] = this.ranges[n3 + 1];
                    n4 = this.ranges[n2 + 1];
                    n3 += 2;
                    continue;
                }
                if (n4 >= this.ranges[n3 + 1]) {
                    n3 += 2;
                    continue;
                }
                if (n4 < this.ranges[n3 + 1]) {
                    this.ranges[n2 + 1] = this.ranges[n3 + 1];
                    n4 = this.ranges[n2 + 1];
                    n3 += 2;
                    continue;
                }
                throw new RuntimeException("Token#compactRanges(): Internel Error: [" + this.ranges[n2] + "," + this.ranges[n2 + 1] + "] [" + this.ranges[n3] + "," + this.ranges[n3 + 1] + "]");
            }
            n2 += 2;
        }
        if (n2 != this.ranges.length) {
            int[] nArray = new int[n2];
            System.arraycopy(this.ranges, 0, nArray, 0, n2);
            this.ranges = nArray;
        }
        this.setCompacted();
    }

    protected final void mergeRanges(Token token) {
        token = (RangeToken)token;
        this.sortRanges();
        ((RangeToken)token).sortRanges();
        if (((RangeToken)token).ranges == null) {
            return;
        }
        this.icaseCache = null;
        this.setSorted(true);
        if (this.ranges == null) {
            this.ranges = new int[((RangeToken)token).ranges.length];
            System.arraycopy(((RangeToken)token).ranges, 0, this.ranges, 0, ((RangeToken)token).ranges.length);
            return;
        }
        int[] nArray = new int[this.ranges.length + ((RangeToken)token).ranges.length];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < this.ranges.length || n3 < ((RangeToken)token).ranges.length) {
            if (n2 >= this.ranges.length) {
                nArray[n4++] = ((RangeToken)token).ranges[n3++];
                nArray[n4++] = ((RangeToken)token).ranges[n3++];
                continue;
            }
            if (n3 >= ((RangeToken)token).ranges.length) {
                nArray[n4++] = this.ranges[n2++];
                nArray[n4++] = this.ranges[n2++];
                continue;
            }
            if (((RangeToken)token).ranges[n3] < this.ranges[n2] || ((RangeToken)token).ranges[n3] == this.ranges[n2] && ((RangeToken)token).ranges[n3 + 1] < this.ranges[n2 + 1]) {
                nArray[n4++] = ((RangeToken)token).ranges[n3++];
                nArray[n4++] = ((RangeToken)token).ranges[n3++];
                continue;
            }
            nArray[n4++] = this.ranges[n2++];
            nArray[n4++] = this.ranges[n2++];
        }
        this.ranges = nArray;
    }

    protected final void subtractRanges(Token token) {
        if (token.type == 5) {
            this.intersectRanges(token);
            return;
        }
        token = (RangeToken)token;
        if (((RangeToken)token).ranges == null || this.ranges == null) {
            return;
        }
        this.icaseCache = null;
        this.sortRanges();
        this.compactRanges();
        ((RangeToken)token).sortRanges();
        ((RangeToken)token).compactRanges();
        int[] nArray = new int[this.ranges.length + ((RangeToken)token).ranges.length];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.ranges.length && n4 < ((RangeToken)token).ranges.length) {
            int n5 = this.ranges[n3];
            int n6 = this.ranges[n3 + 1];
            int n7 = ((RangeToken)token).ranges[n4];
            int n8 = ((RangeToken)token).ranges[n4 + 1];
            if (n6 < n7) {
                nArray[n2++] = this.ranges[n3++];
                nArray[n2++] = this.ranges[n3++];
                continue;
            }
            if (n6 >= n7 && n5 <= n8) {
                if (n7 <= n5 && n6 <= n8) {
                    n3 += 2;
                    continue;
                }
                if (n7 <= n5) {
                    this.ranges[n3] = n8 + 1;
                    n4 += 2;
                    continue;
                }
                if (n6 <= n8) {
                    nArray[n2++] = n5;
                    nArray[n2++] = n7 - 1;
                    n3 += 2;
                    continue;
                }
                nArray[n2++] = n5;
                nArray[n2++] = n7 - 1;
                this.ranges[n3] = n8 + 1;
                n4 += 2;
                continue;
            }
            if (n8 < n5) {
                n4 += 2;
                continue;
            }
            throw new RuntimeException("Token#subtractRanges(): Internal Error: [" + this.ranges[n3] + "," + this.ranges[n3 + 1] + "] - [" + ((RangeToken)token).ranges[n4] + "," + ((RangeToken)token).ranges[n4 + 1] + "]");
        }
        while (n3 < this.ranges.length) {
            nArray[n2++] = this.ranges[n3++];
            nArray[n2++] = this.ranges[n3++];
        }
        this.ranges = new int[n2];
        System.arraycopy(nArray, 0, this.ranges, 0, n2);
    }

    protected final void intersectRanges(Token token) {
        token = (RangeToken)token;
        if (((RangeToken)token).ranges == null || this.ranges == null) {
            return;
        }
        this.icaseCache = null;
        this.sortRanges();
        this.compactRanges();
        ((RangeToken)token).sortRanges();
        ((RangeToken)token).compactRanges();
        int[] nArray = new int[this.ranges.length + ((RangeToken)token).ranges.length];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.ranges.length && n4 < ((RangeToken)token).ranges.length) {
            int n5 = this.ranges[n3];
            int n6 = this.ranges[n3 + 1];
            int n7 = ((RangeToken)token).ranges[n4];
            int n8 = ((RangeToken)token).ranges[n4 + 1];
            if (n6 < n7) {
                n3 += 2;
                continue;
            }
            if (n6 >= n7 && n5 <= n8) {
                if (n7 <= n5 && n6 <= n8) {
                    nArray[n2++] = n5;
                    nArray[n2++] = n6;
                    n3 += 2;
                    continue;
                }
                if (n7 <= n5) {
                    nArray[n2++] = n5;
                    nArray[n2++] = n8;
                    this.ranges[n3] = n8 + 1;
                    n4 += 2;
                    continue;
                }
                if (n6 <= n8) {
                    nArray[n2++] = n7;
                    nArray[n2++] = n6;
                    n3 += 2;
                    continue;
                }
                nArray[n2++] = n7;
                nArray[n2++] = n8;
                this.ranges[n3] = n8 + 1;
                continue;
            }
            if (n8 < n5) {
                n4 += 2;
                continue;
            }
            throw new RuntimeException("Token#intersectRanges(): Internal Error: [" + this.ranges[n3] + "," + this.ranges[n3 + 1] + "] & [" + ((RangeToken)token).ranges[n4] + "," + ((RangeToken)token).ranges[n4 + 1] + "]");
        }
        while (n3 < this.ranges.length) {
            nArray[n2++] = this.ranges[n3++];
            nArray[n2++] = this.ranges[n3++];
        }
        this.ranges = new int[n2];
        System.arraycopy(nArray, 0, this.ranges, 0, n2);
    }

    static Token complementRanges(Token token) {
        int n2;
        if (token.type != 4 && token.type != 5) {
            throw new IllegalArgumentException("Token#complementRanges(): must be RANGE: " + token.type);
        }
        token = (RangeToken)token;
        ((RangeToken)token).sortRanges();
        ((RangeToken)token).compactRanges();
        int n3 = ((RangeToken)token).ranges.length + 2;
        if (((RangeToken)token).ranges[0] == 0) {
            n3 -= 2;
        }
        if ((n2 = ((RangeToken)token).ranges[((RangeToken)token).ranges.length - 1]) == 0x10FFFF) {
            n3 -= 2;
        }
        RangeToken rangeToken = Token.createRange();
        Token.createRange().ranges = new int[n3];
        n3 = 0;
        if (((RangeToken)token).ranges[0] > 0) {
            ++n3;
            rangeToken.ranges[0] = 0;
            ++n3;
            rangeToken.ranges[1] = ((RangeToken)token).ranges[0] - 1;
        }
        for (int i2 = 1; i2 < ((RangeToken)token).ranges.length - 2; i2 += 2) {
            rangeToken.ranges[n3++] = ((RangeToken)token).ranges[i2] + 1;
            rangeToken.ranges[n3++] = ((RangeToken)token).ranges[i2 + 1] - 1;
        }
        if (n2 != 0x10FFFF) {
            rangeToken.ranges[n3++] = n2 + 1;
            rangeToken.ranges[n3] = 0x10FFFF;
        }
        rangeToken.setCompacted();
        return rangeToken;
    }

    final synchronized RangeToken getCaseInsensitiveToken() {
        int n2;
        int n3;
        if (this.icaseCache != null) {
            return this.icaseCache;
        }
        RangeToken rangeToken = this.type == 4 ? Token.createRange() : Token.createNRange();
        for (int i2 = 0; i2 < this.ranges.length; i2 += 2) {
            for (n3 = this.ranges[i2]; n3 <= this.ranges[i2 + 1]; ++n3) {
                if (n3 > 65535) {
                    int n4 = n3;
                    rangeToken.addRange(n4, n4);
                    continue;
                }
                int n5 = n2 = (int)Character.toUpperCase((char)n3);
                rangeToken.addRange(n5, n5);
            }
        }
        RangeToken rangeToken2 = this.type == 4 ? Token.createRange() : Token.createNRange();
        for (n3 = 0; n3 < rangeToken.ranges.length; n3 += 2) {
            for (n2 = rangeToken.ranges[n3]; n2 <= rangeToken.ranges[n3 + 1]; ++n2) {
                char c2;
                if (n2 > 65535) {
                    int n6 = n2;
                    rangeToken2.addRange(n6, n6);
                    continue;
                }
                char c3 = c2 = Character.toUpperCase((char)n2);
                rangeToken2.addRange(c3, c3);
            }
        }
        rangeToken2.mergeRanges(rangeToken);
        rangeToken2.mergeRanges(this);
        rangeToken2.compactRanges();
        this.icaseCache = rangeToken2;
        return rangeToken2;
    }

    final void dumpRanges() {
        System.err.print("RANGE: ");
        if (this.ranges != null) {
            for (int i2 = 0; i2 < this.ranges.length; i2 += 2) {
                System.err.print("[" + this.ranges[i2] + "," + this.ranges[i2 + 1] + "] ");
            }
        } else {
            System.err.println(" NULL");
        }
        System.err.println("");
    }

    final boolean match(int n2) {
        boolean bl;
        if (this.map == null) {
            this.createMap();
        }
        if (this.type == 4) {
            if (n2 < 256) {
                return (this.map[n2 / 32] & 1 << (n2 & 0x1F)) != 0;
            }
            bl = false;
            for (int i2 = this.nonMapIndex; i2 < this.ranges.length; i2 += 2) {
                if (this.ranges[i2] > n2 || n2 > this.ranges[i2 + 1]) continue;
                return true;
            }
        } else {
            if (n2 < 256) {
                return (this.map[n2 / 32] & 1 << (n2 & 0x1F)) == 0;
            }
            bl = true;
            for (int i3 = this.nonMapIndex; i3 < this.ranges.length; i3 += 2) {
                if (this.ranges[i3] > n2 || n2 > this.ranges[i3 + 1]) continue;
                return false;
            }
        }
        return bl;
    }

    private void createMap() {
        int n2;
        this.map = new int[8];
        this.nonMapIndex = this.ranges.length;
        for (n2 = 0; n2 < 8; ++n2) {
            this.map[n2] = 0;
        }
        for (n2 = 0; n2 < this.ranges.length; n2 += 2) {
            int n3 = this.ranges[n2];
            int n4 = this.ranges[n2 + 1];
            if (n3 < 256) {
                while (n3 <= n4 && n3 < 256) {
                    int n5 = n3 / 32;
                    this.map[n5] = this.map[n5] | 1 << (n3 & 0x1F);
                    ++n3;
                }
            } else {
                this.nonMapIndex = n2;
                return;
            }
            if (n4 < 256) continue;
            this.nonMapIndex = n2;
            return;
        }
    }

    public final String toString(int n2) {
        String string;
        if (this.type == 4) {
            if (this == Token.token_dot) {
                string = ".";
            } else if (this == Token.token_0to9) {
                string = "\\d";
            } else if (this == Token.token_wordchars) {
                string = "\\w";
            } else if (this == Token.token_spaces) {
                string = "\\s";
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("[");
                for (int i2 = 0; i2 < this.ranges.length; i2 += 2) {
                    if ((n2 & 0x400) != 0 && i2 > 0) {
                        stringBuffer.append(",");
                    }
                    if (this.ranges[i2] == this.ranges[i2 + 1]) {
                        stringBuffer.append(RangeToken.escapeCharInCharClass(this.ranges[i2]));
                        continue;
                    }
                    stringBuffer.append(RangeToken.escapeCharInCharClass(this.ranges[i2]));
                    stringBuffer.append('-');
                    stringBuffer.append(RangeToken.escapeCharInCharClass(this.ranges[i2 + 1]));
                }
                stringBuffer.append("]");
                string = stringBuffer.toString();
            }
        } else if (this == Token.token_not_0to9) {
            string = "\\D";
        } else if (this == Token.token_not_wordchars) {
            string = "\\W";
        } else if (this == Token.token_not_spaces) {
            string = "\\S";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[^");
            for (int i3 = 0; i3 < this.ranges.length; i3 += 2) {
                if ((n2 & 0x400) != 0 && i3 > 0) {
                    stringBuffer.append(",");
                }
                if (this.ranges[i3] == this.ranges[i3 + 1]) {
                    stringBuffer.append(RangeToken.escapeCharInCharClass(this.ranges[i3]));
                    continue;
                }
                stringBuffer.append(RangeToken.escapeCharInCharClass(this.ranges[i3]));
                stringBuffer.append('-');
                stringBuffer.append(RangeToken.escapeCharInCharClass(this.ranges[i3 + 1]));
            }
            stringBuffer.append("]");
            string = stringBuffer.toString();
        }
        return string;
    }

    private static String escapeCharInCharClass(int n2) {
        String string;
        switch (n2) {
            case 44: 
            case 45: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                string = "\\" + (char)n2;
                break;
            }
            case 12: {
                string = "\\f";
                break;
            }
            case 10: {
                string = "\\n";
                break;
            }
            case 13: {
                string = "\\r";
                break;
            }
            case 9: {
                string = "\\t";
                break;
            }
            case 27: {
                string = "\\e";
                break;
            }
            default: {
                if (n2 < 32) {
                    String string2 = string = "0" + Integer.toHexString(n2);
                    string = "\\x" + string2.substring(string2.length() - 2, string.length());
                    break;
                }
                if (n2 >= 65536) {
                    String string3 = string = "0" + Integer.toHexString(n2);
                    string = "\\v" + string3.substring(string3.length() - 6, string.length());
                    break;
                }
                string = "" + (char)n2;
            }
        }
        return string;
    }
}

