/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.regexp;

import com.sun.msv.datatype.regexp.BMPattern;
import com.sun.msv.datatype.regexp.Match;
import com.sun.msv.datatype.regexp.Op;
import com.sun.msv.datatype.regexp.Op$ChildOp;
import com.sun.msv.datatype.regexp.Op$ConditionOp;
import com.sun.msv.datatype.regexp.Op$UnionOp;
import com.sun.msv.datatype.regexp.ParserForXMLSchema;
import com.sun.msv.datatype.regexp.REUtil;
import com.sun.msv.datatype.regexp.RangeToken;
import com.sun.msv.datatype.regexp.RegexParser;
import com.sun.msv.datatype.regexp.RegularExpression$Context;
import com.sun.msv.datatype.regexp.Token;
import com.sun.msv.datatype.regexp.Token$ConditionToken;
import com.sun.msv.datatype.regexp.Token$FixedStringContainer;
import com.sun.msv.datatype.regexp.Token$ModifierToken;
import java.io.Serializable;
import java.text.CharacterIterator;

class RegularExpression
implements Serializable {
    static final boolean DEBUG = false;
    String regex;
    int options;
    int nofparen;
    Token tokentree;
    boolean hasBackReferences = false;
    transient int minlength;
    transient Op operations = null;
    transient int numberOfClosures;
    transient RegularExpression$Context context = null;
    transient RangeToken firstChar = null;
    transient String fixedString = null;
    transient int fixedStringOptions;
    transient BMPattern fixedStringTable = null;
    transient boolean fixedStringOnly = false;
    static final int IGNORE_CASE = 2;
    static final int SINGLE_LINE = 4;
    static final int MULTIPLE_LINES = 8;
    static final int EXTENDED_COMMENT = 16;
    static final int USE_UNICODE_CATEGORY = 32;
    static final int UNICODE_WORD_BOUNDARY = 64;
    static final int PROHIBIT_HEAD_CHARACTER_OPTIMIZATION = 128;
    static final int PROHIBIT_FIXED_STRING_OPTIMIZATION = 256;
    static final int XMLSCHEMA_MODE = 512;
    static final int SPECIAL_COMMA = 1024;
    private static final int WT_IGNORE = 0;
    private static final int WT_LETTER = 1;
    private static final int WT_OTHER = 2;
    static final int LINE_FEED = 10;
    static final int CARRIAGE_RETURN = 13;
    static final int LINE_SEPARATOR = 8232;
    static final int PARAGRAPH_SEPARATOR = 8233;

    private synchronized void compile(Token token) {
        if (this.operations != null) {
            return;
        }
        this.numberOfClosures = 0;
        this.operations = this.compile(token, null, false);
    }

    private Op compile(Token token, Op op, boolean bl) {
        Op op2;
        switch (token.type) {
            case 11: {
                op2 = Op.createDot();
                Op.createDot().next = op;
                break;
            }
            case 0: {
                op2 = Op.createChar(token.getChar());
                Op.createChar(token.getChar()).next = op;
                break;
            }
            case 8: {
                op2 = Op.createAnchor(token.getChar());
                Op.createAnchor(token.getChar()).next = op;
                break;
            }
            case 4: 
            case 5: {
                op2 = Op.createRange(token);
                Op.createRange(token).next = op;
                break;
            }
            case 1: {
                op2 = op;
                if (!bl) {
                    for (int i2 = token.size() - 1; i2 >= 0; --i2) {
                        op2 = this.compile(token.getChild(i2), op2, false);
                    }
                } else {
                    for (int i3 = 0; i3 < token.size(); ++i3) {
                        op2 = this.compile(token.getChild(i3), op2, true);
                    }
                }
                break;
            }
            case 2: {
                Op$UnionOp op$UnionOp = Op.createUnion(token.size());
                for (int i4 = 0; i4 < token.size(); ++i4) {
                    op$UnionOp.addElement(this.compile(token.getChild(i4), op, bl));
                }
                op2 = op$UnionOp;
                break;
            }
            case 3: 
            case 9: {
                Token token2 = token.getChild(0);
                int n2 = token.getMin();
                int n3 = token.getMax();
                if (n2 >= 0 && n2 == n3) {
                    op2 = op;
                    for (int i5 = 0; i5 < n2; ++i5) {
                        op2 = this.compile(token2, op2, bl);
                    }
                } else {
                    if (n2 > 0 && n3 > 0) {
                        n3 -= n2;
                    }
                    if (n3 > 0) {
                        op2 = op;
                        for (int i6 = 0; i6 < n3; ++i6) {
                            Op$ChildOp op$ChildOp = Op.createQuestion(token.type == 9);
                            Op.createQuestion(token.type == 9).next = op;
                            op$ChildOp.setChild(this.compile(token2, op2, bl));
                            op2 = op$ChildOp;
                        }
                    } else {
                        Op$ChildOp op$ChildOp = token.type == 9 ? Op.createNonGreedyClosure() : (token2.getMinLength() == 0 ? Op.createClosure(this.numberOfClosures++) : Op.createClosure(-1));
                        op$ChildOp.next = op;
                        op$ChildOp.setChild(this.compile(token2, op$ChildOp, bl));
                        op2 = op$ChildOp;
                    }
                    if (n2 <= 0) break;
                    for (int i7 = 0; i7 < n2; ++i7) {
                        op2 = this.compile(token2, op2, bl);
                    }
                }
                break;
            }
            case 7: {
                op2 = op;
                break;
            }
            case 10: {
                op2 = Op.createString(token.getString());
                Op.createString(token.getString()).next = op;
                break;
            }
            case 12: {
                op2 = Op.createBackReference(token.getReferenceNumber());
                Op.createBackReference(token.getReferenceNumber()).next = op;
                break;
            }
            case 6: {
                if (token.getParenNumber() == 0) {
                    op2 = this.compile(token.getChild(0), op, bl);
                    break;
                }
                if (bl) {
                    op = Op.createCapture(token.getParenNumber(), op);
                    op = this.compile(token.getChild(0), op, bl);
                    op2 = Op.createCapture(-token.getParenNumber(), op);
                    break;
                }
                op = Op.createCapture(-token.getParenNumber(), op);
                op = this.compile(token.getChild(0), op, bl);
                op2 = Op.createCapture(token.getParenNumber(), op);
                break;
            }
            case 20: {
                op2 = Op.createLook(20, op, this.compile(token.getChild(0), null, false));
                break;
            }
            case 21: {
                op2 = Op.createLook(21, op, this.compile(token.getChild(0), null, false));
                break;
            }
            case 22: {
                op2 = Op.createLook(22, op, this.compile(token.getChild(0), null, true));
                break;
            }
            case 23: {
                op2 = Op.createLook(23, op, this.compile(token.getChild(0), null, true));
                break;
            }
            case 24: {
                op2 = Op.createIndependent(op, this.compile(token.getChild(0), null, bl));
                break;
            }
            case 25: {
                op2 = Op.createModifier(op, this.compile(token.getChild(0), null, bl), ((Token$ModifierToken)token).getOptions(), ((Token$ModifierToken)token).getOptionsMask());
                break;
            }
            case 26: {
                Token$ConditionToken token$ConditionToken = (Token$ConditionToken)token;
                int n4 = token$ConditionToken.refNumber;
                token = token$ConditionToken.condition == null ? null : this.compile(token$ConditionToken.condition, null, bl);
                op2 = this.compile(token$ConditionToken.yes, op, bl);
                Op op3 = token$ConditionToken.no == null ? null : this.compile(token$ConditionToken.no, op, bl);
                op2 = Op.createCondition(op, n4, (Op)((Object)token), op2, op3);
                break;
            }
            default: {
                throw new RuntimeException("Unknown token type: " + token.type);
            }
        }
        return op2;
    }

    public boolean matches(char[] cArray) {
        return this.matches(cArray, 0, cArray.length, null);
    }

    public boolean matches(char[] cArray, int n2, int n3) {
        return this.matches(cArray, n2, n3, null);
    }

    public boolean matches(char[] cArray, Match match) {
        return this.matches(cArray, 0, cArray.length, match);
    }

    public boolean matches(char[] cArray, int n2, int n3, Match object) {
        int n4;
        Object object2 = this;
        synchronized (object2) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new RegularExpression$Context();
            }
        }
        RegularExpression$Context regularExpression$Context = this.context;
        synchronized (regularExpression$Context) {
            object2 = this.context.inuse ? new RegularExpression$Context() : this.context;
            ((RegularExpression$Context)object2).reset(cArray, n2, n3, this.numberOfClosures);
        }
        if (object != null) {
            ((Match)object).setNumberOfGroups(this.nofparen);
            ((Match)object).setSource(cArray);
        } else if (this.hasBackReferences) {
            object = new Match();
            ((Match)object).setNumberOfGroups(this.nofparen);
        }
        ((RegularExpression$Context)object2).match = object;
        if (RegularExpression.isSet(this.options, 512)) {
            int n5 = this.matchCharArray((RegularExpression$Context)object2, this.operations, ((RegularExpression$Context)object2).start, 1, this.options);
            if (n5 == ((RegularExpression$Context)object2).limit) {
                if (((RegularExpression$Context)object2).match != null) {
                    ((RegularExpression$Context)object2).match.setBeginning(0, ((RegularExpression$Context)object2).start);
                    ((RegularExpression$Context)object2).match.setEnd(0, n5);
                }
                ((RegularExpression$Context)object2).inuse = false;
                return true;
            }
            return false;
        }
        if (this.fixedStringOnly) {
            int n6 = this.fixedStringTable.matches(cArray, ((RegularExpression$Context)object2).start, ((RegularExpression$Context)object2).limit);
            if (n6 >= 0) {
                if (((RegularExpression$Context)object2).match != null) {
                    ((RegularExpression$Context)object2).match.setBeginning(0, n6);
                    ((RegularExpression$Context)object2).match.setEnd(0, n6 + this.fixedString.length());
                }
                ((RegularExpression$Context)object2).inuse = false;
                return true;
            }
            ((RegularExpression$Context)object2).inuse = false;
            return false;
        }
        if (this.fixedString != null && (n4 = this.fixedStringTable.matches(cArray, ((RegularExpression$Context)object2).start, ((RegularExpression$Context)object2).limit)) < 0) {
            ((RegularExpression$Context)object2).inuse = false;
            return false;
        }
        int n7 = ((RegularExpression$Context)object2).limit - this.minlength;
        n3 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n2 = ((RegularExpression$Context)object2).start;
                n3 = this.matchCharArray((RegularExpression$Context)object2, this.operations, ((RegularExpression$Context)object2).start, 1, this.options);
            } else {
                boolean bl = true;
                for (n2 = ((RegularExpression$Context)object2).start; n2 <= n7; ++n2) {
                    char c2 = cArray[n2];
                    if (RegularExpression.isEOLChar(c2)) {
                        bl = true;
                        continue;
                    }
                    if (!bl || 0 > (n3 = this.matchCharArray((RegularExpression$Context)object2, this.operations, n2, 1, this.options))) {
                        bl = false;
                        continue;
                    }
                    break;
                }
            }
        } else if (this.firstChar != null) {
            object = this.firstChar;
            if (RegularExpression.isSet(this.options, 2)) {
                object = this.firstChar.getCaseInsensitiveToken();
                for (n2 = ((RegularExpression$Context)object2).start; n2 <= n7; ++n2) {
                    char c3 = cArray[n2];
                    if (!REUtil.isHighSurrogate(c3) || n2 + 1 >= ((RegularExpression$Context)object2).limit ? !((RangeToken)object).match(c3) && !((RangeToken)object).match(c3 = Character.toUpperCase(c3)) && !((RangeToken)object).match(Character.toLowerCase(c3)) : !((RangeToken)object).match(c3 = REUtil.composeFromSurrogates(c3, cArray[n2 + 1]))) continue;
                    n3 = this.matchCharArray((RegularExpression$Context)object2, this.operations, n2, 1, this.options);
                    if (0 > n3) {
                        continue;
                    }
                    break;
                }
            } else {
                for (n2 = ((RegularExpression$Context)object2).start; n2 <= n7; ++n2) {
                    int n8 = cArray[n2];
                    if (REUtil.isHighSurrogate(n8) && n2 + 1 < ((RegularExpression$Context)object2).limit) {
                        n8 = REUtil.composeFromSurrogates(n8, cArray[n2 + 1]);
                    }
                    if (!((RangeToken)object).match(n8) || 0 > (n3 = this.matchCharArray((RegularExpression$Context)object2, this.operations, n2, 1, this.options))) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            for (n2 = ((RegularExpression$Context)object2).start; n2 <= n7 && 0 > (n3 = this.matchCharArray((RegularExpression$Context)object2, this.operations, n2, 1, this.options)); ++n2) {
            }
        }
        if (n3 >= 0) {
            if (((RegularExpression$Context)object2).match != null) {
                ((RegularExpression$Context)object2).match.setBeginning(0, n2);
                ((RegularExpression$Context)object2).match.setEnd(0, n3);
            }
            ((RegularExpression$Context)object2).inuse = false;
            return true;
        }
        ((RegularExpression$Context)object2).inuse = false;
        return false;
    }

    private int matchCharArray(RegularExpression$Context regularExpression$Context, Op op, int n2, int n3, int n4) {
        char[] cArray = regularExpression$Context.charTarget;
        block32: while (true) {
            if (op == null) {
                if (RegularExpression.isSet(n4, 512) && n2 != regularExpression$Context.limit) {
                    return -1;
                }
                return n2;
            }
            if (n2 > regularExpression$Context.limit || n2 < regularExpression$Context.start) {
                return -1;
            }
            switch (op.type) {
                case 1: {
                    int n5;
                    if (RegularExpression.isSet(n4, 2)) {
                        n5 = op.getData();
                        if (n3 > 0) {
                            if (n2 >= regularExpression$Context.limit || !RegularExpression.matchIgnoreCase(n5, cArray[n2])) {
                                return -1;
                            }
                            ++n2;
                        } else {
                            int n6 = n2 - 1;
                            if (n6 >= regularExpression$Context.limit || n6 < 0 || !RegularExpression.matchIgnoreCase(n5, cArray[n6])) {
                                return -1;
                            }
                            n2 = n6;
                        }
                    } else {
                        n5 = op.getData();
                        if (n3 > 0) {
                            if (n2 >= regularExpression$Context.limit || n5 != cArray[n2]) {
                                return -1;
                            }
                            ++n2;
                        } else {
                            int n7 = n2 - 1;
                            if (n7 >= regularExpression$Context.limit || n7 < 0 || n5 != cArray[n7]) {
                                return -1;
                            }
                            n2 = n7;
                        }
                    }
                    op = op.next;
                    continue block32;
                }
                case 0: {
                    int n5;
                    if (n3 > 0) {
                        if (n2 >= regularExpression$Context.limit) {
                            return -1;
                        }
                        n5 = cArray[n2];
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isHighSurrogate(n5) && n2 + 1 < regularExpression$Context.limit) {
                                ++n2;
                            }
                        } else {
                            if (REUtil.isHighSurrogate(n5) && n2 + 1 < regularExpression$Context.limit) {
                                n5 = REUtil.composeFromSurrogates(n5, cArray[++n2]);
                            }
                            if (RegularExpression.isEOLChar(n5)) {
                                return -1;
                            }
                        }
                        ++n2;
                    } else {
                        n5 = n2 - 1;
                        if (n5 >= regularExpression$Context.limit || n5 < 0) {
                            return -1;
                        }
                        int n8 = cArray[n5];
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                // empty if block
                            }
                        } else {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                n8 = REUtil.composeFromSurrogates(cArray[--n5], n8);
                            }
                            if (!RegularExpression.isEOLChar(n8)) {
                                return -1;
                            }
                        }
                        n2 = --n5;
                    }
                    op = op.next;
                    continue block32;
                }
                case 3: 
                case 4: {
                    char c2;
                    int n5;
                    if (n3 > 0) {
                        if (n2 >= regularExpression$Context.limit) {
                            return -1;
                        }
                        n5 = cArray[n2];
                        if (REUtil.isHighSurrogate(n5) && n2 + 1 < regularExpression$Context.limit) {
                            n5 = REUtil.composeFromSurrogates(n5, cArray[++n2]);
                        }
                        RangeToken rangeToken = op.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n5)) {
                                if (n5 >= 65536) {
                                    return -1;
                                }
                                char c3 = Character.toUpperCase((char)n5);
                                if (!rangeToken.match(c3) && !rangeToken.match(Character.toLowerCase(c3))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n5)) {
                            return -1;
                        }
                        ++n2;
                    } else {
                        n5 = n2 - 1;
                        if (n5 >= regularExpression$Context.limit || n5 < 0) {
                            return -1;
                        }
                        int n9 = cArray[n5];
                        if (REUtil.isLowSurrogate(n9) && n5 - 1 >= 0) {
                            n9 = REUtil.composeFromSurrogates(cArray[--n5], n9);
                        }
                        RangeToken rangeToken = op.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n9)) {
                                if (n9 >= 65536) {
                                    return -1;
                                }
                                char c3 = Character.toUpperCase((char)n9);
                                c2 = c3;
                                if (!rangeToken.match(c3) && !rangeToken.match(Character.toLowerCase(c2))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n9)) {
                            return -1;
                        }
                        n2 = n5;
                    }
                    op = op.next;
                    continue block32;
                }
                case 5: {
                    int n5;
                    switch (op.getData()) {
                        case 94: {
                            if (!(RegularExpression.isSet(n4, 8) ? n2 != regularExpression$Context.start && (n2 <= regularExpression$Context.start || !RegularExpression.isEOLChar(cArray[n2 - 1])) : n2 != regularExpression$Context.start)) break;
                            return -1;
                        }
                        case 64: {
                            if (n2 == regularExpression$Context.start || n2 > regularExpression$Context.start && RegularExpression.isEOLChar(cArray[n2 - 1])) break;
                            return -1;
                        }
                        case 36: {
                            if (!(RegularExpression.isSet(n4, 8) ? n2 != regularExpression$Context.limit && (n2 >= regularExpression$Context.limit || !RegularExpression.isEOLChar(cArray[n2])) : !(n2 == regularExpression$Context.limit || n2 + 1 == regularExpression$Context.limit && RegularExpression.isEOLChar(cArray[n2]) || n2 + 2 == regularExpression$Context.limit && cArray[n2] == '\r' && cArray[n2 + 1] == '\n'))) break;
                            return -1;
                        }
                        case 65: {
                            if (n2 == regularExpression$Context.start) break;
                            return -1;
                        }
                        case 90: {
                            if (n2 == regularExpression$Context.limit || n2 + 1 == regularExpression$Context.limit && RegularExpression.isEOLChar(cArray[n2]) || n2 + 2 == regularExpression$Context.limit && cArray[n2] == '\r' && cArray[n2 + 1] == '\n') break;
                            return -1;
                        }
                        case 122: {
                            if (n2 == regularExpression$Context.limit) break;
                            return -1;
                        }
                        case 98: {
                            if (regularExpression$Context.length == 0) {
                                return -1;
                            }
                            int n10 = RegularExpression.getWordType(cArray, regularExpression$Context.start, regularExpression$Context.limit, n2, n4);
                            if (n10 == 0) {
                                return -1;
                            }
                            int n11 = RegularExpression.getPreviousWordType(cArray, regularExpression$Context.start, regularExpression$Context.limit, n2, n4);
                            if (n10 != n11) break;
                            return -1;
                        }
                        case 66: {
                            int n12;
                            if ((regularExpression$Context.length == 0 ? 1 : (n5 = (n12 = RegularExpression.getWordType(cArray, regularExpression$Context.start, regularExpression$Context.limit, n2, n4)) == 0 || n12 == RegularExpression.getPreviousWordType(cArray, regularExpression$Context.start, regularExpression$Context.limit, n2, n4) ? 1 : 0)) != 0) break;
                            return -1;
                        }
                        case 60: {
                            if (regularExpression$Context.length == 0 || n2 == regularExpression$Context.limit) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(cArray, regularExpression$Context.start, regularExpression$Context.limit, n2, n4) == 1 && RegularExpression.getPreviousWordType(cArray, regularExpression$Context.start, regularExpression$Context.limit, n2, n4) == 2) break;
                            return -1;
                        }
                        case 62: {
                            if (regularExpression$Context.length == 0 || n2 == regularExpression$Context.start) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(cArray, regularExpression$Context.start, regularExpression$Context.limit, n2, n4) == 2 && RegularExpression.getPreviousWordType(cArray, regularExpression$Context.start, regularExpression$Context.limit, n2, n4) == 1) break;
                            return -1;
                        }
                    }
                    op = op.next;
                    continue block32;
                }
                case 16: {
                    int n13 = op.getData();
                    if (n13 <= 0 || n13 >= this.nofparen) {
                        throw new RuntimeException("Internal Error: Reference number must be more than zero: " + n13);
                    }
                    if (regularExpression$Context.match.getBeginning(n13) < 0 || regularExpression$Context.match.getEnd(n13) < 0) {
                        return -1;
                    }
                    int n14 = regularExpression$Context.match.getBeginning(n13);
                    char c2 = regularExpression$Context.match.getEnd(n13) - n14;
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n3 > 0) {
                            if (!RegularExpression.regionMatches(cArray, n2, regularExpression$Context.limit, n14, (int)c2)) {
                                return -1;
                            }
                            n2 += c2;
                        } else {
                            if (!RegularExpression.regionMatches(cArray, n2 - c2, regularExpression$Context.limit, n14, (int)c2)) {
                                return -1;
                            }
                            n2 -= c2;
                        }
                    } else if (n3 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n2, regularExpression$Context.limit, n14, (int)c2)) {
                            return -1;
                        }
                        n2 += c2;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n2 - c2, regularExpression$Context.limit, n14, (int)c2)) {
                            return -1;
                        }
                        n2 -= c2;
                    }
                    op = op.next;
                    continue block32;
                }
                case 6: {
                    String string = op.getString();
                    int n15 = string.length();
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n3 > 0) {
                            if (!RegularExpression.regionMatches(cArray, n2, regularExpression$Context.limit, string, n15)) {
                                return -1;
                            }
                            n2 += n15;
                        } else {
                            if (!RegularExpression.regionMatches(cArray, n2 - n15, regularExpression$Context.limit, string, n15)) {
                                return -1;
                            }
                            n2 -= n15;
                        }
                    } else if (n3 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n2, regularExpression$Context.limit, string, n15)) {
                            return -1;
                        }
                        n2 += n15;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n2 - n15, regularExpression$Context.limit, string, n15)) {
                            return -1;
                        }
                        n2 -= n15;
                    }
                    op = op.next;
                    continue block32;
                }
                case 7: {
                    int n16 = op.getData();
                    if (n16 >= 0) {
                        int n17 = regularExpression$Context.offsets[n16];
                        if (n17 < 0 || n17 != n2) {
                            regularExpression$Context.offsets[n16] = n2;
                        } else {
                            regularExpression$Context.offsets[n16] = -1;
                            op = op.next;
                            continue block32;
                        }
                    }
                    int n18 = this.matchCharArray(regularExpression$Context, op.getChild(), n2, n3, n4);
                    if (n16 >= 0) {
                        regularExpression$Context.offsets[n16] = -1;
                    }
                    if (n18 >= 0) {
                        return n18;
                    }
                    op = op.next;
                    continue block32;
                }
                case 9: {
                    int n19 = this.matchCharArray(regularExpression$Context, op.getChild(), n2, n3, n4);
                    if (n19 >= 0) {
                        return n19;
                    }
                    op = op.next;
                    continue block32;
                }
                case 8: 
                case 10: {
                    int n20 = this.matchCharArray(regularExpression$Context, op.next, n2, n3, n4);
                    if (n20 >= 0) {
                        return n20;
                    }
                    op = op.getChild();
                    continue block32;
                }
                case 11: {
                    for (int i2 = 0; i2 < op.size(); ++i2) {
                        int n21 = this.matchCharArray(regularExpression$Context, op.elementAt(i2), n2, n3, n4);
                        if (n21 < 0) continue;
                        return n21;
                    }
                    return -1;
                }
                case 15: {
                    int n22 = op.getData();
                    if (regularExpression$Context.match != null && n22 > 0) {
                        int n23 = regularExpression$Context.match.getBeginning(n22);
                        regularExpression$Context.match.setBeginning(n22, n2);
                        int n5 = this.matchCharArray(regularExpression$Context, op.next, n2, n3, n4);
                        if (n5 < 0) {
                            regularExpression$Context.match.setBeginning(n22, n23);
                        }
                        return n5;
                    }
                    if (regularExpression$Context.match != null && n22 < 0) {
                        int n24 = -n22;
                        int n6 = regularExpression$Context.match.getEnd(n24);
                        regularExpression$Context.match.setEnd(n24, n2);
                        int n25 = this.matchCharArray(regularExpression$Context, op.next, n2, n3, n4);
                        if (n25 < 0) {
                            regularExpression$Context.match.setEnd(n24, n6);
                        }
                        return n25;
                    }
                    op = op.next;
                    continue block32;
                }
                case 20: {
                    if (0 > this.matchCharArray(regularExpression$Context, op.getChild(), n2, 1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 21: {
                    if (0 <= this.matchCharArray(regularExpression$Context, op.getChild(), n2, 1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 22: {
                    if (0 > this.matchCharArray(regularExpression$Context, op.getChild(), n2, -1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 23: {
                    if (0 <= this.matchCharArray(regularExpression$Context, op.getChild(), n2, -1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 24: {
                    int n26 = this.matchCharArray(regularExpression$Context, op.getChild(), n2, n3, n4);
                    if (n26 < 0) {
                        return n26;
                    }
                    n2 = n26;
                    op = op.next;
                    continue block32;
                }
                case 25: {
                    int n27 = n4 | op.getData();
                    char c2 = this.matchCharArray(regularExpression$Context, op.getChild(), n2, n3, n27 &= ~op.getData2());
                    if (c2 < '\u0000') {
                        return c2;
                    }
                    n2 = c2;
                    op = op.next;
                    continue block32;
                }
                case 26: {
                    char c2;
                    Op$ConditionOp op$ConditionOp = (Op$ConditionOp)op;
                    if (op$ConditionOp.refNumber > 0) {
                        if (op$ConditionOp.refNumber >= this.nofparen) {
                            throw new RuntimeException("Internal Error: Reference number must be more than zero: " + op$ConditionOp.refNumber);
                        }
                        c2 = regularExpression$Context.match.getBeginning(op$ConditionOp.refNumber) >= 0 && regularExpression$Context.match.getEnd(op$ConditionOp.refNumber) >= 0 ? (char)'\u0001' : '\u0000';
                    } else {
                        char c4 = c2 = 0 <= this.matchCharArray(regularExpression$Context, op$ConditionOp.condition, n2, n3, n4) ? (char)'\u0001' : '\u0000';
                    }
                    if (c2 != '\u0000') {
                        op = op$ConditionOp.yes;
                        continue block32;
                    }
                    if (op$ConditionOp.no != null) {
                        op = op$ConditionOp.no;
                        continue block32;
                    }
                    op = op$ConditionOp.next;
                    continue block32;
                }
            }
            break;
        }
        throw new RuntimeException("Unknown operation type: " + op.type);
    }

    private static final int getPreviousWordType(char[] cArray, int n2, int n3, int n4, int n5) {
        int n6 = RegularExpression.getWordType(cArray, n2, n3, --n4, n5);
        while (n6 == 0) {
            n6 = RegularExpression.getWordType(cArray, n2, n3, --n4, n5);
        }
        return n6;
    }

    private static final int getWordType(char[] cArray, int n2, int n3, int n4, int n5) {
        if (n4 < n2 || n4 >= n3) {
            return 2;
        }
        return RegularExpression.getWordType0(cArray[n4], n5);
    }

    private static final boolean regionMatches(char[] cArray, int n2, int n3, String string, int n4) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n4) {
            return false;
        }
        n3 = 0;
        while (n4-- > 0) {
            if (cArray[n2++] == string.charAt(n3++)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatches(char[] cArray, int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n5) {
            return false;
        }
        n3 = n4;
        while (n5-- > 0) {
            if (cArray[n2++] == cArray[n3++]) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(char[] cArray, int n2, int n3, String string, int n4) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n4) {
            return false;
        }
        n3 = 0;
        while (n4-- > 0) {
            char c2;
            char c3;
            if ((c3 = cArray[n2++]) == (c2 = string.charAt(n3++)) || (c3 = Character.toUpperCase(c3)) == (c2 = Character.toUpperCase(c2)) || Character.toLowerCase(c3) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(char[] cArray, int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n5) {
            return false;
        }
        n3 = n4;
        while (n5-- > 0) {
            char c2;
            if ((n4 = cArray[n2++]) == (c2 = cArray[n3++]) || (n4 = (int)Character.toUpperCase((char)n4)) == (c2 = Character.toUpperCase(c2)) || Character.toLowerCase((char)n4) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(String string) {
        return this.matches(string, 0, string.length(), null);
    }

    public boolean matches(String string, int n2, int n3) {
        return this.matches(string, n2, n3, null);
    }

    public boolean matches(String string, Match match) {
        return this.matches(string, 0, string.length(), match);
    }

    public boolean matches(String string, int n2, int n3, Match object) {
        int n4;
        Object object2 = this;
        synchronized (object2) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new RegularExpression$Context();
            }
        }
        RegularExpression$Context regularExpression$Context = this.context;
        synchronized (regularExpression$Context) {
            object2 = this.context.inuse ? new RegularExpression$Context() : this.context;
            ((RegularExpression$Context)object2).reset(string, n2, n3, this.numberOfClosures);
        }
        if (object != null) {
            ((Match)object).setNumberOfGroups(this.nofparen);
            ((Match)object).setSource(string);
        } else if (this.hasBackReferences) {
            object = new Match();
            ((Match)object).setNumberOfGroups(this.nofparen);
        }
        ((RegularExpression$Context)object2).match = object;
        if (RegularExpression.isSet(this.options, 512)) {
            int n5 = this.matchString((RegularExpression$Context)object2, this.operations, ((RegularExpression$Context)object2).start, 1, this.options);
            if (n5 == ((RegularExpression$Context)object2).limit) {
                if (((RegularExpression$Context)object2).match != null) {
                    ((RegularExpression$Context)object2).match.setBeginning(0, ((RegularExpression$Context)object2).start);
                    ((RegularExpression$Context)object2).match.setEnd(0, n5);
                }
                ((RegularExpression$Context)object2).inuse = false;
                return true;
            }
            return false;
        }
        if (this.fixedStringOnly) {
            int n6 = this.fixedStringTable.matches(string, ((RegularExpression$Context)object2).start, ((RegularExpression$Context)object2).limit);
            if (n6 >= 0) {
                if (((RegularExpression$Context)object2).match != null) {
                    ((RegularExpression$Context)object2).match.setBeginning(0, n6);
                    ((RegularExpression$Context)object2).match.setEnd(0, n6 + this.fixedString.length());
                }
                ((RegularExpression$Context)object2).inuse = false;
                return true;
            }
            ((RegularExpression$Context)object2).inuse = false;
            return false;
        }
        if (this.fixedString != null && (n4 = this.fixedStringTable.matches(string, ((RegularExpression$Context)object2).start, ((RegularExpression$Context)object2).limit)) < 0) {
            ((RegularExpression$Context)object2).inuse = false;
            return false;
        }
        int n7 = ((RegularExpression$Context)object2).limit - this.minlength;
        n3 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n2 = ((RegularExpression$Context)object2).start;
                n3 = this.matchString((RegularExpression$Context)object2, this.operations, ((RegularExpression$Context)object2).start, 1, this.options);
            } else {
                boolean bl = true;
                for (n2 = ((RegularExpression$Context)object2).start; n2 <= n7; ++n2) {
                    char c2 = string.charAt(n2);
                    if (RegularExpression.isEOLChar(c2)) {
                        bl = true;
                        continue;
                    }
                    if (!bl || 0 > (n3 = this.matchString((RegularExpression$Context)object2, this.operations, n2, 1, this.options))) {
                        bl = false;
                        continue;
                    }
                    break;
                }
            }
        } else if (this.firstChar != null) {
            object = this.firstChar;
            if (RegularExpression.isSet(this.options, 2)) {
                object = this.firstChar.getCaseInsensitiveToken();
                for (n2 = ((RegularExpression$Context)object2).start; n2 <= n7; ++n2) {
                    char c3 = string.charAt(n2);
                    if (!REUtil.isHighSurrogate(c3) || n2 + 1 >= ((RegularExpression$Context)object2).limit ? !((RangeToken)object).match(c3) && !((RangeToken)object).match(c3 = Character.toUpperCase(c3)) && !((RangeToken)object).match(Character.toLowerCase(c3)) : !((RangeToken)object).match(c3 = REUtil.composeFromSurrogates(c3, string.charAt(n2 + 1)))) continue;
                    n3 = this.matchString((RegularExpression$Context)object2, this.operations, n2, 1, this.options);
                    if (0 > n3) {
                        continue;
                    }
                    break;
                }
            } else {
                for (n2 = ((RegularExpression$Context)object2).start; n2 <= n7; ++n2) {
                    int n8 = string.charAt(n2);
                    if (REUtil.isHighSurrogate(n8) && n2 + 1 < ((RegularExpression$Context)object2).limit) {
                        n8 = REUtil.composeFromSurrogates(n8, string.charAt(n2 + 1));
                    }
                    if (!((RangeToken)object).match(n8) || 0 > (n3 = this.matchString((RegularExpression$Context)object2, this.operations, n2, 1, this.options))) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            for (n2 = ((RegularExpression$Context)object2).start; n2 <= n7 && 0 > (n3 = this.matchString((RegularExpression$Context)object2, this.operations, n2, 1, this.options)); ++n2) {
            }
        }
        if (n3 >= 0) {
            if (((RegularExpression$Context)object2).match != null) {
                ((RegularExpression$Context)object2).match.setBeginning(0, n2);
                ((RegularExpression$Context)object2).match.setEnd(0, n3);
            }
            ((RegularExpression$Context)object2).inuse = false;
            return true;
        }
        ((RegularExpression$Context)object2).inuse = false;
        return false;
    }

    private int matchString(RegularExpression$Context regularExpression$Context, Op op, int n2, int n3, int n4) {
        String string = regularExpression$Context.strTarget;
        block32: while (true) {
            if (op == null) {
                if (RegularExpression.isSet(n4, 512) && n2 != regularExpression$Context.limit) {
                    return -1;
                }
                return n2;
            }
            if (n2 > regularExpression$Context.limit || n2 < regularExpression$Context.start) {
                return -1;
            }
            switch (op.type) {
                case 1: {
                    int n5;
                    if (RegularExpression.isSet(n4, 2)) {
                        n5 = op.getData();
                        if (n3 > 0) {
                            if (n2 >= regularExpression$Context.limit || !RegularExpression.matchIgnoreCase(n5, string.charAt(n2))) {
                                return -1;
                            }
                            ++n2;
                        } else {
                            int n6 = n2 - 1;
                            if (n6 >= regularExpression$Context.limit || n6 < 0 || !RegularExpression.matchIgnoreCase(n5, string.charAt(n6))) {
                                return -1;
                            }
                            n2 = n6;
                        }
                    } else {
                        n5 = op.getData();
                        if (n3 > 0) {
                            if (n2 >= regularExpression$Context.limit || n5 != string.charAt(n2)) {
                                return -1;
                            }
                            ++n2;
                        } else {
                            int n7 = n2 - 1;
                            if (n7 >= regularExpression$Context.limit || n7 < 0 || n5 != string.charAt(n7)) {
                                return -1;
                            }
                            n2 = n7;
                        }
                    }
                    op = op.next;
                    continue block32;
                }
                case 0: {
                    int n5;
                    if (n3 > 0) {
                        if (n2 >= regularExpression$Context.limit) {
                            return -1;
                        }
                        n5 = string.charAt(n2);
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isHighSurrogate(n5) && n2 + 1 < regularExpression$Context.limit) {
                                ++n2;
                            }
                        } else {
                            if (REUtil.isHighSurrogate(n5) && n2 + 1 < regularExpression$Context.limit) {
                                n5 = REUtil.composeFromSurrogates(n5, string.charAt(++n2));
                            }
                            if (RegularExpression.isEOLChar(n5)) {
                                return -1;
                            }
                        }
                        ++n2;
                    } else {
                        n5 = n2 - 1;
                        if (n5 >= regularExpression$Context.limit || n5 < 0) {
                            return -1;
                        }
                        int n8 = string.charAt(n5);
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                // empty if block
                            }
                        } else {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                n8 = REUtil.composeFromSurrogates(string.charAt(--n5), n8);
                            }
                            if (!RegularExpression.isEOLChar(n8)) {
                                return -1;
                            }
                        }
                        n2 = --n5;
                    }
                    op = op.next;
                    continue block32;
                }
                case 3: 
                case 4: {
                    char c2;
                    int n5;
                    if (n3 > 0) {
                        if (n2 >= regularExpression$Context.limit) {
                            return -1;
                        }
                        char c3 = string.charAt(n2);
                        n5 = c3;
                        if (REUtil.isHighSurrogate(c3) && n2 + 1 < regularExpression$Context.limit) {
                            n5 = REUtil.composeFromSurrogates(n5, string.charAt(++n2));
                        }
                        RangeToken rangeToken = op.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n5)) {
                                if (n5 >= 65536) {
                                    return -1;
                                }
                                char c4 = Character.toUpperCase((char)n5);
                                if (!rangeToken.match(c4) && !rangeToken.match(Character.toLowerCase(c4))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n5)) {
                            return -1;
                        }
                        ++n2;
                    } else {
                        n5 = n2 - 1;
                        if (n5 >= regularExpression$Context.limit || n5 < 0) {
                            return -1;
                        }
                        int n9 = string.charAt(n5);
                        if (REUtil.isLowSurrogate(n9) && n5 - 1 >= 0) {
                            n9 = REUtil.composeFromSurrogates(string.charAt(--n5), n9);
                        }
                        RangeToken rangeToken = op.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n9)) {
                                if (n9 >= 65536) {
                                    return -1;
                                }
                                char c4 = Character.toUpperCase((char)n9);
                                c2 = c4;
                                if (!rangeToken.match(c4) && !rangeToken.match(Character.toLowerCase(c2))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n9)) {
                            return -1;
                        }
                        n2 = n5;
                    }
                    op = op.next;
                    continue block32;
                }
                case 5: {
                    int n5;
                    switch (op.getData()) {
                        case 94: {
                            if (!(RegularExpression.isSet(n4, 8) ? n2 != regularExpression$Context.start && (n2 <= regularExpression$Context.start || !RegularExpression.isEOLChar(string.charAt(n2 - 1))) : n2 != regularExpression$Context.start)) break;
                            return -1;
                        }
                        case 64: {
                            if (n2 == regularExpression$Context.start || n2 > regularExpression$Context.start && RegularExpression.isEOLChar(string.charAt(n2 - 1))) break;
                            return -1;
                        }
                        case 36: {
                            if (!(RegularExpression.isSet(n4, 8) ? n2 != regularExpression$Context.limit && (n2 >= regularExpression$Context.limit || !RegularExpression.isEOLChar(string.charAt(n2))) : !(n2 == regularExpression$Context.limit || n2 + 1 == regularExpression$Context.limit && RegularExpression.isEOLChar(string.charAt(n2)) || n2 + 2 == regularExpression$Context.limit && string.charAt(n2) == '\r' && string.charAt(n2 + 1) == '\n'))) break;
                            return -1;
                        }
                        case 65: {
                            if (n2 == regularExpression$Context.start) break;
                            return -1;
                        }
                        case 90: {
                            if (n2 == regularExpression$Context.limit || n2 + 1 == regularExpression$Context.limit && RegularExpression.isEOLChar(string.charAt(n2)) || n2 + 2 == regularExpression$Context.limit && string.charAt(n2) == '\r' && string.charAt(n2 + 1) == '\n') break;
                            return -1;
                        }
                        case 122: {
                            if (n2 == regularExpression$Context.limit) break;
                            return -1;
                        }
                        case 98: {
                            if (regularExpression$Context.length == 0) {
                                return -1;
                            }
                            int n10 = RegularExpression.getWordType(string, regularExpression$Context.start, regularExpression$Context.limit, n2, n4);
                            if (n10 == 0) {
                                return -1;
                            }
                            int n11 = RegularExpression.getPreviousWordType(string, regularExpression$Context.start, regularExpression$Context.limit, n2, n4);
                            if (n10 != n11) break;
                            return -1;
                        }
                        case 66: {
                            int n12;
                            if ((regularExpression$Context.length == 0 ? 1 : (n5 = (n12 = RegularExpression.getWordType(string, regularExpression$Context.start, regularExpression$Context.limit, n2, n4)) == 0 || n12 == RegularExpression.getPreviousWordType(string, regularExpression$Context.start, regularExpression$Context.limit, n2, n4) ? 1 : 0)) != 0) break;
                            return -1;
                        }
                        case 60: {
                            if (regularExpression$Context.length == 0 || n2 == regularExpression$Context.limit) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(string, regularExpression$Context.start, regularExpression$Context.limit, n2, n4) == 1 && RegularExpression.getPreviousWordType(string, regularExpression$Context.start, regularExpression$Context.limit, n2, n4) == 2) break;
                            return -1;
                        }
                        case 62: {
                            if (regularExpression$Context.length == 0 || n2 == regularExpression$Context.start) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(string, regularExpression$Context.start, regularExpression$Context.limit, n2, n4) == 2 && RegularExpression.getPreviousWordType(string, regularExpression$Context.start, regularExpression$Context.limit, n2, n4) == 1) break;
                            return -1;
                        }
                    }
                    op = op.next;
                    continue block32;
                }
                case 16: {
                    int n13 = op.getData();
                    if (n13 <= 0 || n13 >= this.nofparen) {
                        throw new RuntimeException("Internal Error: Reference number must be more than zero: " + n13);
                    }
                    if (regularExpression$Context.match.getBeginning(n13) < 0 || regularExpression$Context.match.getEnd(n13) < 0) {
                        return -1;
                    }
                    int n14 = regularExpression$Context.match.getBeginning(n13);
                    char c2 = regularExpression$Context.match.getEnd(n13) - n14;
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n3 > 0) {
                            if (!RegularExpression.regionMatches(string, n2, regularExpression$Context.limit, n14, (int)c2)) {
                                return -1;
                            }
                            n2 += c2;
                        } else {
                            if (!RegularExpression.regionMatches(string, n2 - c2, regularExpression$Context.limit, n14, (int)c2)) {
                                return -1;
                            }
                            n2 -= c2;
                        }
                    } else if (n3 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(string, n2, regularExpression$Context.limit, n14, (int)c2)) {
                            return -1;
                        }
                        n2 += c2;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(string, n2 - c2, regularExpression$Context.limit, n14, (int)c2)) {
                            return -1;
                        }
                        n2 -= c2;
                    }
                    op = op.next;
                    continue block32;
                }
                case 6: {
                    String string2 = op.getString();
                    int n15 = string2.length();
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n3 > 0) {
                            if (!RegularExpression.regionMatches(string, n2, regularExpression$Context.limit, string2, n15)) {
                                return -1;
                            }
                            n2 += n15;
                        } else {
                            if (!RegularExpression.regionMatches(string, n2 - n15, regularExpression$Context.limit, string2, n15)) {
                                return -1;
                            }
                            n2 -= n15;
                        }
                    } else if (n3 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(string, n2, regularExpression$Context.limit, string2, n15)) {
                            return -1;
                        }
                        n2 += n15;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(string, n2 - n15, regularExpression$Context.limit, string2, n15)) {
                            return -1;
                        }
                        n2 -= n15;
                    }
                    op = op.next;
                    continue block32;
                }
                case 7: {
                    int n16 = op.getData();
                    if (n16 >= 0) {
                        int n17 = regularExpression$Context.offsets[n16];
                        if (n17 < 0 || n17 != n2) {
                            regularExpression$Context.offsets[n16] = n2;
                        } else {
                            regularExpression$Context.offsets[n16] = -1;
                            op = op.next;
                            continue block32;
                        }
                    }
                    int n18 = this.matchString(regularExpression$Context, op.getChild(), n2, n3, n4);
                    if (n16 >= 0) {
                        regularExpression$Context.offsets[n16] = -1;
                    }
                    if (n18 >= 0) {
                        return n18;
                    }
                    op = op.next;
                    continue block32;
                }
                case 9: {
                    int n19 = this.matchString(regularExpression$Context, op.getChild(), n2, n3, n4);
                    if (n19 >= 0) {
                        return n19;
                    }
                    op = op.next;
                    continue block32;
                }
                case 8: 
                case 10: {
                    int n20 = this.matchString(regularExpression$Context, op.next, n2, n3, n4);
                    if (n20 >= 0) {
                        return n20;
                    }
                    op = op.getChild();
                    continue block32;
                }
                case 11: {
                    for (int i2 = 0; i2 < op.size(); ++i2) {
                        int n21 = this.matchString(regularExpression$Context, op.elementAt(i2), n2, n3, n4);
                        if (n21 < 0) continue;
                        return n21;
                    }
                    return -1;
                }
                case 15: {
                    int n22 = op.getData();
                    if (regularExpression$Context.match != null && n22 > 0) {
                        int n23 = regularExpression$Context.match.getBeginning(n22);
                        regularExpression$Context.match.setBeginning(n22, n2);
                        int n5 = this.matchString(regularExpression$Context, op.next, n2, n3, n4);
                        if (n5 < 0) {
                            regularExpression$Context.match.setBeginning(n22, n23);
                        }
                        return n5;
                    }
                    if (regularExpression$Context.match != null && n22 < 0) {
                        int n24 = -n22;
                        int n6 = regularExpression$Context.match.getEnd(n24);
                        regularExpression$Context.match.setEnd(n24, n2);
                        int n25 = this.matchString(regularExpression$Context, op.next, n2, n3, n4);
                        if (n25 < 0) {
                            regularExpression$Context.match.setEnd(n24, n6);
                        }
                        return n25;
                    }
                    op = op.next;
                    continue block32;
                }
                case 20: {
                    if (0 > this.matchString(regularExpression$Context, op.getChild(), n2, 1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 21: {
                    if (0 <= this.matchString(regularExpression$Context, op.getChild(), n2, 1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 22: {
                    if (0 > this.matchString(regularExpression$Context, op.getChild(), n2, -1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 23: {
                    if (0 <= this.matchString(regularExpression$Context, op.getChild(), n2, -1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 24: {
                    int n26 = this.matchString(regularExpression$Context, op.getChild(), n2, n3, n4);
                    if (n26 < 0) {
                        return n26;
                    }
                    n2 = n26;
                    op = op.next;
                    continue block32;
                }
                case 25: {
                    int n27 = n4 | op.getData();
                    char c2 = this.matchString(regularExpression$Context, op.getChild(), n2, n3, n27 &= ~op.getData2());
                    if (c2 < '\u0000') {
                        return c2;
                    }
                    n2 = c2;
                    op = op.next;
                    continue block32;
                }
                case 26: {
                    char c2;
                    Op$ConditionOp op$ConditionOp = (Op$ConditionOp)op;
                    if (op$ConditionOp.refNumber > 0) {
                        if (op$ConditionOp.refNumber >= this.nofparen) {
                            throw new RuntimeException("Internal Error: Reference number must be more than zero: " + op$ConditionOp.refNumber);
                        }
                        c2 = regularExpression$Context.match.getBeginning(op$ConditionOp.refNumber) >= 0 && regularExpression$Context.match.getEnd(op$ConditionOp.refNumber) >= 0 ? (char)'\u0001' : '\u0000';
                    } else {
                        char c5 = c2 = 0 <= this.matchString(regularExpression$Context, op$ConditionOp.condition, n2, n3, n4) ? (char)'\u0001' : '\u0000';
                    }
                    if (c2 != '\u0000') {
                        op = op$ConditionOp.yes;
                        continue block32;
                    }
                    if (op$ConditionOp.no != null) {
                        op = op$ConditionOp.no;
                        continue block32;
                    }
                    op = op$ConditionOp.next;
                    continue block32;
                }
            }
            break;
        }
        throw new RuntimeException("Unknown operation type: " + op.type);
    }

    private static final int getPreviousWordType(String string, int n2, int n3, int n4, int n5) {
        int n6 = RegularExpression.getWordType(string, n2, n3, --n4, n5);
        while (n6 == 0) {
            n6 = RegularExpression.getWordType(string, n2, n3, --n4, n5);
        }
        return n6;
    }

    private static final int getWordType(String string, int n2, int n3, int n4, int n5) {
        if (n4 < n2 || n4 >= n3) {
            return 2;
        }
        return RegularExpression.getWordType0(string.charAt(n4), n5);
    }

    private static final boolean regionMatches(String string, int n2, int n3, String string2, int n4) {
        if (n3 - n2 < n4) {
            return false;
        }
        return string.regionMatches(n2, string2, 0, n4);
    }

    private static final boolean regionMatches(String string, int n2, int n3, int n4, int n5) {
        if (n3 - n2 < n5) {
            return false;
        }
        return string.regionMatches(n2, string, n4, n5);
    }

    private static final boolean regionMatchesIgnoreCase(String string, int n2, int n3, String string2, int n4) {
        return string.regionMatches(true, n2, string2, 0, n4);
    }

    private static final boolean regionMatchesIgnoreCase(String string, int n2, int n3, int n4, int n5) {
        if (n3 - n2 < n5) {
            return false;
        }
        return string.regionMatches(true, n2, string, n4, n5);
    }

    public boolean matches(CharacterIterator characterIterator) {
        return this.matches(characterIterator, null);
    }

    public boolean matches(CharacterIterator characterIterator, Match match) {
        int n2;
        int n3;
        int n4 = characterIterator.getBeginIndex();
        int n5 = characterIterator.getEndIndex();
        Object object = this;
        synchronized (object) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new RegularExpression$Context();
            }
        }
        RegularExpression$Context regularExpression$Context = this.context;
        synchronized (regularExpression$Context) {
            object = this.context.inuse ? new RegularExpression$Context() : this.context;
            ((RegularExpression$Context)object).reset(characterIterator, n4, n5, this.numberOfClosures);
        }
        if (match != null) {
            match.setNumberOfGroups(this.nofparen);
            match.setSource(characterIterator);
        } else if (this.hasBackReferences) {
            match = new Match();
            match.setNumberOfGroups(this.nofparen);
        }
        ((RegularExpression$Context)object).match = match;
        if (RegularExpression.isSet(this.options, 512)) {
            int n6 = this.matchCharacterIterator((RegularExpression$Context)object, this.operations, ((RegularExpression$Context)object).start, 1, this.options);
            if (n6 == ((RegularExpression$Context)object).limit) {
                if (((RegularExpression$Context)object).match != null) {
                    ((RegularExpression$Context)object).match.setBeginning(0, ((RegularExpression$Context)object).start);
                    ((RegularExpression$Context)object).match.setEnd(0, n6);
                }
                ((RegularExpression$Context)object).inuse = false;
                return true;
            }
            return false;
        }
        if (this.fixedStringOnly) {
            int n7 = this.fixedStringTable.matches(characterIterator, ((RegularExpression$Context)object).start, ((RegularExpression$Context)object).limit);
            if (n7 >= 0) {
                if (((RegularExpression$Context)object).match != null) {
                    ((RegularExpression$Context)object).match.setBeginning(0, n7);
                    ((RegularExpression$Context)object).match.setEnd(0, n7 + this.fixedString.length());
                }
                ((RegularExpression$Context)object).inuse = false;
                return true;
            }
            ((RegularExpression$Context)object).inuse = false;
            return false;
        }
        if (this.fixedString != null && (n3 = this.fixedStringTable.matches(characterIterator, ((RegularExpression$Context)object).start, ((RegularExpression$Context)object).limit)) < 0) {
            ((RegularExpression$Context)object).inuse = false;
            return false;
        }
        int n8 = ((RegularExpression$Context)object).limit - this.minlength;
        n4 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n2 = ((RegularExpression$Context)object).start;
                n4 = this.matchCharacterIterator((RegularExpression$Context)object, this.operations, ((RegularExpression$Context)object).start, 1, this.options);
            } else {
                n5 = 1;
                for (n2 = ((RegularExpression$Context)object).start; n2 <= n8; ++n2) {
                    char c2 = characterIterator.setIndex(n2);
                    if (RegularExpression.isEOLChar(c2)) {
                        n5 = 1;
                        continue;
                    }
                    if (n5 == 0 || 0 > (n4 = this.matchCharacterIterator((RegularExpression$Context)object, this.operations, n2, 1, this.options))) {
                        n5 = 0;
                        continue;
                    }
                    break;
                }
            }
        } else if (this.firstChar != null) {
            RangeToken rangeToken = this.firstChar;
            if (RegularExpression.isSet(this.options, 2)) {
                rangeToken = this.firstChar.getCaseInsensitiveToken();
                for (n2 = ((RegularExpression$Context)object).start; n2 <= n8; ++n2) {
                    char c3 = characterIterator.setIndex(n2);
                    if (!REUtil.isHighSurrogate(c3) || n2 + 1 >= ((RegularExpression$Context)object).limit ? !rangeToken.match(c3) && !rangeToken.match(c3 = Character.toUpperCase(c3)) && !rangeToken.match(Character.toLowerCase(c3)) : !rangeToken.match(c3 = REUtil.composeFromSurrogates(c3, characterIterator.setIndex(n2 + 1)))) continue;
                    n4 = this.matchCharacterIterator((RegularExpression$Context)object, this.operations, n2, 1, this.options);
                    if (0 > n4) {
                        continue;
                    }
                    break;
                }
            } else {
                for (n2 = ((RegularExpression$Context)object).start; n2 <= n8; ++n2) {
                    int n9 = characterIterator.setIndex(n2);
                    if (REUtil.isHighSurrogate(n9) && n2 + 1 < ((RegularExpression$Context)object).limit) {
                        n9 = REUtil.composeFromSurrogates(n9, characterIterator.setIndex(n2 + 1));
                    }
                    if (!rangeToken.match(n9) || 0 > (n4 = this.matchCharacterIterator((RegularExpression$Context)object, this.operations, n2, 1, this.options))) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            for (n2 = ((RegularExpression$Context)object).start; n2 <= n8 && 0 > (n4 = this.matchCharacterIterator((RegularExpression$Context)object, this.operations, n2, 1, this.options)); ++n2) {
            }
        }
        if (n4 >= 0) {
            if (((RegularExpression$Context)object).match != null) {
                ((RegularExpression$Context)object).match.setBeginning(0, n2);
                ((RegularExpression$Context)object).match.setEnd(0, n4);
            }
            ((RegularExpression$Context)object).inuse = false;
            return true;
        }
        ((RegularExpression$Context)object).inuse = false;
        return false;
    }

    private int matchCharacterIterator(RegularExpression$Context regularExpression$Context, Op op, int n2, int n3, int n4) {
        CharacterIterator characterIterator = regularExpression$Context.ciTarget;
        block32: while (true) {
            if (op == null) {
                if (RegularExpression.isSet(n4, 512) && n2 != regularExpression$Context.limit) {
                    return -1;
                }
                return n2;
            }
            if (n2 > regularExpression$Context.limit || n2 < regularExpression$Context.start) {
                return -1;
            }
            switch (op.type) {
                case 1: {
                    int n5;
                    if (RegularExpression.isSet(n4, 2)) {
                        n5 = op.getData();
                        if (n3 > 0) {
                            if (n2 >= regularExpression$Context.limit || !RegularExpression.matchIgnoreCase(n5, characterIterator.setIndex(n2))) {
                                return -1;
                            }
                            ++n2;
                        } else {
                            int n6 = n2 - 1;
                            if (n6 >= regularExpression$Context.limit || n6 < 0 || !RegularExpression.matchIgnoreCase(n5, characterIterator.setIndex(n6))) {
                                return -1;
                            }
                            n2 = n6;
                        }
                    } else {
                        n5 = op.getData();
                        if (n3 > 0) {
                            if (n2 >= regularExpression$Context.limit || n5 != characterIterator.setIndex(n2)) {
                                return -1;
                            }
                            ++n2;
                        } else {
                            int n7 = n2 - 1;
                            if (n7 >= regularExpression$Context.limit || n7 < 0 || n5 != characterIterator.setIndex(n7)) {
                                return -1;
                            }
                            n2 = n7;
                        }
                    }
                    op = op.next;
                    continue block32;
                }
                case 0: {
                    int n5;
                    if (n3 > 0) {
                        if (n2 >= regularExpression$Context.limit) {
                            return -1;
                        }
                        n5 = characterIterator.setIndex(n2);
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isHighSurrogate(n5) && n2 + 1 < regularExpression$Context.limit) {
                                ++n2;
                            }
                        } else {
                            if (REUtil.isHighSurrogate(n5) && n2 + 1 < regularExpression$Context.limit) {
                                n5 = REUtil.composeFromSurrogates(n5, characterIterator.setIndex(++n2));
                            }
                            if (RegularExpression.isEOLChar(n5)) {
                                return -1;
                            }
                        }
                        ++n2;
                    } else {
                        n5 = n2 - 1;
                        if (n5 >= regularExpression$Context.limit || n5 < 0) {
                            return -1;
                        }
                        int n8 = characterIterator.setIndex(n5);
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                // empty if block
                            }
                        } else {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                n8 = REUtil.composeFromSurrogates(characterIterator.setIndex(--n5), n8);
                            }
                            if (!RegularExpression.isEOLChar(n8)) {
                                return -1;
                            }
                        }
                        n2 = --n5;
                    }
                    op = op.next;
                    continue block32;
                }
                case 3: 
                case 4: {
                    char c2;
                    int n5;
                    if (n3 > 0) {
                        if (n2 >= regularExpression$Context.limit) {
                            return -1;
                        }
                        char c3 = characterIterator.setIndex(n2);
                        n5 = c3;
                        if (REUtil.isHighSurrogate(c3) && n2 + 1 < regularExpression$Context.limit) {
                            n5 = REUtil.composeFromSurrogates(n5, characterIterator.setIndex(++n2));
                        }
                        RangeToken rangeToken = op.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n5)) {
                                if (n5 >= 65536) {
                                    return -1;
                                }
                                char c4 = Character.toUpperCase((char)n5);
                                if (!rangeToken.match(c4) && !rangeToken.match(Character.toLowerCase(c4))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n5)) {
                            return -1;
                        }
                        ++n2;
                    } else {
                        n5 = n2 - 1;
                        if (n5 >= regularExpression$Context.limit || n5 < 0) {
                            return -1;
                        }
                        int n9 = characterIterator.setIndex(n5);
                        if (REUtil.isLowSurrogate(n9) && n5 - 1 >= 0) {
                            n9 = REUtil.composeFromSurrogates(characterIterator.setIndex(--n5), n9);
                        }
                        RangeToken rangeToken = op.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n9)) {
                                if (n9 >= 65536) {
                                    return -1;
                                }
                                char c4 = Character.toUpperCase((char)n9);
                                c2 = c4;
                                if (!rangeToken.match(c4) && !rangeToken.match(Character.toLowerCase(c2))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n9)) {
                            return -1;
                        }
                        n2 = n5;
                    }
                    op = op.next;
                    continue block32;
                }
                case 5: {
                    int n5;
                    switch (op.getData()) {
                        case 94: {
                            if (!(RegularExpression.isSet(n4, 8) ? n2 != regularExpression$Context.start && (n2 <= regularExpression$Context.start || !RegularExpression.isEOLChar(characterIterator.setIndex(n2 - 1))) : n2 != regularExpression$Context.start)) break;
                            return -1;
                        }
                        case 64: {
                            if (n2 == regularExpression$Context.start || n2 > regularExpression$Context.start && RegularExpression.isEOLChar(characterIterator.setIndex(n2 - 1))) break;
                            return -1;
                        }
                        case 36: {
                            if (!(RegularExpression.isSet(n4, 8) ? n2 != regularExpression$Context.limit && (n2 >= regularExpression$Context.limit || !RegularExpression.isEOLChar(characterIterator.setIndex(n2))) : !(n2 == regularExpression$Context.limit || n2 + 1 == regularExpression$Context.limit && RegularExpression.isEOLChar(characterIterator.setIndex(n2)) || n2 + 2 == regularExpression$Context.limit && characterIterator.setIndex(n2) == '\r' && characterIterator.setIndex(n2 + 1) == '\n'))) break;
                            return -1;
                        }
                        case 65: {
                            if (n2 == regularExpression$Context.start) break;
                            return -1;
                        }
                        case 90: {
                            if (n2 == regularExpression$Context.limit || n2 + 1 == regularExpression$Context.limit && RegularExpression.isEOLChar(characterIterator.setIndex(n2)) || n2 + 2 == regularExpression$Context.limit && characterIterator.setIndex(n2) == '\r' && characterIterator.setIndex(n2 + 1) == '\n') break;
                            return -1;
                        }
                        case 122: {
                            if (n2 == regularExpression$Context.limit) break;
                            return -1;
                        }
                        case 98: {
                            if (regularExpression$Context.length == 0) {
                                return -1;
                            }
                            int n10 = RegularExpression.getWordType(characterIterator, regularExpression$Context.start, regularExpression$Context.limit, n2, n4);
                            if (n10 == 0) {
                                return -1;
                            }
                            int n11 = RegularExpression.getPreviousWordType(characterIterator, regularExpression$Context.start, regularExpression$Context.limit, n2, n4);
                            if (n10 != n11) break;
                            return -1;
                        }
                        case 66: {
                            int n12;
                            if ((regularExpression$Context.length == 0 ? 1 : (n5 = (n12 = RegularExpression.getWordType(characterIterator, regularExpression$Context.start, regularExpression$Context.limit, n2, n4)) == 0 || n12 == RegularExpression.getPreviousWordType(characterIterator, regularExpression$Context.start, regularExpression$Context.limit, n2, n4) ? 1 : 0)) != 0) break;
                            return -1;
                        }
                        case 60: {
                            if (regularExpression$Context.length == 0 || n2 == regularExpression$Context.limit) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(characterIterator, regularExpression$Context.start, regularExpression$Context.limit, n2, n4) == 1 && RegularExpression.getPreviousWordType(characterIterator, regularExpression$Context.start, regularExpression$Context.limit, n2, n4) == 2) break;
                            return -1;
                        }
                        case 62: {
                            if (regularExpression$Context.length == 0 || n2 == regularExpression$Context.start) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(characterIterator, regularExpression$Context.start, regularExpression$Context.limit, n2, n4) == 2 && RegularExpression.getPreviousWordType(characterIterator, regularExpression$Context.start, regularExpression$Context.limit, n2, n4) == 1) break;
                            return -1;
                        }
                    }
                    op = op.next;
                    continue block32;
                }
                case 16: {
                    int n13 = op.getData();
                    if (n13 <= 0 || n13 >= this.nofparen) {
                        throw new RuntimeException("Internal Error: Reference number must be more than zero: " + n13);
                    }
                    if (regularExpression$Context.match.getBeginning(n13) < 0 || regularExpression$Context.match.getEnd(n13) < 0) {
                        return -1;
                    }
                    int n14 = regularExpression$Context.match.getBeginning(n13);
                    char c2 = regularExpression$Context.match.getEnd(n13) - n14;
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n3 > 0) {
                            if (!RegularExpression.regionMatches(characterIterator, n2, regularExpression$Context.limit, n14, (int)c2)) {
                                return -1;
                            }
                            n2 += c2;
                        } else {
                            if (!RegularExpression.regionMatches(characterIterator, n2 - c2, regularExpression$Context.limit, n14, (int)c2)) {
                                return -1;
                            }
                            n2 -= c2;
                        }
                    } else if (n3 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n2, regularExpression$Context.limit, n14, (int)c2)) {
                            return -1;
                        }
                        n2 += c2;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n2 - c2, regularExpression$Context.limit, n14, (int)c2)) {
                            return -1;
                        }
                        n2 -= c2;
                    }
                    op = op.next;
                    continue block32;
                }
                case 6: {
                    String string = op.getString();
                    int n15 = string.length();
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n3 > 0) {
                            if (!RegularExpression.regionMatches(characterIterator, n2, regularExpression$Context.limit, string, n15)) {
                                return -1;
                            }
                            n2 += n15;
                        } else {
                            if (!RegularExpression.regionMatches(characterIterator, n2 - n15, regularExpression$Context.limit, string, n15)) {
                                return -1;
                            }
                            n2 -= n15;
                        }
                    } else if (n3 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n2, regularExpression$Context.limit, string, n15)) {
                            return -1;
                        }
                        n2 += n15;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n2 - n15, regularExpression$Context.limit, string, n15)) {
                            return -1;
                        }
                        n2 -= n15;
                    }
                    op = op.next;
                    continue block32;
                }
                case 7: {
                    int n16 = op.getData();
                    if (n16 >= 0) {
                        int n17 = regularExpression$Context.offsets[n16];
                        if (n17 < 0 || n17 != n2) {
                            regularExpression$Context.offsets[n16] = n2;
                        } else {
                            regularExpression$Context.offsets[n16] = -1;
                            op = op.next;
                            continue block32;
                        }
                    }
                    int n18 = this.matchCharacterIterator(regularExpression$Context, op.getChild(), n2, n3, n4);
                    if (n16 >= 0) {
                        regularExpression$Context.offsets[n16] = -1;
                    }
                    if (n18 >= 0) {
                        return n18;
                    }
                    op = op.next;
                    continue block32;
                }
                case 9: {
                    int n19 = this.matchCharacterIterator(regularExpression$Context, op.getChild(), n2, n3, n4);
                    if (n19 >= 0) {
                        return n19;
                    }
                    op = op.next;
                    continue block32;
                }
                case 8: 
                case 10: {
                    int n20 = this.matchCharacterIterator(regularExpression$Context, op.next, n2, n3, n4);
                    if (n20 >= 0) {
                        return n20;
                    }
                    op = op.getChild();
                    continue block32;
                }
                case 11: {
                    for (int i2 = 0; i2 < op.size(); ++i2) {
                        int n21 = this.matchCharacterIterator(regularExpression$Context, op.elementAt(i2), n2, n3, n4);
                        if (n21 < 0) continue;
                        return n21;
                    }
                    return -1;
                }
                case 15: {
                    int n22 = op.getData();
                    if (regularExpression$Context.match != null && n22 > 0) {
                        int n23 = regularExpression$Context.match.getBeginning(n22);
                        regularExpression$Context.match.setBeginning(n22, n2);
                        int n5 = this.matchCharacterIterator(regularExpression$Context, op.next, n2, n3, n4);
                        if (n5 < 0) {
                            regularExpression$Context.match.setBeginning(n22, n23);
                        }
                        return n5;
                    }
                    if (regularExpression$Context.match != null && n22 < 0) {
                        int n24 = -n22;
                        int n6 = regularExpression$Context.match.getEnd(n24);
                        regularExpression$Context.match.setEnd(n24, n2);
                        int n25 = this.matchCharacterIterator(regularExpression$Context, op.next, n2, n3, n4);
                        if (n25 < 0) {
                            regularExpression$Context.match.setEnd(n24, n6);
                        }
                        return n25;
                    }
                    op = op.next;
                    continue block32;
                }
                case 20: {
                    if (0 > this.matchCharacterIterator(regularExpression$Context, op.getChild(), n2, 1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 21: {
                    if (0 <= this.matchCharacterIterator(regularExpression$Context, op.getChild(), n2, 1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 22: {
                    if (0 > this.matchCharacterIterator(regularExpression$Context, op.getChild(), n2, -1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 23: {
                    if (0 <= this.matchCharacterIterator(regularExpression$Context, op.getChild(), n2, -1, n4)) {
                        return -1;
                    }
                    op = op.next;
                    continue block32;
                }
                case 24: {
                    int n26 = this.matchCharacterIterator(regularExpression$Context, op.getChild(), n2, n3, n4);
                    if (n26 < 0) {
                        return n26;
                    }
                    n2 = n26;
                    op = op.next;
                    continue block32;
                }
                case 25: {
                    int n27 = n4 | op.getData();
                    char c2 = this.matchCharacterIterator(regularExpression$Context, op.getChild(), n2, n3, n27 &= ~op.getData2());
                    if (c2 < '\u0000') {
                        return c2;
                    }
                    n2 = c2;
                    op = op.next;
                    continue block32;
                }
                case 26: {
                    char c2;
                    Op$ConditionOp op$ConditionOp = (Op$ConditionOp)op;
                    if (op$ConditionOp.refNumber > 0) {
                        if (op$ConditionOp.refNumber >= this.nofparen) {
                            throw new RuntimeException("Internal Error: Reference number must be more than zero: " + op$ConditionOp.refNumber);
                        }
                        c2 = regularExpression$Context.match.getBeginning(op$ConditionOp.refNumber) >= 0 && regularExpression$Context.match.getEnd(op$ConditionOp.refNumber) >= 0 ? (char)'\u0001' : '\u0000';
                    } else {
                        char c5 = c2 = 0 <= this.matchCharacterIterator(regularExpression$Context, op$ConditionOp.condition, n2, n3, n4) ? (char)'\u0001' : '\u0000';
                    }
                    if (c2 != '\u0000') {
                        op = op$ConditionOp.yes;
                        continue block32;
                    }
                    if (op$ConditionOp.no != null) {
                        op = op$ConditionOp.no;
                        continue block32;
                    }
                    op = op$ConditionOp.next;
                    continue block32;
                }
            }
            break;
        }
        throw new RuntimeException("Unknown operation type: " + op.type);
    }

    private static final int getPreviousWordType(CharacterIterator characterIterator, int n2, int n3, int n4, int n5) {
        int n6 = RegularExpression.getWordType(characterIterator, n2, n3, --n4, n5);
        while (n6 == 0) {
            n6 = RegularExpression.getWordType(characterIterator, n2, n3, --n4, n5);
        }
        return n6;
    }

    private static final int getWordType(CharacterIterator characterIterator, int n2, int n3, int n4, int n5) {
        if (n4 < n2 || n4 >= n3) {
            return 2;
        }
        return RegularExpression.getWordType0(characterIterator.setIndex(n4), n5);
    }

    private static final boolean regionMatches(CharacterIterator characterIterator, int n2, int n3, String string, int n4) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n4) {
            return false;
        }
        n3 = 0;
        while (n4-- > 0) {
            if (characterIterator.setIndex(n2++) == string.charAt(n3++)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatches(CharacterIterator characterIterator, int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n5) {
            return false;
        }
        n3 = n4;
        while (n5-- > 0) {
            if (characterIterator.setIndex(n2++) == characterIterator.setIndex(n3++)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(CharacterIterator characterIterator, int n2, int n3, String string, int n4) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n4) {
            return false;
        }
        n3 = 0;
        while (n4-- > 0) {
            char c2;
            char c3;
            if ((c3 = characterIterator.setIndex(n2++)) == (c2 = string.charAt(n3++)) || (c3 = Character.toUpperCase(c3)) == (c2 = Character.toUpperCase(c2)) || Character.toLowerCase(c3) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(CharacterIterator characterIterator, int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n5) {
            return false;
        }
        n3 = n4;
        while (n5-- > 0) {
            char c2;
            if ((n4 = (int)characterIterator.setIndex(n2++)) == (c2 = characterIterator.setIndex(n3++)) || (n4 = (int)Character.toUpperCase((char)n4)) == (c2 = Character.toUpperCase(c2)) || Character.toLowerCase((char)n4) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    void prepare() {
        Object object;
        int n2;
        RegularExpression regularExpression = this;
        regularExpression.compile(regularExpression.tokentree);
        this.minlength = this.tokentree.getMinLength();
        this.firstChar = null;
        if (!RegularExpression.isSet(this.options, 128) && !RegularExpression.isSet(this.options, 512) && (n2 = this.tokentree.analyzeFirstCharacter((RangeToken)(object = Token.createRange()), this.options)) == 1) {
            ((RangeToken)object).compactRanges();
            this.firstChar = object;
        }
        if (this.operations != null && (this.operations.type == 6 || this.operations.type == 1) && this.operations.next == null) {
            this.fixedStringOnly = true;
            if (this.operations.type == 6) {
                this.fixedString = this.operations.getString();
            } else if (this.operations.getData() >= 65536) {
                this.fixedString = REUtil.decomposeToSurrogates(this.operations.getData());
            } else {
                char[] cArray = new char[1];
                object = cArray;
                cArray[0] = (char)this.operations.getData();
                this.fixedString = new String((char[])object);
            }
            this.fixedStringOptions = this.options;
            this.fixedStringTable = new BMPattern(this.fixedString, 256, RegularExpression.isSet(this.fixedStringOptions, 2));
            return;
        }
        if (!RegularExpression.isSet(this.options, 256) && !RegularExpression.isSet(this.options, 512)) {
            object = new Token$FixedStringContainer();
            this.tokentree.findFixedString((Token$FixedStringContainer)object, this.options);
            this.fixedString = ((Token$FixedStringContainer)object).token == null ? null : ((Token$FixedStringContainer)object).token.getString();
            this.fixedStringOptions = ((Token$FixedStringContainer)object).options;
            if (this.fixedString != null && this.fixedString.length() < 2) {
                this.fixedString = null;
            }
            if (this.fixedString != null) {
                this.fixedStringTable = new BMPattern(this.fixedString, 256, RegularExpression.isSet(this.fixedStringOptions, 2));
            }
        }
    }

    private static final boolean isSet(int n2, int n3) {
        return (n2 & n3) == n3;
    }

    public RegularExpression(String string) {
        this.setPattern(string, null);
    }

    public RegularExpression(String string, String string2) {
        this.setPattern(string, string2);
    }

    RegularExpression(String string, Token token, int n2, boolean bl, int n3) {
        this.regex = string;
        this.tokentree = token;
        this.nofparen = n2;
        this.options = n3;
        this.hasBackReferences = bl;
    }

    public void setPattern(String string) {
        this.setPattern(string, this.options);
    }

    private void setPattern(String object, int n2) {
        this.regex = object;
        this.options = n2;
        object = RegularExpression.isSet(this.options, 512) ? new ParserForXMLSchema() : new RegexParser();
        this.tokentree = ((RegexParser)object).parse(this.regex, this.options);
        this.nofparen = ((RegexParser)object).parennumber;
        this.hasBackReferences = ((RegexParser)object).hasBackReferences;
        this.operations = null;
        this.context = null;
    }

    public void setPattern(String string, String string2) {
        this.setPattern(string, REUtil.parseOptions(string2));
    }

    public String getPattern() {
        return this.regex;
    }

    public String toString() {
        return this.tokentree.toString(this.options);
    }

    public String getOptions() {
        return REUtil.createOptionString(this.options);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RegularExpression)) {
            return false;
        }
        object = (RegularExpression)object;
        return this.regex.equals(((RegularExpression)object).regex) && this.options == ((RegularExpression)object).options;
    }

    boolean equals(String string, int n2) {
        return this.regex.equals(string) && this.options == n2;
    }

    public int hashCode() {
        return (this.regex + "/" + this.getOptions()).hashCode();
    }

    public int getNumberOfGroups() {
        return this.nofparen;
    }

    private static final int getWordType0(char c2, int n2) {
        if (!RegularExpression.isSet(n2, 64)) {
            if (RegularExpression.isSet(n2, 32)) {
                if (Token.getRange("IsWord", true).match(c2)) {
                    return 1;
                }
                return 2;
            }
            if (RegularExpression.isWordChar(c2)) {
                return 1;
            }
            return 2;
        }
        switch (Character.getType(c2)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return 1;
            }
            case 6: 
            case 7: 
            case 16: {
                return 0;
            }
            case 15: {
                switch (c2) {
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': {
                        return 2;
                    }
                }
                return 0;
            }
        }
        return 2;
    }

    private static final boolean isEOLChar(int n2) {
        return n2 == 10 || n2 == 13 || n2 == 8232 || n2 == 8233;
    }

    private static final boolean isWordChar(int n2) {
        if (n2 == 95) {
            return true;
        }
        if (n2 < 48) {
            return false;
        }
        if (n2 > 122) {
            return false;
        }
        if (n2 <= 57) {
            return true;
        }
        if (n2 < 65) {
            return false;
        }
        if (n2 <= 90) {
            return true;
        }
        return n2 >= 97;
    }

    private static final boolean matchIgnoreCase(int n2, int n3) {
        if (n2 == n3) {
            return true;
        }
        if (n2 > 65535 || n3 > 65535) {
            return false;
        }
        if ((n2 = (int)Character.toUpperCase((char)n2)) == (n3 = (int)Character.toUpperCase((char)n3))) {
            return true;
        }
        return Character.toLowerCase((char)n2) == Character.toLowerCase((char)n3);
    }
}

