/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.BuiltinAtomicType;
import com.sun.msv.datatype.xsd.Discrete;
import com.sun.msv.datatype.xsd.SimpleURType;
import com.sun.msv.datatype.xsd.UnicodeUtil;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.regex.RegExp;
import com.sun.msv.datatype.xsd.regex.RegExpFactory;
import java.text.ParseException;
import org.relaxng.datatype.ValidationContext;

public class AnyURIType
extends BuiltinAtomicType
implements Discrete {
    public static final AnyURIType theInstance = new AnyURIType();
    private static final boolean[] isUric = AnyURIType.createUricMap();
    static final RegExp regexp = AnyURIType.createRegExp();
    private static final long serialVersionUID = 1L;

    private AnyURIType() {
        super("anyURI");
    }

    protected boolean checkFormat(String string, ValidationContext validationContext) {
        return regexp.matches(AnyURIType.escape(string));
    }

    private static void appendHex(StringBuffer stringBuffer, int n2) {
        if (n2 < 10) {
            stringBuffer.append((char)(n2 + 48));
            return;
        }
        stringBuffer.append((char)(n2 - 10 + 65));
    }

    private static void appendByte(StringBuffer stringBuffer, int n2) {
        stringBuffer.append('%');
        AnyURIType.appendHex(stringBuffer, n2 / 16);
        AnyURIType.appendHex(stringBuffer, n2 % 16);
    }

    private static void appendEscaped(StringBuffer stringBuffer, char c2) {
        if (c2 < '\u007f') {
            AnyURIType.appendByte(stringBuffer, c2);
            return;
        }
        if (c2 < '\u07ff') {
            AnyURIType.appendByte(stringBuffer, 192 + (c2 >> 6));
            AnyURIType.appendByte(stringBuffer, 128 + c2 % 64);
            return;
        }
        if (c2 < '\uffff') {
            AnyURIType.appendByte(stringBuffer, 224 + (c2 >> 12));
            AnyURIType.appendByte(stringBuffer, 128 + (c2 >> 6) % 64);
            AnyURIType.appendByte(stringBuffer, 128 + c2 % 64);
        }
    }

    private static void appendEscaped(StringBuffer stringBuffer, char c2, char c3) {
        c2 = (char)(((c2 & 0x3FF) << 10) + (c3 & 0x3FF));
        AnyURIType.appendByte(stringBuffer, 240 + (c2 >> 18));
        AnyURIType.appendByte(stringBuffer, 128 + (c2 >> 12) % 64);
        AnyURIType.appendByte(stringBuffer, 128 + (c2 >> 6) % 64);
        AnyURIType.appendByte(stringBuffer, 128 + c2 % 64);
    }

    private static boolean[] createUricMap() {
        int n2;
        boolean[] blArray = new boolean[128];
        for (n2 = 97; n2 <= 122; ++n2) {
            blArray[n2] = true;
        }
        for (n2 = 65; n2 <= 90; ++n2) {
            blArray[n2] = true;
        }
        for (n2 = 48; n2 <= 57; ++n2) {
            blArray[n2] = true;
        }
        char[] cArray = new char[]{'-', '_', '.', '!', '~', '*', '\'', '(', ')', '#', '%', '[', ']'};
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            blArray[cArray[i2]] = true;
        }
        char[] cArray2 = new char[]{';', '/', '?', ':', '@', '&', '=', '+', '$', ','};
        for (int i3 = 0; i3 < cArray2.length; ++i3) {
            blArray[cArray2[i3]] = true;
        }
        return blArray;
    }

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '\u0080' && isUric[c2]) {
                stringBuffer.append(c2);
                continue;
            }
            if ('\ud800' <= c2 && c2 < '\udc00') {
                AnyURIType.appendEscaped(stringBuffer, c2, string.charAt(++i2));
                continue;
            }
            AnyURIType.appendEscaped(stringBuffer, c2);
        }
        return new String(stringBuffer);
    }

    static RegExp createRegExp() {
        String string = "[a-zA-Z]";
        String string2 = "[0-9a-zA-Z]";
        String string3 = "[0-9a-fA-F]";
        String string4 = "%" + string3 + "{2}";
        String string5 = "[\\-_\\.!~\\*'\\(\\)]";
        string5 = "(" + string2 + "|" + string5 + ")";
        String string6 = "[;/\\?:@&=\\+$,\\[\\]]";
        string6 = "(" + string6 + "|" + string5 + "|" + string4 + ")";
        String string7 = string6 + "*";
        String string8 = string6 + "*";
        String string9 = "(" + string5 + "|" + string4 + "|[:@&=\\+$,])";
        string9 = string9 + "*";
        string9 = "(" + string9 + "(;" + string9 + ")*)";
        string9 = "(" + string9 + "(/" + string9 + ")*)";
        String string10 = "[0-9]*";
        String string11 = "[0-9]{1,3}";
        string11 = string11 + "\\." + string11 + "\\." + string11 + "\\." + string11;
        string3 = string3 + "{1,4}";
        string3 = string3 + "(:" + string3 + ")*";
        string3 = "((" + string3 + "(::(" + string3 + ")?)?)|(::(" + string3 + ")?))";
        string3 = "((" + string3 + "(:" + string11 + ")?)|(::" + string11 + "))";
        string3 = "\\[" + string3 + "\\]";
        String string12 = string2 + "([0-9A-Za-z\\-]*" + string2 + ")?";
        string2 = string + "([0-9A-Za-z\\-]*" + string2 + ")?";
        string2 = "(" + string12 + "\\.)*" + string2 + "(\\.)?";
        string2 = "((" + string2 + ")|(" + string11 + ")|(" + string3 + "))";
        string2 = string2 + "(:" + string10 + ")?";
        string3 = "(" + string5 + "|" + string4 + "|[;:&=\\+$,])*";
        string2 = "((" + string3 + "@)?" + string2 + ")?";
        string3 = "(" + string5 + "|" + string4 + "|[$,;:@&=\\+])+";
        string2 = "((" + string2 + ")|(" + string3 + "))";
        string = string + "[A-Za-z0-9\\+\\-\\.]*";
        string3 = "(" + string5 + "|" + string4 + "|[;@&=\\+$,])+";
        string9 = "/" + string9;
        string3 = string3 + "(" + string9 + ")?";
        string2 = "//" + string2 + "(" + string9 + ")?";
        string4 = "(" + string5 + "|" + string4 + "|[;\\?:@&=\\+$,])";
        string4 = string4 + "(" + string6 + ")*";
        string5 = "((" + string2 + ")|(" + string9 + "))(\\?" + string8 + ")?";
        string2 = "((" + string2 + ")|(" + string9 + ")|(" + string3 + "))(\\?" + string8 + ")?";
        string = string + ":((" + string5 + ")|(" + string4 + "))";
        string = "(" + string + "|" + string2 + ")?(#" + string7 + ")?";
        try {
            return RegExpFactory.createFactory().compile(string);
        }
        catch (ParseException parseException) {
            throw new Error();
        }
    }

    public Object _createValue(String string, ValidationContext validationContext) {
        if (!regexp.matches(AnyURIType.escape(string))) {
            return null;
        }
        return string;
    }

    public String convertToLexicalValue(Object object, SerializationContext serializationContext) {
        if (object instanceof String) {
            return (String)object;
        }
        throw new IllegalArgumentException();
    }

    public final int isFacetApplicable(String string) {
        if (string.equals("length") || string.equals("minLength") || string.equals("maxLength") || string.equals("pattern") || string.equals("whiteSpace") || string.equals("enumeration")) {
            return 0;
        }
        return -2;
    }

    public final int countLength(Object object) {
        return UnicodeUtil.countLength((String)object);
    }

    public Class getJavaObjectType() {
        return String.class;
    }

    public XSDatatype getBaseType() {
        return SimpleURType.theInstance;
    }
}

