/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.BinaryBaseType;
import com.sun.msv.datatype.xsd.BinaryValueType;
import com.sun.msv.datatype.xsd.ConcreteType;
import org.relaxng.datatype.ValidationContext;

public class Base64BinaryType
extends BinaryBaseType {
    public static final Base64BinaryType theInstance = new Base64BinaryType();
    private static final byte[] decodeMap = Base64BinaryType.initDecodeMap();
    private static final byte PADDING = 127;
    private static final char[] encodeMap = Base64BinaryType.initEncodeMap();
    private static final long serialVersionUID = 1L;

    private Base64BinaryType() {
        super("base64Binary");
    }

    private static byte[] initDecodeMap() {
        int n2;
        byte[] byArray = new byte[256];
        for (n2 = 0; n2 < 256; ++n2) {
            byArray[n2] = -1;
        }
        n2 = 65;
        while (n2 <= 90) {
            int n3 = n2++;
            byArray[n3] = (byte)(n3 - 65);
        }
        n2 = 97;
        while (n2 <= 122) {
            int n4 = n2++;
            byArray[n4] = (byte)(n4 - 97 + 26);
        }
        n2 = 48;
        while (n2 <= 57) {
            int n5 = n2++;
            byArray[n5] = (byte)(n5 - 48 + 52);
        }
        byArray[43] = 62;
        byArray[47] = 63;
        byArray[61] = 127;
        return byArray;
    }

    public Object _createValue(String object, ValidationContext validationContext) {
        byte[] byArray = Base64BinaryType.load((String)object);
        object = byArray;
        if (byArray == null) {
            return null;
        }
        return new BinaryValueType((byte[])object);
    }

    public static byte[] load(String object) {
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n2 = Base64BinaryType.calcLength(cArray);
        if (n2 == -1) {
            return null;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = ((Object)object).length;
        byte[] byArray2 = new byte[4];
        int n5 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            byte by = decodeMap[object[i2]];
            if (by != -1) {
                byArray2[n5++] = by;
            }
            if (n5 != 4) continue;
            byArray[n3++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
            if (byArray2[2] != 127) {
                byArray[n3++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
            }
            if (byArray2[3] != 127) {
                byArray[n3++] = (byte)(byArray2[2] << 6 | byArray2[3]);
            }
            n5 = 0;
        }
        if (n5 != 0) {
            throw new IllegalStateException();
        }
        return byArray;
    }

    protected boolean checkFormat(String string, ValidationContext validationContext) {
        return Base64BinaryType.calcLength(string.toCharArray()) != -1;
    }

    private static int calcLength(char[] cArray) {
        int n2;
        int n3 = cArray.length;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3 && cArray[n2] != '='; ++n2) {
            if (cArray[n2] >= '\u0100') {
                return -1;
            }
            if (decodeMap[cArray[n2]] == -1) continue;
            ++n4;
        }
        while (n2 < n3) {
            if (cArray[n2] == '=') {
                ++n5;
            } else {
                if (cArray[n2] >= '\u0100') {
                    return -1;
                }
                if (decodeMap[cArray[n2]] != -1) {
                    return -1;
                }
            }
            ++n2;
        }
        if (n5 > 2) {
            return -1;
        }
        if ((n4 + n5) % 4 != 0) {
            return -1;
        }
        return (n4 + n5) / 4 * 3 - n5;
    }

    private static char[] initEncodeMap() {
        int n2;
        char[] cArray = new char[64];
        for (n2 = 0; n2 < 26; ++n2) {
            cArray[n2] = (char)(n2 + 65);
        }
        for (n2 = 26; n2 < 52; ++n2) {
            cArray[n2] = (char)(97 + (n2 - 26));
        }
        for (n2 = 52; n2 < 62; ++n2) {
            cArray[n2] = (char)(48 + (n2 - 52));
        }
        cArray[62] = 43;
        cArray[63] = 47;
        return cArray;
    }

    protected static char encode(int n2) {
        return encodeMap[n2 & 0x3F];
    }

    public String serializeJavaObject(Object object, SerializationContext serializationContext) {
        if (!(object instanceof byte[])) {
            throw new IllegalArgumentException();
        }
        return Base64BinaryType.save((byte[])object);
    }

    public static String save(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer((byArray.length << 2) / 3);
        block4: for (int i2 = 0; i2 < byArray.length; i2 += 3) {
            switch (byArray.length - i2) {
                case 1: {
                    stringBuffer.append(Base64BinaryType.encode(byArray[i2] >> 2));
                    stringBuffer.append(Base64BinaryType.encode((byArray[i2] & 3) << 4));
                    stringBuffer.append("==");
                    continue block4;
                }
                case 2: {
                    stringBuffer.append(Base64BinaryType.encode(byArray[i2] >> 2));
                    stringBuffer.append(Base64BinaryType.encode((byArray[i2] & 3) << 4 | byArray[i2 + 1] >> 4 & 0xF));
                    stringBuffer.append(Base64BinaryType.encode((byArray[i2 + 1] & 0xF) << 2));
                    stringBuffer.append("=");
                    continue block4;
                }
                default: {
                    stringBuffer.append(Base64BinaryType.encode(byArray[i2] >> 2));
                    stringBuffer.append(Base64BinaryType.encode((byArray[i2] & 3) << 4 | byArray[i2 + 1] >> 4 & 0xF));
                    stringBuffer.append(Base64BinaryType.encode((byArray[i2 + 1] & 0xF) << 2 | byArray[i2 + 2] >> 6 & 3));
                    stringBuffer.append(Base64BinaryType.encode(byArray[i2 + 2] & 0x3F));
                }
            }
        }
        return stringBuffer.toString();
    }

    public String convertToLexicalValue(Object object, SerializationContext serializationContext) {
        if (!(object instanceof BinaryValueType)) {
            throw new IllegalArgumentException();
        }
        return ((ConcreteType)this).serializeJavaObject(((BinaryValueType)object).rawData, serializationContext);
    }
}

