/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.BuiltinAtomicType;
import com.sun.msv.datatype.xsd.SimpleURType;
import com.sun.msv.datatype.xsd.XSDatatype;
import org.relaxng.datatype.ValidationContext;

public class BooleanType
extends BuiltinAtomicType {
    public static final BooleanType theInstance = new BooleanType();
    private static final long serialVersionUID = 1L;

    private BooleanType() {
        super("boolean");
    }

    public final XSDatatype getBaseType() {
        return SimpleURType.theInstance;
    }

    protected boolean checkFormat(String string, ValidationContext validationContext) {
        return "true".equals(string) || "false".equals(string) || "0".equals(string) || "1".equals(string);
    }

    public Object _createValue(String string, ValidationContext validationContext) {
        return BooleanType.load(string);
    }

    public static Boolean load(String string) {
        if (string.equals("true")) {
            return Boolean.TRUE;
        }
        if (string.equals("1")) {
            return Boolean.TRUE;
        }
        if (string.equals("0")) {
            return Boolean.FALSE;
        }
        if (string.equals("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    public String convertToLexicalValue(Object object, SerializationContext serializationContext) {
        if (object instanceof Boolean) {
            return BooleanType.save((Boolean)object);
        }
        throw new IllegalArgumentException();
    }

    public static String save(Boolean bl) {
        if (bl.booleanValue()) {
            return "true";
        }
        return "false";
    }

    public int isFacetApplicable(String string) {
        if (string.equals("pattern") || string.equals("enumeration") || string.equals("whiteSpace")) {
            return 0;
        }
        return -2;
    }

    public Class getJavaObjectType() {
        return Boolean.class;
    }
}

