/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.xsd.AnyURIType;
import com.sun.msv.datatype.xsd.Base64BinaryType;
import com.sun.msv.datatype.xsd.BooleanType;
import com.sun.msv.datatype.xsd.ByteType;
import com.sun.msv.datatype.xsd.DatatypeFactory$1;
import com.sun.msv.datatype.xsd.DateTimeType;
import com.sun.msv.datatype.xsd.DateType;
import com.sun.msv.datatype.xsd.DoubleType;
import com.sun.msv.datatype.xsd.DurationType;
import com.sun.msv.datatype.xsd.EntityType;
import com.sun.msv.datatype.xsd.ErrorType;
import com.sun.msv.datatype.xsd.FloatType;
import com.sun.msv.datatype.xsd.GDayType;
import com.sun.msv.datatype.xsd.GMonthDayType;
import com.sun.msv.datatype.xsd.GMonthType;
import com.sun.msv.datatype.xsd.GYearMonthType;
import com.sun.msv.datatype.xsd.GYearType;
import com.sun.msv.datatype.xsd.HexBinaryType;
import com.sun.msv.datatype.xsd.IDREFType;
import com.sun.msv.datatype.xsd.IDType;
import com.sun.msv.datatype.xsd.IntType;
import com.sun.msv.datatype.xsd.IntegerType;
import com.sun.msv.datatype.xsd.LanguageType;
import com.sun.msv.datatype.xsd.ListType;
import com.sun.msv.datatype.xsd.LongType;
import com.sun.msv.datatype.xsd.NameType;
import com.sun.msv.datatype.xsd.NcnameType;
import com.sun.msv.datatype.xsd.NegativeIntegerType;
import com.sun.msv.datatype.xsd.NmtokenType;
import com.sun.msv.datatype.xsd.NonNegativeIntegerType;
import com.sun.msv.datatype.xsd.NonPositiveIntegerType;
import com.sun.msv.datatype.xsd.NormalizedStringType;
import com.sun.msv.datatype.xsd.NumberType;
import com.sun.msv.datatype.xsd.PositiveIntegerType;
import com.sun.msv.datatype.xsd.QnameType;
import com.sun.msv.datatype.xsd.ShortType;
import com.sun.msv.datatype.xsd.SimpleURType;
import com.sun.msv.datatype.xsd.StringType;
import com.sun.msv.datatype.xsd.TimeType;
import com.sun.msv.datatype.xsd.TokenType;
import com.sun.msv.datatype.xsd.TypeIncubator;
import com.sun.msv.datatype.xsd.UnionType;
import com.sun.msv.datatype.xsd.UnsignedByteType;
import com.sun.msv.datatype.xsd.UnsignedIntType;
import com.sun.msv.datatype.xsd.UnsignedLongType;
import com.sun.msv.datatype.xsd.UnsignedShortType;
import com.sun.msv.datatype.xsd.WhiteSpaceProcessor;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.XSDatatypeImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.relaxng.datatype.DatatypeException;

public class DatatypeFactory {
    private static final Map builtinType = DatatypeFactory.createInitialBuiltinTypesMap();

    private DatatypeFactory() {
    }

    public static XSDatatype deriveByList(String string, String string2, XSDatatype xSDatatype) {
        if (xSDatatype instanceof ErrorType) {
            return xSDatatype;
        }
        return new ListType(string, string2, (XSDatatypeImpl)xSDatatype);
    }

    public static XSDatatype deriveByList(String string, XSDatatype xSDatatype) {
        return DatatypeFactory.deriveByList("", string, xSDatatype);
    }

    public static XSDatatype deriveByUnion(String string, String string2, XSDatatype[] xSDatatypeArray) {
        for (int i2 = 0; i2 < xSDatatypeArray.length; ++i2) {
            if (!(xSDatatypeArray[i2] instanceof ErrorType)) continue;
            return xSDatatypeArray[i2];
        }
        return new UnionType(string, string2, xSDatatypeArray);
    }

    public static XSDatatype deriveByUnion(String string, XSDatatype[] xSDatatypeArray) {
        return DatatypeFactory.deriveByUnion("", string, xSDatatypeArray);
    }

    public static XSDatatype deriveByUnion(String string, Collection collection) {
        return DatatypeFactory.deriveByUnion("", string, collection);
    }

    public static XSDatatype deriveByUnion(String string, String string2, Collection object) {
        XSDatatype[] xSDatatypeArray = new XSDatatypeImpl[object.size()];
        object = object.iterator();
        while (object.hasNext()) {
            for (int i2 = 0; i2 < xSDatatypeArray.length; ++i2) {
                xSDatatypeArray[i2] = (XSDatatypeImpl)object.next();
            }
        }
        return DatatypeFactory.deriveByUnion(string, string2, xSDatatypeArray);
    }

    private static void add(Map map, XSDatatypeImpl xSDatatypeImpl) {
        String string = xSDatatypeImpl.getName();
        if (string == null) {
            throw new IllegalArgumentException("anonymous type");
        }
        if (map.containsKey(string)) {
            throw new IllegalArgumentException("multiple definition");
        }
        map.put(string, xSDatatypeImpl);
    }

    public static synchronized XSDatatype getTypeByName(String string) {
        XSDatatype xSDatatype = (XSDatatype)builtinType.get(string);
        if (xSDatatype != null) {
            return xSDatatype;
        }
        try {
            if (string.equals("float")) {
                DatatypeFactory.add(builtinType, FloatType.theInstance);
            } else if (string.equals("double")) {
                DatatypeFactory.add(builtinType, DoubleType.theInstance);
            } else if (string.equals("duration")) {
                DatatypeFactory.add(builtinType, DurationType.theInstance);
            } else if (string.equals("dateTime")) {
                DatatypeFactory.add(builtinType, DateTimeType.theInstance);
            } else if (string.equals("time")) {
                DatatypeFactory.add(builtinType, TimeType.theInstance);
            } else if (string.equals("date")) {
                DatatypeFactory.add(builtinType, DateType.theInstance);
            } else if (string.equals("gYearMonth")) {
                DatatypeFactory.add(builtinType, GYearMonthType.theInstance);
            } else if (string.equals("gYear")) {
                DatatypeFactory.add(builtinType, GYearType.theInstance);
            } else if (string.equals("gMonthDay")) {
                DatatypeFactory.add(builtinType, GMonthDayType.theInstance);
            } else if (string.equals("gDay")) {
                DatatypeFactory.add(builtinType, GDayType.theInstance);
            } else if (string.equals("gMonth")) {
                DatatypeFactory.add(builtinType, GMonthType.theInstance);
            } else if (string.equals("hexBinary")) {
                DatatypeFactory.add(builtinType, HexBinaryType.theInstance);
            } else if (string.equals("base64Binary")) {
                DatatypeFactory.add(builtinType, Base64BinaryType.theInstance);
            } else if (string.equals("anyURI")) {
                DatatypeFactory.add(builtinType, AnyURIType.theInstance);
            } else if (string.equals("ENTITY")) {
                DatatypeFactory.add(builtinType, EntityType.theInstance);
            } else if (string.equals("language")) {
                DatatypeFactory.add(builtinType, LanguageType.theInstance);
            } else if (string.equals("ID")) {
                DatatypeFactory.add(builtinType, IDType.theInstance);
            } else if (string.equals("IDREF")) {
                DatatypeFactory.add(builtinType, IDREFType.theInstance);
            } else if (string.equals("IDREFS")) {
                DatatypeFactory.add(builtinType, DatatypeFactory.createBuiltinList("IDREFS", IDREFType.theInstance));
            } else if (string.equals("ENTITIES")) {
                DatatypeFactory.add(builtinType, DatatypeFactory.createBuiltinList("ENTITIES", EntityType.theInstance));
            } else if (string.equals("NMTOKENS")) {
                DatatypeFactory.add(builtinType, DatatypeFactory.createBuiltinList("NMTOKENS", NmtokenType.theInstance));
            } else if (string.equals("NOTATION")) {
                DatatypeFactory.add(builtinType, new StringType("NOTATION", WhiteSpaceProcessor.theCollapse, false));
            } else if (string.equals("nonPositiveInteger")) {
                DatatypeFactory.add(builtinType, NonPositiveIntegerType.theInstance);
            } else if (string.equals("unsignedLong")) {
                DatatypeFactory.add(builtinType, UnsignedLongType.theInstance);
            } else if (string.equals("unsignedInt")) {
                DatatypeFactory.add(builtinType, UnsignedIntType.theInstance);
            } else if (string.equals("unsignedShort")) {
                DatatypeFactory.add(builtinType, UnsignedShortType.theInstance);
            } else if (string.equals("unsignedByte")) {
                DatatypeFactory.add(builtinType, UnsignedByteType.theInstance);
            } else if (string.equals("anySimpleType")) {
                DatatypeFactory.add(builtinType, SimpleURType.theInstance);
            }
        }
        catch (DatatypeException datatypeException) {
            throw new Error();
        }
        xSDatatype = (XSDatatype)builtinType.get(string);
        if (xSDatatype != null) {
            return xSDatatype;
        }
        throw new DatatypeException("undefined type name:" + string);
    }

    private static XSDatatypeImpl createBuiltinList(String string, XSDatatypeImpl object) {
        object = new TypeIncubator(new ListType(null, null, (XSDatatypeImpl)object));
        ((TypeIncubator)object).addFacet("minLength", "1", false, null);
        return new DatatypeFactory$1("http://www.w3.org/2001/XMLSchema", string, ((TypeIncubator)object).derive(null, null));
    }

    private static Map createInitialBuiltinTypesMap() {
        HashMap hashMap = new HashMap();
        DatatypeFactory.add(hashMap, StringType.theInstance);
        DatatypeFactory.add(hashMap, BooleanType.theInstance);
        DatatypeFactory.add(hashMap, NumberType.theInstance);
        DatatypeFactory.add(hashMap, QnameType.theInstance);
        DatatypeFactory.add(hashMap, NormalizedStringType.theInstance);
        DatatypeFactory.add(hashMap, TokenType.theInstance);
        DatatypeFactory.add(hashMap, NmtokenType.theInstance);
        DatatypeFactory.add(hashMap, NameType.theInstance);
        DatatypeFactory.add(hashMap, NcnameType.theInstance);
        DatatypeFactory.add(hashMap, IntegerType.theInstance);
        DatatypeFactory.add(hashMap, NegativeIntegerType.theInstance);
        DatatypeFactory.add(hashMap, LongType.theInstance);
        DatatypeFactory.add(hashMap, IntType.theInstance);
        DatatypeFactory.add(hashMap, ShortType.theInstance);
        DatatypeFactory.add(hashMap, ByteType.theInstance);
        DatatypeFactory.add(hashMap, NonNegativeIntegerType.theInstance);
        DatatypeFactory.add(hashMap, PositiveIntegerType.theInstance);
        return hashMap;
    }
}

