/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.BinaryBaseType;
import com.sun.msv.datatype.xsd.BinaryValueType;
import com.sun.msv.datatype.xsd.ConcreteType;
import org.relaxng.datatype.ValidationContext;

public class HexBinaryType
extends BinaryBaseType {
    public static final HexBinaryType theInstance = new HexBinaryType();
    private static final long serialVersionUID = 1L;

    private HexBinaryType() {
        super("hexBinary");
    }

    private static int hexToBin(char c2) {
        if ('0' <= c2 && c2 <= '9') {
            return c2 - 48;
        }
        if ('A' <= c2 && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        if ('a' <= c2 && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        return -1;
    }

    public Object _createValue(String object, ValidationContext validationContext) {
        byte[] byArray = HexBinaryType.load((String)object);
        object = byArray;
        if (byArray == null) {
            return null;
        }
        return new BinaryValueType((byte[])object);
    }

    public static byte[] load(String string) {
        int n2 = string.length();
        if (n2 % 2 != 0) {
            return null;
        }
        byte[] byArray = new byte[n2 / 2];
        for (int i2 = 0; i2 < n2; i2 += 2) {
            int n3 = HexBinaryType.hexToBin(string.charAt(i2));
            int n4 = HexBinaryType.hexToBin(string.charAt(i2 + 1));
            if (n3 == -1 || n4 == -1) {
                return null;
            }
            byArray[i2 / 2] = (byte)((n3 << 4) + n4);
        }
        return byArray;
    }

    protected boolean checkFormat(String string, ValidationContext validationContext) {
        int n2 = string.length();
        if (n2 % 2 != 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (HexBinaryType.hexToBin(string.charAt(i2)) != -1) continue;
            return false;
        }
        return true;
    }

    public String serializeJavaObject(Object object, SerializationContext serializationContext) {
        if (!(object instanceof byte[])) {
            throw new IllegalArgumentException();
        }
        return HexBinaryType.save((byte[])object);
    }

    public static String save(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length << 1);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            stringBuffer.append(HexBinaryType.encode(byArray[i2] >> 4));
            stringBuffer.append(HexBinaryType.encode(byArray[i2] & 0xF));
        }
        return stringBuffer.toString();
    }

    public String convertToLexicalValue(Object object, SerializationContext serializationContext) {
        if (!(object instanceof BinaryValueType)) {
            throw new IllegalArgumentException();
        }
        return ((ConcreteType)this).serializeJavaObject(((BinaryValueType)object).rawData, serializationContext);
    }

    public static char encode(int n2) {
        if ((n2 &= 0xF) < 10) {
            return (char)(n2 + 48);
        }
        return (char)(65 + (n2 - 10));
    }
}

