/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import java.io.Serializable;
import java.math.BigInteger;

public class IntegerValueType
extends Number
implements Serializable,
Comparable {
    private final String value;
    private static final long serialVersionUID = 1L;

    private IntegerValueType(String string) {
        this.value = string;
    }

    private IntegerValueType(long l2) {
        this.value = Long.toString(l2);
    }

    public static IntegerValueType create(BigInteger bigInteger) {
        return IntegerValueType.create(bigInteger.toString());
    }

    public static IntegerValueType create(String string) {
        int n2 = 0;
        String string2 = "";
        int n3 = string.length();
        if (n3 == 0) {
            return null;
        }
        switch (string.charAt(0)) {
            case '+': {
                ++n2;
                break;
            }
            case '-': {
                string2 = string2 + '-';
                ++n2;
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                break;
            }
            default: {
                return null;
            }
        }
        if (n2 == n3) {
            return null;
        }
        while (n2 < n3 && string.charAt(n2) == '0') {
            ++n2;
        }
        if (n2 == n3) {
            return new IntegerValueType("0");
        }
        while (n2 < n3) {
            char c2;
            if ('0' <= (c2 = string.charAt(n2++)) && c2 <= '9') {
                string2 = string2 + c2;
                continue;
            }
            return null;
        }
        return new IntegerValueType(string2);
    }

    public int compareTo(Object object) {
        int n2;
        int n3;
        int n4;
        object = object instanceof IntegerValueType ? (IntegerValueType)object : new IntegerValueType(((Number)object).longValue());
        boolean bl = this.value.charAt(0) == '-';
        int n5 = n4 = ((IntegerValueType)object).value.charAt(0) == '-' ? 1 : 0;
        if (bl && n4 == 0) {
            return -1;
        }
        if (n4 != 0 && !bl) {
            return 1;
        }
        if (bl && n4 != 0) {
            n3 = 1;
            n4 = 1;
        } else {
            n3 = 0;
            n4 = 0;
        }
        int n6 = ((IntegerValueType)object).value.length() - n3;
        if (n2 > n6) {
            if (bl) {
                return -1;
            }
            return 1;
        }
        if (n2 < n6) {
            if (bl) {
                return 1;
            }
            return -1;
        }
        for (n2 = this.value.length() - n4; n2 > 0; --n2) {
            char c2;
            if ((n6 = (int)this.value.charAt(n4++)) > (c2 = ((IntegerValueType)object).value.charAt(n3++))) {
                if (bl) {
                    return -1;
                }
                return 1;
            }
            if (n6 >= c2) continue;
            if (bl) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof IntegerValueType) {
            return this.value.equals(((IntegerValueType)object).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }

    public int precision() {
        int n2 = this.value.length();
        if (this.value.charAt(0) == '-') {
            return n2 - 1;
        }
        return n2;
    }

    public boolean isNonPositive() {
        char c2 = this.value.charAt(0);
        return c2 == '-' || c2 == '0';
    }

    public boolean isPositive() {
        char c2 = this.value.charAt(0);
        return c2 != '-' && c2 != '0';
    }

    public boolean isNegative() {
        return this.value.charAt(0) == '-';
    }

    public boolean isNonNegative() {
        return this.value.charAt(0) != '-';
    }

    public BigInteger toBigInteger() {
        return new BigInteger(this.value);
    }

    public double doubleValue() {
        return this.toBigInteger().doubleValue();
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public int intValue() {
        return this.toBigInteger().intValue();
    }

    public long longValue() {
        return this.toBigInteger().longValue();
    }
}

