/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.xsd.DataTypeWithLexicalConstraintFacet;
import com.sun.msv.datatype.xsd.TypeIncubator;
import com.sun.msv.datatype.xsd.XSDatatypeImpl;
import com.sun.msv.datatype.xsd.regex.RegExp;
import com.sun.msv.datatype.xsd.regex.RegExpFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.util.Vector;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

public final class PatternFacet
extends DataTypeWithLexicalConstraintFacet {
    private transient RegExp[] exps;
    public final String[] patterns;
    private static final long serialVersionUID = 1L;

    public final RegExp[] getRegExps() {
        return this.exps;
    }

    public PatternFacet(String object, String string, XSDatatypeImpl xSDatatypeImpl, TypeIncubator typeIncubator) {
        super((String)object, string, xSDatatypeImpl, "pattern", typeIncubator.isFixed("pattern"));
        Object object2 = object = typeIncubator.getVector("pattern");
        this.patterns = ((Vector)object2).toArray(new String[((Vector)object2).size()]);
        try {
            this.compileRegExps();
            return;
        }
        catch (ParseException parseException) {
            throw new DatatypeException(PatternFacet.localize("PatternFacet.ParseError", parseException.getMessage()));
        }
    }

    private void compileRegExps() {
        this.exps = new RegExp[this.patterns.length];
        RegExpFactory regExpFactory = RegExpFactory.createFactory();
        for (int i2 = 0; i2 < this.exps.length; ++i2) {
            this.exps[i2] = regExpFactory.compile(this.patterns[i2]);
        }
    }

    protected final void diagnoseByFacet(String string, ValidationContext validationContext) {
        if (this.checkLexicalConstraint(string)) {
            return;
        }
        if (this.exps.length == 1) {
            throw new DatatypeException(-1, PatternFacet.localize("DataTypeErrorDiagnosis.Pattern.1", this.patterns[0]));
        }
        throw new DatatypeException(-1, PatternFacet.localize("DataTypeErrorDiagnosis.Pattern.Many"));
    }

    protected final boolean checkLexicalConstraint(String string) {
        PatternFacet patternFacet = this;
        synchronized (patternFacet) {
            for (int i2 = 0; i2 < this.exps.length; ++i2) {
                if (!this.exps[i2].matches(string)) continue;
                return true;
            }
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        try {
            this.compileRegExps();
            return;
        }
        catch (ParseException parseException) {
            throw new IOException(parseException.getMessage());
        }
    }
}

