/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.xsd.Comparator;
import com.sun.msv.datatype.xsd.DataTypeWithFacet;
import com.sun.msv.datatype.xsd.EnumerationFacet;
import com.sun.msv.datatype.xsd.ErrorType;
import com.sun.msv.datatype.xsd.FinalComponent;
import com.sun.msv.datatype.xsd.FractionDigitsFacet;
import com.sun.msv.datatype.xsd.LengthFacet;
import com.sun.msv.datatype.xsd.MaxExclusiveFacet;
import com.sun.msv.datatype.xsd.MaxInclusiveFacet;
import com.sun.msv.datatype.xsd.MaxLengthFacet;
import com.sun.msv.datatype.xsd.MinExclusiveFacet;
import com.sun.msv.datatype.xsd.MinInclusiveFacet;
import com.sun.msv.datatype.xsd.MinLengthFacet;
import com.sun.msv.datatype.xsd.PatternFacet;
import com.sun.msv.datatype.xsd.RangeFacet;
import com.sun.msv.datatype.xsd.TotalDigitsFacet;
import com.sun.msv.datatype.xsd.TypeIncubator$FacetInfo;
import com.sun.msv.datatype.xsd.WhiteSpaceFacet;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.XSDatatypeImpl;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

public class TypeIncubator {
    private final Map impl = new HashMap();
    private final XSDatatypeImpl baseType;
    private static final String[][] exclusiveFacetPairs = new String[][]{{"length", "minLength"}, {"length", "maxLength"}, {"maxInclusive", "maxExclusive"}, {"minInclusive", "minExclusive"}};

    public TypeIncubator(XSDatatype xSDatatype) {
        this.baseType = (XSDatatypeImpl)xSDatatype;
        if (xSDatatype == null) {
            throw new IllegalArgumentException();
        }
    }

    public void add(String string, String string2, boolean bl, ValidationContext validationContext) {
        this.addFacet(string, string2, bl, validationContext);
    }

    public void addFacet(String object, String string, boolean bl, ValidationContext object2) {
        if (this.baseType instanceof ErrorType) {
            return;
        }
        switch (this.baseType.isFacetApplicable((String)object)) {
            case 0: {
                break;
            }
            case -1: {
                return;
            }
            case -2: {
                throw new DatatypeException(XSDatatypeImpl.localize("BadTypeException.NotApplicableFacet", object));
            }
            default: {
                throw new Error();
            }
        }
        if (TypeIncubator.isValueFacet((String)object)) {
            if ((object2 = this.baseType.createValue(string, (ValidationContext)object2)) == null) {
                throw new DatatypeException(XSDatatypeImpl.localize("EnumerationFacet.InvalidValueForThisType", string, this.baseType.displayName()));
            }
        } else {
            object2 = string;
        }
        if (TypeIncubator.isRepeatable((String)object)) {
            if (this.impl.containsKey(object)) {
                object = (TypeIncubator$FacetInfo)this.impl.get(object);
            } else {
                String string2 = object;
                object = new TypeIncubator$FacetInfo(new Vector(), bl);
                this.impl.put(string2, object);
            }
            ((Vector)((TypeIncubator$FacetInfo)object).value).add(object2);
            ((TypeIncubator$FacetInfo)object).fixed |= bl;
            return;
        }
        if (this.impl.containsKey(object)) {
            throw new DatatypeException(XSDatatypeImpl.localize("BadTypeException.DuplicateFacet", object));
        }
        this.impl.put(object, new TypeIncubator$FacetInfo(object2, bl));
    }

    public XSDatatypeImpl derive(String string) {
        return this.derive("", string);
    }

    public XSDatatypeImpl derive(String object, String string) {
        if (this.baseType instanceof ErrorType) {
            return this.baseType;
        }
        if (this.baseType.isFinal(1)) {
            throw new DatatypeException(XSDatatypeImpl.localize("BadTypeException.InvalidBaseType", this.baseType.displayName()));
        }
        if (this.isEmpty()) {
            if (object == null && string == null) {
                return this.baseType;
            }
            return new FinalComponent((String)object, string, this.baseType, 0);
        }
        XSDatatypeImpl xSDatatypeImpl = this.baseType;
        for (int i2 = 0; i2 < exclusiveFacetPairs.length; ++i2) {
            if (!this.contains(exclusiveFacetPairs[i2][0]) || !this.contains(exclusiveFacetPairs[i2][1])) continue;
            throw new DatatypeException(XSDatatypeImpl.localize("XAndYAreExclusive", exclusiveFacetPairs[i2][0], exclusiveFacetPairs[i2][1]));
        }
        if (this.contains("totalDigits")) {
            xSDatatypeImpl = new TotalDigitsFacet((String)object, string, xSDatatypeImpl, this.getPositiveInteger("totalDigits"), this.isFixed("totalDigits"));
        }
        if (this.contains("fractionDigits")) {
            xSDatatypeImpl = new FractionDigitsFacet((String)object, string, xSDatatypeImpl, this.getNonNegativeInteger("fractionDigits"), this.isFixed("fractionDigits"));
        }
        if (this.contains("minInclusive")) {
            xSDatatypeImpl = new MinInclusiveFacet((String)object, string, xSDatatypeImpl, this.getFacet("minInclusive"), this.isFixed("minInclusive"));
        }
        if (this.contains("maxInclusive")) {
            xSDatatypeImpl = new MaxInclusiveFacet((String)object, string, xSDatatypeImpl, this.getFacet("maxInclusive"), this.isFixed("maxInclusive"));
        }
        if (this.contains("minExclusive")) {
            xSDatatypeImpl = new MinExclusiveFacet((String)object, string, xSDatatypeImpl, this.getFacet("minExclusive"), this.isFixed("minExclusive"));
        }
        if (this.contains("maxExclusive")) {
            xSDatatypeImpl = new MaxExclusiveFacet((String)object, string, xSDatatypeImpl, this.getFacet("maxExclusive"), this.isFixed("maxExclusive"));
        }
        if (this.contains("length")) {
            xSDatatypeImpl = new LengthFacet((String)object, string, xSDatatypeImpl, this);
        }
        if (this.contains("minLength")) {
            xSDatatypeImpl = new MinLengthFacet((String)object, string, xSDatatypeImpl, this);
        }
        if (this.contains("maxLength")) {
            xSDatatypeImpl = new MaxLengthFacet((String)object, string, xSDatatypeImpl, this);
        }
        if (this.contains("whiteSpace")) {
            xSDatatypeImpl = new WhiteSpaceFacet((String)object, string, xSDatatypeImpl, this);
        }
        if (this.contains("pattern")) {
            xSDatatypeImpl = new PatternFacet((String)object, string, xSDatatypeImpl, this);
        }
        if (this.contains("enumeration")) {
            xSDatatypeImpl = new EnumerationFacet((String)object, string, xSDatatypeImpl, this.getVector("enumeration"), this.isFixed("enumeration"));
        }
        DataTypeWithFacet dataTypeWithFacet = xSDatatypeImpl.getFacetObject("maxLength");
        object = xSDatatypeImpl.getFacetObject("minLength");
        if (dataTypeWithFacet != null && object != null && ((MaxLengthFacet)dataTypeWithFacet).maxLength < ((MinLengthFacet)object).minLength) {
            throw TypeIncubator.reportFacetInconsistency(string, dataTypeWithFacet, "maxLength", (DataTypeWithFacet)object, "minLength");
        }
        dataTypeWithFacet = xSDatatypeImpl.getFacetObject("fractionDigits");
        object = xSDatatypeImpl.getFacetObject("totalDigits");
        if (dataTypeWithFacet != null && object != null && ((FractionDigitsFacet)dataTypeWithFacet).scale > ((TotalDigitsFacet)object).precision) {
            throw TypeIncubator.reportFacetInconsistency(string, dataTypeWithFacet, "fractionDigits", (DataTypeWithFacet)object, "totalDigits");
        }
        TypeIncubator.checkRangeConsistency(xSDatatypeImpl, "minInclusive", "maxInclusive");
        TypeIncubator.checkRangeConsistency(xSDatatypeImpl, "minExclusive", "maxExclusive");
        TypeIncubator.checkRangeConsistency(xSDatatypeImpl, "minInclusive", "maxExclusive");
        TypeIncubator.checkRangeConsistency(xSDatatypeImpl, "minExclusive", "maxInclusive");
        return xSDatatypeImpl;
    }

    private static void checkRangeConsistency(XSDatatypeImpl xSDatatypeImpl, String string, String string2) {
        int n2;
        DataTypeWithFacet dataTypeWithFacet = xSDatatypeImpl.getFacetObject(string);
        DataTypeWithFacet dataTypeWithFacet2 = xSDatatypeImpl.getFacetObject(string2);
        if (dataTypeWithFacet != null && dataTypeWithFacet2 != null && (n2 = ((Comparator)((Object)((XSDatatypeImpl)dataTypeWithFacet).getConcreteType())).compare(((RangeFacet)dataTypeWithFacet).limitValue, ((RangeFacet)dataTypeWithFacet2).limitValue)) == 1) {
            throw TypeIncubator.reportFacetInconsistency(xSDatatypeImpl.displayName(), dataTypeWithFacet, string, dataTypeWithFacet2, string2);
        }
    }

    private static DatatypeException reportFacetInconsistency(String string, DataTypeWithFacet dataTypeWithFacet, String string2, DataTypeWithFacet dataTypeWithFacet2, String string3) {
        String string4;
        String string5 = dataTypeWithFacet.getName();
        if (string5.equals(string4 = dataTypeWithFacet2.getName())) {
            return new DatatypeException(XSDatatypeImpl.localize("InconsistentFacets.1", string2, string3));
        }
        if (string5.equals(string)) {
            return new DatatypeException(XSDatatypeImpl.localize("InconsistentFacets.2", string2, dataTypeWithFacet2.displayName(), string3));
        }
        if (string4.equals(string)) {
            return new DatatypeException(XSDatatypeImpl.localize("InconsistentFacets.2", string3, dataTypeWithFacet.displayName(), string2));
        }
        throw new IllegalStateException();
    }

    private static boolean isValueFacet(String string) {
        return string.equals("enumeration") || string.equals("maxExclusive") || string.equals("minExclusive") || string.equals("maxInclusive") || string.equals("minInclusive");
    }

    private static boolean isRepeatable(String string) {
        return string.equals("enumeration") || string.equals("pattern");
    }

    public boolean isFixed(String string) {
        return ((TypeIncubator$FacetInfo)this.impl.get((Object)string)).fixed;
    }

    public Object getFacet(String string) {
        return ((TypeIncubator$FacetInfo)this.impl.get((Object)string)).value;
    }

    public Vector getVector(String string) {
        return (Vector)((TypeIncubator$FacetInfo)this.impl.get((Object)string)).value;
    }

    public int getPositiveInteger(String string) {
        try {
            int n2 = Integer.parseInt((String)this.getFacet(string));
            if (n2 > 0) {
                return n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            try {
                if (new BigInteger((String)this.getFacet(string)).signum() > 0) {
                    return Integer.MAX_VALUE;
                }
            }
            catch (NumberFormatException numberFormatException2) {}
        }
        throw new DatatypeException(XSDatatypeImpl.localize("BadTypeException.FacetMustBePositiveInteger", string));
    }

    public int getNonNegativeInteger(String string) {
        try {
            int n2 = Integer.parseInt((String)this.getFacet(string));
            if (n2 >= 0) {
                return n2;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        throw new DatatypeException(XSDatatypeImpl.localize("BadTypeException.FacetMustBeNonNegativeInteger", string));
    }

    private boolean contains(String string) {
        return this.impl.containsKey(string);
    }

    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    public void dump(PrintStream printStream) {
        for (Object object : this.impl.keySet()) {
            TypeIncubator$FacetInfo typeIncubator$FacetInfo = (TypeIncubator$FacetInfo)this.impl.get(object);
            if (typeIncubator$FacetInfo.value instanceof Vector) {
                printStream.println((String)object + " :");
                object = (Vector)typeIncubator$FacetInfo.value;
                for (int i2 = 0; i2 < ((Vector)object).size(); ++i2) {
                    printStream.println("  " + ((Vector)object).elementAt(i2));
                }
                continue;
            }
            printStream.println((String)object + " : " + typeIncubator$FacetInfo.value);
        }
    }

    public String getFacetNames() {
        String string = "";
        Iterator iterator = this.impl.keySet().iterator();
        while (iterator.hasNext()) {
            if (string.length() != 0) {
                string = string + ", ";
            }
            string = string + (String)iterator.next();
        }
        return string;
    }
}

