/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd.datetime;

import com.sun.msv.datatype.xsd.datetime.TimeZone;
import java.util.Calendar;

abstract class AbstractCalendarFormatter {
    AbstractCalendarFormatter() {
    }

    public String doFormat(String string, Object object) {
        int n2 = 0;
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        block9: while (n2 < n3) {
            char c2;
            if ((c2 = string.charAt(n2++)) != '%') {
                stringBuffer.append(c2);
                continue;
            }
            switch (string.charAt(n2++)) {
                case 'Y': {
                    this.formatYear(object, stringBuffer);
                    continue block9;
                }
                case 'M': {
                    this.formatMonth(object, stringBuffer);
                    continue block9;
                }
                case 'D': {
                    this.formatDays(object, stringBuffer);
                    continue block9;
                }
                case 'h': {
                    this.formatHours(object, stringBuffer);
                    continue block9;
                }
                case 'm': {
                    this.formatMinutes(object, stringBuffer);
                    continue block9;
                }
                case 's': {
                    this.formatSeconds(object, stringBuffer);
                    continue block9;
                }
                case 'z': {
                    this.formatTimeZone(object, stringBuffer);
                    continue block9;
                }
            }
            throw new InternalError();
        }
        return stringBuffer.toString();
    }

    protected abstract Calendar toCalendar(Object var1);

    protected abstract void formatYear(Object var1, StringBuffer var2);

    protected abstract void formatMonth(Object var1, StringBuffer var2);

    protected abstract void formatDays(Object var1, StringBuffer var2);

    protected abstract void formatHours(Object var1, StringBuffer var2);

    protected abstract void formatMinutes(Object var1, StringBuffer var2);

    protected abstract void formatSeconds(Object var1, StringBuffer var2);

    private void formatTimeZone(Object object, StringBuffer stringBuffer) {
        java.util.TimeZone timeZone = ((Calendar)(object = this.toCalendar(object))).getTimeZone();
        if (timeZone == null) {
            return;
        }
        if (timeZone == TimeZone.MISSING) {
            return;
        }
        if (timeZone == TimeZone.ZERO) {
            stringBuffer.append('Z');
            return;
        }
        int n2 = timeZone.inDaylightTime(((Calendar)object).getTime()) ? timeZone.getRawOffset() + (timeZone.useDaylightTime() ? 3600000 : 0) : timeZone.getRawOffset();
        if (n2 >= 0) {
            stringBuffer.append('+');
        } else {
            stringBuffer.append('-');
            n2 = -n2;
        }
        this.formatTwoDigits((n2 /= 60000) / 60, stringBuffer);
        stringBuffer.append(':');
        this.formatTwoDigits(n2 % 60, stringBuffer);
    }

    protected final void formatTwoDigits(int n2, StringBuffer stringBuffer) {
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
    }
}

