/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd.datetime;

import com.sun.msv.datatype.xsd.datetime.TimeZone;
import java.math.BigInteger;
import java.util.SimpleTimeZone;

abstract class AbstractCalendarParser {
    private final String format;
    private final String value;
    private final int flen;
    private final int vlen;
    private int fidx;
    protected int vidx;

    protected AbstractCalendarParser(String string, String string2) {
        this.format = string;
        this.value = string2;
        this.flen = string.length();
        this.vlen = string2.length();
    }

    public void parse() {
        block9: while (this.fidx < this.flen) {
            int n2;
            if ((n2 = this.format.charAt(this.fidx++)) != 37) {
                this.skip((char)n2);
                continue;
            }
            switch (this.format.charAt(this.fidx++)) {
                case 'Y': {
                    n2 = 1;
                    if (this.peek() == '-') {
                        ++this.vidx;
                        n2 = -1;
                    }
                    this.setYear(n2 * this.parseInt(4, Integer.MAX_VALUE));
                    continue block9;
                }
                case 'M': {
                    AbstractCalendarParser abstractCalendarParser = this;
                    abstractCalendarParser.setMonth(abstractCalendarParser.parseInt(2, 2));
                    continue block9;
                }
                case 'D': {
                    AbstractCalendarParser abstractCalendarParser = this;
                    abstractCalendarParser.setDay(abstractCalendarParser.parseInt(2, 2));
                    continue block9;
                }
                case 'h': {
                    AbstractCalendarParser abstractCalendarParser = this;
                    abstractCalendarParser.setHours(abstractCalendarParser.parseInt(2, 2));
                    continue block9;
                }
                case 'm': {
                    AbstractCalendarParser abstractCalendarParser = this;
                    abstractCalendarParser.setMinutes(abstractCalendarParser.parseInt(2, 2));
                    continue block9;
                }
                case 's': {
                    AbstractCalendarParser abstractCalendarParser = this;
                    abstractCalendarParser.setSeconds(abstractCalendarParser.parseInt(2, 2));
                    if (this.peek() != '.') continue block9;
                    ++this.vidx;
                    this.parseFractionSeconds();
                    continue block9;
                }
                case 'z': {
                    n2 = this.peek();
                    if (n2 == 90) {
                        ++this.vidx;
                        this.setTimeZone(TimeZone.ZERO);
                        continue block9;
                    }
                    if (n2 == 43 || n2 == 45) {
                        ++this.vidx;
                        int n3 = this.parseInt(2, 2);
                        this.skip(':');
                        int n4 = this.parseInt(2, 2);
                        this.setTimeZone(new SimpleTimeZone((n3 * 60 + n4) * (n2 == 43 ? 1 : -1) * 60 * 1000, ""));
                        continue block9;
                    }
                    this.setTimeZone(TimeZone.MISSING);
                    continue block9;
                }
            }
            throw new InternalError();
        }
        if (this.vidx != this.vlen) {
            throw new IllegalArgumentException(this.value);
        }
    }

    private char peek() {
        if (this.vidx == this.vlen) {
            return '\uffff';
        }
        return this.value.charAt(this.vidx);
    }

    private char read() {
        if (this.vidx == this.vlen) {
            throw new IllegalArgumentException(this.value);
        }
        return this.value.charAt(this.vidx++);
    }

    private void skip(char c2) {
        if (this.read() != c2) {
            throw new IllegalArgumentException(this.value);
        }
    }

    protected final void skipDigits() {
        while (AbstractCalendarParser.isDigit(this.peek())) {
            ++this.vidx;
        }
    }

    protected final int parseInt(int n2, int n3) {
        int n4 = this.vidx;
        while (AbstractCalendarParser.isDigit(this.peek()) && this.vidx - n4 < n3) {
            ++this.vidx;
        }
        if (this.vidx - n4 < n2) {
            throw new IllegalArgumentException(this.value);
        }
        return Integer.parseInt(this.value.substring(n4, this.vidx));
    }

    protected final BigInteger parseBigInteger(int n2, int n3) {
        int n4 = this.vidx;
        while (AbstractCalendarParser.isDigit(this.peek()) && this.vidx - n4 <= n3) {
            ++this.vidx;
        }
        if (this.vidx - n4 < n2) {
            throw new IllegalArgumentException(this.value);
        }
        return new BigInteger(this.value.substring(n4, this.vidx));
    }

    private static boolean isDigit(char c2) {
        return '0' <= c2 && c2 <= '9';
    }

    protected abstract void parseFractionSeconds();

    protected abstract void setTimeZone(java.util.TimeZone var1);

    protected abstract void setSeconds(int var1);

    protected abstract void setMinutes(int var1);

    protected abstract void setHours(int var1);

    protected abstract void setDay(int var1);

    protected abstract void setMonth(int var1);

    protected abstract void setYear(int var1);
}

