/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd.datetime;

import com.sun.msv.datatype.xsd.datetime.BigTimeDurationValueType;
import com.sun.msv.datatype.xsd.datetime.IDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.ITimeDurationValueType;
import com.sun.msv.datatype.xsd.datetime.PreciseCalendarFormatter;
import com.sun.msv.datatype.xsd.datetime.TimeZone;
import com.sun.msv.datatype.xsd.datetime.Util;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class BigDateTimeValueType
implements IDateTimeValueType {
    private BigInteger year;
    private Integer month;
    private Integer day;
    private Integer hour;
    private Integer minute;
    private BigDecimal second;
    private java.util.TimeZone zone;
    private IDateTimeValueType normalizedValue = null;
    private static final long serialVersionUID = 1L;

    public BigInteger getYear() {
        return this.year;
    }

    public Integer getMonth() {
        return this.month;
    }

    public Integer getDay() {
        return this.day;
    }

    public Integer getHour() {
        return this.hour;
    }

    public Integer getMinute() {
        return this.minute;
    }

    public BigDecimal getSecond() {
        return this.second;
    }

    public java.util.TimeZone getTimeZone() {
        return this.zone;
    }

    public BigDateTimeValueType(BigDateTimeValueType bigDateTimeValueType, java.util.TimeZone timeZone) {
        this(bigDateTimeValueType.year, bigDateTimeValueType.month, bigDateTimeValueType.day, bigDateTimeValueType.hour, bigDateTimeValueType.minute, bigDateTimeValueType.second, timeZone);
    }

    public BigDateTimeValueType(BigInteger bigInteger, int n2, int n3, int n4, int n5, BigDecimal bigDecimal, java.util.TimeZone timeZone) {
        this(bigInteger, (Integer)n2, (Integer)n3, (Integer)n4, (Integer)n5, bigDecimal, timeZone);
    }

    public BigDateTimeValueType(BigInteger bigInteger, Integer n2, Integer n3, Integer n4, Integer n5, BigDecimal bigDecimal, java.util.TimeZone timeZone) {
        this.year = bigInteger;
        this.month = n2;
        this.day = n3;
        this.hour = n4;
        this.minute = n5;
        this.second = bigDecimal;
        this.zone = timeZone;
    }

    public BigDateTimeValueType() {
    }

    public BigDateTimeValueType getBigValue() {
        return this;
    }

    public boolean equals(Object object) {
        return this.equals((IDateTimeValueType)object);
    }

    public boolean equals(IDateTimeValueType iDateTimeValueType) {
        if (!(iDateTimeValueType instanceof BigDateTimeValueType)) {
            iDateTimeValueType = iDateTimeValueType.getBigValue();
        }
        BigDateTimeValueType bigDateTimeValueType = this;
        return bigDateTimeValueType.equals(bigDateTimeValueType, (BigDateTimeValueType)iDateTimeValueType);
    }

    public boolean equals(BigDateTimeValueType bigDateTimeValueType, BigDateTimeValueType bigDateTimeValueType2) {
        return BigDateTimeValueType.compare(bigDateTimeValueType, bigDateTimeValueType2) == 0;
    }

    public String toString() {
        return PreciseCalendarFormatter.format("%Y-%M-%DT%h:%m:%s%z", this);
    }

    public int hashCode() {
        BigDateTimeValueType bigDateTimeValueType = (BigDateTimeValueType)this.normalize();
        return Util.objHashCode(bigDateTimeValueType.year) + Util.objHashCode(bigDateTimeValueType.month) + Util.objHashCode(bigDateTimeValueType.day) + Util.objHashCode(bigDateTimeValueType.hour) + Util.objHashCode(bigDateTimeValueType.minute) + Util.objHashCode(bigDateTimeValueType.second) + Util.objHashCode(bigDateTimeValueType.zone);
    }

    public int compare(IDateTimeValueType iDateTimeValueType) {
        if (!(iDateTimeValueType instanceof BigDateTimeValueType)) {
            iDateTimeValueType = iDateTimeValueType.getBigValue();
        }
        return BigDateTimeValueType.compare(this, (BigDateTimeValueType)iDateTimeValueType);
    }

    protected static int compare(BigDateTimeValueType bigDateTimeValueType, BigDateTimeValueType bigDateTimeValueType2) {
        bigDateTimeValueType = (BigDateTimeValueType)bigDateTimeValueType.normalize();
        bigDateTimeValueType2 = (BigDateTimeValueType)bigDateTimeValueType2.normalize();
        if (bigDateTimeValueType.zone != null && bigDateTimeValueType2.zone != null || bigDateTimeValueType.zone == null && bigDateTimeValueType2.zone == null) {
            if (!Util.objEqual(bigDateTimeValueType.year, bigDateTimeValueType2.year)) {
                return Util.objCompare(bigDateTimeValueType.year, bigDateTimeValueType2.year);
            }
            if (!Util.objEqual(bigDateTimeValueType.month, bigDateTimeValueType2.month)) {
                return Util.objCompare(bigDateTimeValueType.month, bigDateTimeValueType2.month);
            }
            if (!Util.objEqual(bigDateTimeValueType.day, bigDateTimeValueType2.day)) {
                return Util.objCompare(bigDateTimeValueType.day, bigDateTimeValueType2.day);
            }
            if (!Util.objEqual(bigDateTimeValueType.hour, bigDateTimeValueType2.hour)) {
                return Util.objCompare(bigDateTimeValueType.hour, bigDateTimeValueType2.hour);
            }
            if (!Util.objEqual(bigDateTimeValueType.minute, bigDateTimeValueType2.minute)) {
                return Util.objCompare(bigDateTimeValueType.minute, bigDateTimeValueType2.minute);
            }
            if (!Util.objEqual(bigDateTimeValueType.second, bigDateTimeValueType2.second)) {
                return Util.objCompare(bigDateTimeValueType.second, bigDateTimeValueType2.second);
            }
            return 0;
        }
        if (bigDateTimeValueType.zone == null) {
            int n2 = BigDateTimeValueType.compare((BigDateTimeValueType)new BigDateTimeValueType(bigDateTimeValueType, Util.timeZoneNeg14).normalize(), bigDateTimeValueType2);
            if (n2 == 0 || n2 == -1) {
                return -1;
            }
            n2 = BigDateTimeValueType.compare((BigDateTimeValueType)new BigDateTimeValueType(bigDateTimeValueType, Util.timeZonePos14).normalize(), bigDateTimeValueType2);
            if (n2 == 0 || n2 == 1) {
                return 1;
            }
            return 999;
        }
        int n3 = BigDateTimeValueType.compare(bigDateTimeValueType, new BigDateTimeValueType(bigDateTimeValueType2, Util.timeZonePos14));
        if (n3 == 0 || n3 == -1) {
            return -1;
        }
        n3 = BigDateTimeValueType.compare(bigDateTimeValueType, new BigDateTimeValueType(bigDateTimeValueType2, Util.timeZoneNeg14));
        if (n3 == 0 || n3 == 1) {
            return 1;
        }
        return 999;
    }

    public IDateTimeValueType normalize() {
        if (this.zone == TimeZone.ZERO || this.zone == null) {
            return this;
        }
        if (this.normalizedValue != null) {
            return this.normalizedValue;
        }
        this.normalizedValue = this.add(BigTimeDurationValueType.fromMinutes(-this.zone.getRawOffset() / 60000));
        ((BigDateTimeValueType)this.normalizedValue).zone = TimeZone.ZERO;
        return this.normalizedValue;
    }

    private static BigInteger nullAs0(BigInteger bigInteger) {
        if (bigInteger != null) {
            return bigInteger;
        }
        return BigInteger.ZERO;
    }

    private static BigDecimal nullAs0(BigDecimal bigDecimal) {
        if (bigDecimal != null) {
            return bigDecimal;
        }
        return Util.decimal0;
    }

    private static BigInteger[] divideAndRemainder(BigInteger bigIntegerArray, BigInteger bigInteger) {
        if ((bigIntegerArray = bigIntegerArray.divideAndRemainder(bigInteger))[1].signum() < 0) {
            bigIntegerArray[1] = bigIntegerArray[1].add(bigInteger);
            bigIntegerArray[0] = bigIntegerArray[0].subtract(BigInteger.ONE);
        }
        return bigIntegerArray;
    }

    public IDateTimeValueType add(ITimeDurationValueType serializable) {
        if (serializable instanceof BigTimeDurationValueType) {
            ITimeDurationValueType iTimeDurationValueType = serializable = (BigTimeDurationValueType)serializable;
            BigInteger[] bigIntegerArray = BigDateTimeValueType.divideAndRemainder(Util.int2bi(this.month).add(this.signed((BigTimeDurationValueType)iTimeDurationValueType, ((BigTimeDurationValueType)iTimeDurationValueType).month)), Util.the12);
            int n2 = bigIntegerArray[1].intValue();
            ITimeDurationValueType iTimeDurationValueType2 = serializable;
            BigInteger bigInteger = bigIntegerArray[0].add(BigDateTimeValueType.nullAs0(this.year)).add(this.signed((BigTimeDurationValueType)iTimeDurationValueType2, ((BigTimeDurationValueType)iTimeDurationValueType2).year));
            ITimeDurationValueType iTimeDurationValueType3 = serializable;
            BigDecimal bigDecimal = BigDateTimeValueType.nullAs0(this.second).add(this.signed((BigTimeDurationValueType)iTimeDurationValueType3, ((BigTimeDurationValueType)iTimeDurationValueType3).second));
            bigIntegerArray = BigDateTimeValueType.divideAndRemainder(bigDecimal.unscaledValue(), Util.the60.multiply(Util.the10.pow(bigDecimal.scale())));
            BigDecimal bigDecimal2 = new BigDecimal(bigIntegerArray[1], bigDecimal.scale());
            ITimeDurationValueType iTimeDurationValueType4 = serializable;
            bigIntegerArray = BigDateTimeValueType.divideAndRemainder(bigIntegerArray[0].add(Util.int2bi(this.minute)).add(this.signed((BigTimeDurationValueType)iTimeDurationValueType4, ((BigTimeDurationValueType)iTimeDurationValueType4).minute)), Util.the60);
            int n3 = bigIntegerArray[1].intValue();
            ITimeDurationValueType iTimeDurationValueType5 = serializable;
            bigIntegerArray = BigDateTimeValueType.divideAndRemainder(bigIntegerArray[0].add(Util.int2bi(this.hour)).add(this.signed((BigTimeDurationValueType)iTimeDurationValueType5, ((BigTimeDurationValueType)iTimeDurationValueType5).hour)), Util.the24);
            int n4 = bigIntegerArray[1].intValue();
            int n5 = Util.maximumDayInMonthFor(bigInteger, n2);
            int n6 = this.day != null ? this.day : 0;
            n5 = n6 < 0 ? 0 : (n6 >= n5 ? --n5 : n6);
            ITimeDurationValueType iTimeDurationValueType6 = serializable;
            BigInteger bigInteger2 = this.signed((BigTimeDurationValueType)iTimeDurationValueType6, ((BigTimeDurationValueType)iTimeDurationValueType6).day).add(bigIntegerArray[0]).add(Util.int2bi(n5));
            while (true) {
                int n7;
                if (bigInteger2.signum() == -1) {
                    bigInteger2 = bigInteger2.add(Util.int2bi(Util.maximumDayInMonthFor(bigInteger, (n2 + 11) % 12)));
                    n7 = -1;
                } else {
                    serializable = Util.int2bi(Util.maximumDayInMonthFor(bigInteger, n2));
                    if (bigInteger2.compareTo((BigInteger)serializable) < 0) break;
                    bigInteger2 = bigInteger2.subtract((BigInteger)serializable);
                    n7 = 1;
                }
                if ((n2 += n7) < 0) {
                    n2 += 12;
                    bigInteger = bigInteger.subtract(BigInteger.ONE);
                }
                bigInteger = bigInteger.add(Util.int2bi(n2 / 12));
                n2 %= 12;
            }
            return new BigDateTimeValueType(this.year != null ? bigInteger : null, this.month != null ? Integer.valueOf(n2) : null, this.day != null ? new Integer(bigInteger2.intValue()) : null, this.hour != null ? Integer.valueOf(n4) : null, this.minute != null ? Integer.valueOf(n3) : null, this.second != null ? bigDecimal2 : null, this.zone);
        }
        return this.add(serializable.getBigValue());
    }

    private BigInteger signed(BigTimeDurationValueType bigTimeDurationValueType, BigInteger bigInteger) {
        if (bigTimeDurationValueType.signum < 0) {
            return bigInteger.negate();
        }
        return bigInteger;
    }

    private BigDecimal signed(BigTimeDurationValueType bigTimeDurationValueType, BigDecimal bigDecimal) {
        if (bigTimeDurationValueType.signum < 0) {
            return bigDecimal.negate();
        }
        return bigDecimal;
    }

    public Calendar toCalendar() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(0, 0, 0);
        ((Calendar)gregorianCalendar).setTimeZone(this.createJavaTimeZone());
        gregorianCalendar.clear(1);
        gregorianCalendar.clear(2);
        gregorianCalendar.clear(5);
        if (this.getYear() != null) {
            gregorianCalendar.set(1, this.getYear().intValue());
        }
        if (this.getMonth() != null) {
            gregorianCalendar.set(2, this.getMonth());
        }
        if (this.getDay() != null) {
            gregorianCalendar.set(5, this.getDay() + 1);
        }
        if (this.getHour() != null) {
            gregorianCalendar.set(11, this.getHour());
        }
        if (this.getMinute() != null) {
            gregorianCalendar.set(12, this.getMinute());
        }
        if (this.getSecond() != null) {
            gregorianCalendar.set(13, this.getSecond().intValue());
            gregorianCalendar.set(14, this.getSecond().movePointRight(3).intValue() % 1000);
        }
        return gregorianCalendar;
    }

    protected java.util.TimeZone createJavaTimeZone() {
        java.util.TimeZone timeZone = this.getTimeZone();
        if (timeZone == null) {
            return TimeZone.MISSING;
        }
        return timeZone;
    }
}

