/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd.datetime;

import com.sun.msv.datatype.xsd.datetime.BigDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.ITimeDurationValueType;
import com.sun.msv.datatype.xsd.datetime.TimeZone;
import com.sun.msv.datatype.xsd.datetime.Util;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigTimeDurationValueType
implements ITimeDurationValueType {
    protected int signum;
    protected BigInteger year;
    protected BigInteger month;
    protected BigInteger day;
    protected BigInteger hour;
    protected BigInteger minute;
    protected BigDecimal second;
    private static final BigDateTimeValueType[] testInstance = new BigDateTimeValueType[]{new BigDateTimeValueType(new BigInteger("1696"), 8, 0, 0, 0, new BigDecimal(0), TimeZone.ZERO), new BigDateTimeValueType(new BigInteger("1697"), 1, 0, 0, 0, new BigDecimal(0), TimeZone.ZERO), new BigDateTimeValueType(new BigInteger("1903"), 2, 0, 0, 0, new BigDecimal(0), TimeZone.ZERO), new BigDateTimeValueType(new BigInteger("1903"), 6, 0, 0, 0, new BigDecimal(0), TimeZone.ZERO)};
    private static final long serialVersionUID = 1L;

    public boolean equals(Object object) {
        return this.equals((ITimeDurationValueType)object);
    }

    public boolean equals(ITimeDurationValueType iTimeDurationValueType) {
        return this.compare(iTimeDurationValueType) == 0;
    }

    public String toString() {
        BigTimeDurationValueType bigTimeDurationValueType = this;
        BigTimeDurationValueType bigTimeDurationValueType2 = this;
        BigTimeDurationValueType bigTimeDurationValueType3 = this;
        BigTimeDurationValueType bigTimeDurationValueType4 = this;
        BigTimeDurationValueType bigTimeDurationValueType5 = this;
        return (this.signum < 0 ? "-" : "") + "P" + bigTimeDurationValueType.nullAsZero(bigTimeDurationValueType.year).abs() + "Y" + bigTimeDurationValueType2.nullAsZero(bigTimeDurationValueType2.month) + "M" + bigTimeDurationValueType3.nullAsZero(bigTimeDurationValueType3.day) + "DT" + bigTimeDurationValueType4.nullAsZero(bigTimeDurationValueType4.hour) + "H" + bigTimeDurationValueType5.nullAsZero(bigTimeDurationValueType5.minute) + "M" + (this.second == null ? "" : this.second.toString()) + "S";
    }

    private BigInteger nullAsZero(BigInteger bigInteger) {
        if (bigInteger == null) {
            return BigInteger.ZERO;
        }
        return bigInteger;
    }

    public int hashCode() {
        BigTimeDurationValueType bigTimeDurationValueType = this;
        BigTimeDurationValueType bigTimeDurationValueType2 = this;
        BigTimeDurationValueType bigTimeDurationValueType3 = this;
        return bigTimeDurationValueType.nullAsZero(bigTimeDurationValueType.day).multiply(Util.the24).add(bigTimeDurationValueType2.nullAsZero(bigTimeDurationValueType2.hour)).multiply(Util.the60).add(bigTimeDurationValueType3.nullAsZero(bigTimeDurationValueType3.minute)).mod(Util.the210379680).hashCode();
    }

    public int compare(ITimeDurationValueType iTimeDurationValueType) {
        if (!(iTimeDurationValueType instanceof BigTimeDurationValueType)) {
            iTimeDurationValueType = iTimeDurationValueType.getBigValue();
        }
        return BigTimeDurationValueType.compare(this, (BigTimeDurationValueType)iTimeDurationValueType);
    }

    private static int compare(BigTimeDurationValueType bigTimeDurationValueType, BigTimeDurationValueType bigTimeDurationValueType2) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < testInstance.length; ++i2) {
            BigDateTimeValueType bigDateTimeValueType;
            BigDateTimeValueType bigDateTimeValueType2 = (BigDateTimeValueType)testInstance[i2].add(bigTimeDurationValueType);
            int n2 = BigDateTimeValueType.compare(bigDateTimeValueType2, bigDateTimeValueType = (BigDateTimeValueType)testInstance[i2].add(bigTimeDurationValueType2));
            if (n2 < 0) {
                bl = true;
            }
            if (n2 > 0) {
                bl2 = true;
            }
            if (n2 != 0 || bigDateTimeValueType2.equals(bigDateTimeValueType)) continue;
            bl3 = true;
        }
        if (bl3) {
            return 999;
        }
        if (bl && bl2) {
            return 999;
        }
        if (bl) {
            return -1;
        }
        if (bl2) {
            return 1;
        }
        return 0;
    }

    public BigTimeDurationValueType getBigValue() {
        return this;
    }

    public BigTimeDurationValueType(int n2, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigDecimal bigDecimal) {
        this.signum = n2;
        this.year = bigInteger != null ? bigInteger : BigInteger.ZERO;
        this.month = bigInteger2 != null ? bigInteger2 : BigInteger.ZERO;
        this.day = bigInteger3 != null ? bigInteger3 : BigInteger.ZERO;
        this.hour = bigInteger4 != null ? bigInteger4 : BigInteger.ZERO;
        this.minute = bigInteger5 != null ? bigInteger5 : BigInteger.ZERO;
        this.second = bigDecimal != null ? bigDecimal : Util.decimal0;
    }

    public static BigTimeDurationValueType fromMinutes(int n2) {
        return BigTimeDurationValueType.fromMinutes(Util.int2bi(n2));
    }

    public static BigTimeDurationValueType fromMinutes(BigInteger bigInteger) {
        return new BigTimeDurationValueType(bigInteger.signum(), null, null, null, null, bigInteger.abs(), null);
    }

    public BigInteger getDay() {
        return this.day;
    }

    public BigInteger getHour() {
        return this.hour;
    }

    public BigInteger getMinute() {
        return this.minute;
    }

    public BigInteger getMonth() {
        return this.month;
    }

    public BigDecimal getSecond() {
        return this.second;
    }

    public BigInteger getYear() {
        return this.year;
    }

    public BigTimeDurationValueType(String string) {
        boolean bl;
        int[] nArray = new int[1];
        if (string.charAt(nArray[0]) == '-') {
            nArray[0] = nArray[0] + 1;
            bl = false;
        } else {
            bl = true;
        }
        int n2 = nArray[0];
        nArray[0] = n2 + 1;
        if (string.charAt(n2) != 'P') {
            throw new IllegalArgumentException(string);
        }
        int n3 = 0;
        String[] stringArray = new String[3];
        int[] nArray2 = new int[3];
        while (string.length() != nArray[0] && BigTimeDurationValueType.isDigit(string.charAt(nArray[0])) && n3 < 3) {
            nArray2[n3] = nArray[0];
            stringArray[n3++] = BigTimeDurationValueType.parsePiece(string, nArray);
        }
        if (string.length() != nArray[0]) {
            int n4 = nArray[0];
            nArray[0] = n4 + 1;
            if (string.charAt(n4) != 'T') {
                throw new IllegalArgumentException(string);
            }
        }
        int n5 = 0;
        String[] stringArray2 = new String[3];
        int[] nArray3 = new int[3];
        while (string.length() != nArray[0] && BigTimeDurationValueType.isDigitOrPeriod(string.charAt(nArray[0])) && n5 < 3) {
            nArray3[n5] = nArray[0];
            stringArray2[n5++] = BigTimeDurationValueType.parsePiece(string, nArray);
        }
        if (string.length() != nArray[0]) {
            throw new IllegalArgumentException(string);
        }
        if (n3 == 0 && n5 == 0) {
            throw new IllegalArgumentException(string);
        }
        BigTimeDurationValueType.organizeParts(string, stringArray, nArray2, n3, "YMD");
        BigTimeDurationValueType.organizeParts(string, stringArray2, nArray3, n5, "HMS");
        this.year = BigTimeDurationValueType.parseBigInteger(string, stringArray[0], nArray2[0]);
        this.month = BigTimeDurationValueType.parseBigInteger(string, stringArray[1], nArray2[1]);
        this.day = BigTimeDurationValueType.parseBigInteger(string, stringArray[2], nArray2[2]);
        this.hour = BigTimeDurationValueType.parseBigInteger(string, stringArray2[0], nArray3[0]);
        this.minute = BigTimeDurationValueType.parseBigInteger(string, stringArray2[1], nArray3[1]);
        this.second = BigTimeDurationValueType.parseBigDecimal(string, stringArray2[2], nArray3[2]);
        this.year = this.year != null ? this.year : BigInteger.ZERO;
        this.month = this.month != null ? this.month : BigInteger.ZERO;
        this.day = this.day != null ? this.day : BigInteger.ZERO;
        this.hour = this.hour != null ? this.hour : BigInteger.ZERO;
        this.minute = this.minute != null ? this.minute : BigInteger.ZERO;
        this.second = this.second != null ? this.second : Util.decimal0;
        BigTimeDurationValueType bigTimeDurationValueType = this;
        if (bigTimeDurationValueType.getSignum(bigTimeDurationValueType.year) == 0) {
            BigTimeDurationValueType bigTimeDurationValueType2 = this;
            if (bigTimeDurationValueType2.getSignum(bigTimeDurationValueType2.month) == 0) {
                BigTimeDurationValueType bigTimeDurationValueType3 = this;
                if (bigTimeDurationValueType3.getSignum(bigTimeDurationValueType3.day) == 0) {
                    BigTimeDurationValueType bigTimeDurationValueType4 = this;
                    if (bigTimeDurationValueType4.getSignum(bigTimeDurationValueType4.hour) == 0) {
                        BigTimeDurationValueType bigTimeDurationValueType5 = this;
                        if (bigTimeDurationValueType5.getSignum(bigTimeDurationValueType5.minute) == 0) {
                            BigTimeDurationValueType bigTimeDurationValueType6 = this;
                            if (bigTimeDurationValueType6.getSignum(bigTimeDurationValueType6.second) == 0) {
                                this.signum = 0;
                                return;
                            }
                        }
                    }
                }
            }
        }
        if (bl) {
            this.signum = 1;
            return;
        }
        this.signum = -1;
    }

    private int getSignum(BigInteger bigInteger) {
        if (bigInteger == null) {
            return 0;
        }
        return bigInteger.signum();
    }

    private int getSignum(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0;
        }
        return bigDecimal.signum();
    }

    private static boolean isDigit(char c2) {
        return '0' <= c2 && c2 <= '9';
    }

    private static boolean isDigitOrPeriod(char c2) {
        return BigTimeDurationValueType.isDigit(c2) || c2 == '.';
    }

    private static String parsePiece(String string, int[] nArray) {
        int n2 = nArray[0];
        while (nArray[0] < string.length() && BigTimeDurationValueType.isDigitOrPeriod(string.charAt(nArray[0]))) {
            nArray[0] = nArray[0] + 1;
        }
        if (nArray[0] == string.length()) {
            throw new IllegalArgumentException(string);
        }
        nArray[0] = nArray[0] + 1;
        return string.substring(n2, nArray[0]);
    }

    private static void organizeParts(String string, String[] stringArray, int[] nArray, int n2, String string2) {
        int n3 = string2.length();
        --n2;
        while (n2 >= 0) {
            int n4 = string2.lastIndexOf(stringArray[n2].charAt(stringArray[n2].length() - 1), n3 - 1);
            if (n4 == -1) {
                throw new IllegalArgumentException(string);
            }
            for (int i2 = n4 + 1; i2 < n3; ++i2) {
                stringArray[i2] = null;
            }
            n3 = n4;
            stringArray[n3] = stringArray[n2];
            nArray[n3] = nArray[n2];
            --n2;
        }
        while (--n3 >= 0) {
            stringArray[n3] = null;
        }
    }

    private static BigInteger parseBigInteger(String string, String string2, int n2) {
        if (string2 == null) {
            return null;
        }
        string2 = string2.substring(0, string2.length() - 1);
        return new BigInteger(string2);
    }

    private static BigDecimal parseBigDecimal(String string, String string2, int n2) {
        if (string2 == null) {
            return null;
        }
        string2 = string2.substring(0, string2.length() - 1);
        return new BigDecimal(string2);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        switch (this.year.signum()) {
            case -1: {
                this.signum = -1;
                this.year = this.year.negate();
                return;
            }
            case 1: {
                this.signum = 1;
                return;
            }
        }
        switch (this.month.signum()) {
            case -1: {
                this.signum = -1;
                this.month = this.month.negate();
                return;
            }
            case 1: {
                this.signum = 1;
                return;
            }
        }
        switch (this.day.signum()) {
            case -1: {
                this.signum = -1;
                this.day = this.day.negate();
                return;
            }
            case 1: {
                this.signum = 1;
                return;
            }
        }
        switch (this.hour.signum()) {
            case -1: {
                this.signum = -1;
                this.hour = this.hour.negate();
                return;
            }
            case 1: {
                this.signum = 1;
                return;
            }
        }
        switch (this.minute.signum()) {
            case -1: {
                this.signum = -1;
                this.minute = this.minute.negate();
                return;
            }
            case 1: {
                this.signum = 1;
                return;
            }
        }
        switch (this.second.signum()) {
            case -1: {
                this.signum = -1;
                this.second = this.second.negate();
                return;
            }
            case 1: {
                this.signum = 1;
                return;
            }
        }
        this.signum = 0;
    }
}

