/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd.datetime;

import com.sun.msv.datatype.xsd.datetime.AbstractCalendarFormatter;
import com.sun.msv.datatype.xsd.datetime.BigDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.IDateTimeValueType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;

public class PreciseCalendarFormatter
extends AbstractCalendarFormatter {
    private static final PreciseCalendarFormatter theInstance = new PreciseCalendarFormatter();

    private PreciseCalendarFormatter() {
    }

    public static String format(String string, IDateTimeValueType iDateTimeValueType) {
        return theInstance.doFormat(string, iDateTimeValueType.getBigValue());
    }

    protected Calendar toCalendar(Object object) {
        return ((BigDateTimeValueType)object).toCalendar();
    }

    protected void formatYear(Object object, StringBuffer stringBuffer) {
        object = ((IDateTimeValueType)object).getBigValue();
        if ((object = ((BigDateTimeValueType)object).getYear()) == null) {
            stringBuffer.append("0000");
            return;
        }
        if (((BigInteger)object).signum() <= 0) {
            stringBuffer.append('-');
            object = ((BigInteger)object).negate().add(BigInteger.ONE).toString();
        } else {
            object = ((BigInteger)object).toString();
        }
        while (((String)object).length() < 4) {
            object = "0" + (String)object;
        }
        stringBuffer.append((String)object);
    }

    protected void formatMonth(Object object, StringBuffer stringBuffer) {
        object = ((IDateTimeValueType)object).getBigValue();
        this.formatTwoDigits(((BigDateTimeValueType)object).getMonth(), 1, stringBuffer);
    }

    protected void formatDays(Object object, StringBuffer stringBuffer) {
        object = ((IDateTimeValueType)object).getBigValue();
        this.formatTwoDigits(((BigDateTimeValueType)object).getDay(), 1, stringBuffer);
    }

    protected void formatHours(Object object, StringBuffer stringBuffer) {
        object = ((IDateTimeValueType)object).getBigValue();
        this.formatTwoDigits(((BigDateTimeValueType)object).getHour(), stringBuffer);
    }

    protected void formatMinutes(Object object, StringBuffer stringBuffer) {
        object = ((IDateTimeValueType)object).getBigValue();
        this.formatTwoDigits(((BigDateTimeValueType)object).getMinute(), stringBuffer);
    }

    protected void formatSeconds(Object object, StringBuffer stringBuffer) {
        object = ((IDateTimeValueType)object).getBigValue();
        if ((object = ((BigDateTimeValueType)object).getSecond()) == null) {
            stringBuffer.append("00");
            return;
        }
        while (((BigDecimal)object).scale() > 0 && ((BigDecimal)object).toString().endsWith("0")) {
            object = ((BigDecimal)object).movePointLeft(1);
        }
        String string = ((BigDecimal)object).toString();
        if (((BigDecimal)object).compareTo(new BigDecimal("10")) < 0) {
            string = "0" + string;
        }
        stringBuffer.append(string);
    }

    private void formatTwoDigits(Integer n2, StringBuffer stringBuffer) {
        this.formatTwoDigits(n2, 0, stringBuffer);
    }

    private void formatTwoDigits(Integer n2, int n3, StringBuffer stringBuffer) {
        if (n2 == null) {
            stringBuffer.append("00");
            return;
        }
        this.formatTwoDigits(n2 + n3, stringBuffer);
    }
}

