/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.ContextFinder$1;
import javax.xml.bind.ContextFinder$2;
import javax.xml.bind.ContextFinder$3;
import javax.xml.bind.GetPropertyAction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Messages;

class ContextFinder {
    private static final Logger logger = Logger.getLogger("javax.xml.bind");
    private static final String PLATFORM_DEFAULT_FACTORY_CLASS = "com.sun.xml.internal.bind.v2.ContextFactory";

    ContextFinder() {
    }

    private static void handleInvocationTargetException(InvocationTargetException throwable) {
        if ((throwable = throwable.getTargetException()) != null) {
            if (throwable instanceof JAXBException) {
                throw (JAXBException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
        }
    }

    private static JAXBException handleClassCastException(Class clazz, Class serializable) {
        serializable = ContextFinder.which(serializable);
        return new JAXBException(Messages.format("JAXBContext.IllegalCast", ContextFinder.getClassClassLoader(clazz).getResource("javax/xml/bind/JAXBContext.class"), serializable));
    }

    static JAXBContext newInstance(String string, String string2, ClassLoader classLoader, Map map) {
        try {
            Class clazz = ContextFinder.safeLoadClass(string2, classLoader);
            return ContextFinder.newInstance(string, clazz, classLoader, map);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JAXBException(Messages.format("ContextFinder.ProviderNotFound", string2), classNotFoundException);
        }
        catch (RuntimeException runtimeException) {
            RuntimeException runtimeException2 = runtimeException;
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", string2, exception), exception);
        }
    }

    static JAXBContext newInstance(String string, Class clazz, ClassLoader classLoader, Map map) {
        try {
            Method method;
            Object object = null;
            try {
                method = clazz.getMethod("createContext", String.class, ClassLoader.class, Map.class);
                object = method.invoke(null, string, classLoader, map);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (object == null) {
                method = clazz.getMethod("createContext", String.class, ClassLoader.class);
                object = method.invoke(null, string, classLoader);
            }
            if (!(object instanceof JAXBContext)) {
                throw ContextFinder.handleClassCastException(object.getClass(), JAXBContext.class);
            }
            return (JAXBContext)object;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            ContextFinder.handleInvocationTargetException(invocationTargetException);
            Throwable throwable = invocationTargetException2;
            if (invocationTargetException2.getTargetException() != null) {
                throwable = invocationTargetException2.getTargetException();
            }
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", clazz, throwable), throwable);
        }
        catch (RuntimeException runtimeException) {
            RuntimeException runtimeException2 = runtimeException;
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new JAXBException(Messages.format("ContextFinder.CouldNotInstantiate", clazz, exception), exception);
        }
    }

    static JAXBContext newInstance(Class[] classArray, Map map, String string) {
        Object object = ContextFinder.getContextClassLoader();
        try {
            object = ContextFinder.safeLoadClass(string, (ClassLoader)object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JAXBException(classNotFoundException);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "loaded {0} from {1}", new Object[]{string, ContextFinder.which((Class)object)});
        }
        return ContextFinder.newInstance(classArray, map, (Class)object);
    }

    static JAXBContext newInstance(Class[] object, Map object2, Class genericDeclaration) {
        try {
            genericDeclaration = ((Class)genericDeclaration).getMethod("createContext", Class[].class, Map.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new JAXBException(noSuchMethodException);
        }
        try {
            object = ((Method)genericDeclaration).invoke(null, object, object2);
            if (!(object instanceof JAXBContext)) {
                throw ContextFinder.handleClassCastException(object.getClass(), JAXBContext.class);
            }
            return (JAXBContext)object;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JAXBException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            object = invocationTargetException;
            ContextFinder.handleInvocationTargetException(invocationTargetException);
            object2 = object;
            if (((InvocationTargetException)object).getTargetException() != null) {
                object2 = ((InvocationTargetException)object).getTargetException();
            }
            throw new JAXBException((Throwable)object2);
        }
    }

    static JAXBContext find(String object, String string, ClassLoader classLoader, Map map) {
        Object object2;
        block18: {
            Object object3;
            Object object4 = JAXBContext.class.getName();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            if (!stringTokenizer.hasMoreTokens()) {
                throw new JAXBException(Messages.format("ContextFinder.NoPackageInContextPath"));
            }
            logger.fine("Searching jaxb.properties");
            while (stringTokenizer.hasMoreTokens()) {
                object3 = stringTokenizer.nextToken(":").replace('.', '/');
                object2 = new StringBuilder().append((String)object3).append("/jaxb.properties");
                if ((object2 = ContextFinder.loadJAXBProperties(classLoader, ((StringBuilder)object2).toString())) == null) continue;
                if (((Properties)object2).containsKey(object)) {
                    object = ((Properties)object2).getProperty((String)object);
                    return ContextFinder.newInstance(string, (String)object, classLoader, map);
                }
                throw new JAXBException(Messages.format("ContextFinder.MissingProperty", object3, object));
            }
            logger.fine("Searching the system property");
            object = AccessController.doPrivileged(new GetPropertyAction("javax.xml.bind.context.factory"));
            if (object != null) {
                return ContextFinder.newInstance(string, (String)object, classLoader, map);
            }
            object = AccessController.doPrivileged(new GetPropertyAction((String)object4));
            if (object != null) {
                return ContextFinder.newInstance(string, (String)object, classLoader, map);
            }
            object3 = ContextFinder.lookupJaxbContextUsingOsgiServiceLoader();
            if (object3 != null) {
                logger.fine("OSGi environment detected");
                return ContextFinder.newInstance(string, (Class)object3, classLoader, map);
            }
            logger.fine("Searching META-INF/services");
            object2 = null;
            object = new StringBuilder("META-INF/services/").append((String)object4);
            object4 = classLoader.getResourceAsStream(((StringBuilder)object).toString());
            if (object4 == null) break block18;
            object2 = new BufferedReader(new InputStreamReader((InputStream)object4, "UTF-8"));
            object = ((BufferedReader)object2).readLine();
            if (object != null) {
                object = ((String)object).trim();
            }
            ((BufferedReader)object2).close();
            object = ContextFinder.newInstance(string, (String)object, classLoader, map);
            try {
                ((BufferedReader)object2).close();
            }
            catch (IOException iOException) {
                Logger.getLogger(ContextFinder.class.getName()).log(Level.SEVERE, null, iOException);
            }
            return object;
        }
        try {
            try {
                logger.log(Level.FINE, "Unable to load:{0}", ((StringBuilder)object).toString());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new JAXBException(unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new JAXBException(iOException);
            }
        }
        catch (Throwable throwable) {
            try {
                if (object2 != null) {
                    ((BufferedReader)object2).close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(ContextFinder.class.getName()).log(Level.SEVERE, null, iOException);
            }
            throw throwable;
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance(string, PLATFORM_DEFAULT_FACTORY_CLASS, classLoader, map);
    }

    static JAXBContext find(Class[] classArray, Map map) {
        String string;
        BufferedReader bufferedReader;
        block18: {
            Object object;
            Object object2;
            String string2 = JAXBContext.class.getName();
            Object object3 = classArray;
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                object2 = object3[i2];
                object = ContextFinder.getClassClassLoader((Class)object2);
                if ((object2 = ((Class)object2).getPackage()) == null) continue;
                String string3 = ((Package)object2).getName().replace('.', '/');
                object2 = string3 + "/jaxb.properties";
                logger.log(Level.FINE, "Trying to locate {0}", object2);
                object2 = ContextFinder.loadJAXBProperties((ClassLoader)object, (String)object2);
                if (object2 == null) {
                    logger.fine("  not found");
                    continue;
                }
                logger.fine("  found");
                if (((Properties)object2).containsKey("javax.xml.bind.context.factory")) {
                    object3 = ((Properties)object2).getProperty("javax.xml.bind.context.factory").trim();
                    return ContextFinder.newInstance(classArray, map, (String)object3);
                }
                throw new JAXBException(Messages.format("ContextFinder.MissingProperty", string3, "javax.xml.bind.context.factory"));
            }
            logger.log(Level.FINE, "Checking system property {0}", "javax.xml.bind.context.factory");
            object3 = AccessController.doPrivileged(new GetPropertyAction("javax.xml.bind.context.factory"));
            if (object3 != null) {
                logger.log(Level.FINE, "  found {0}", object3);
                return ContextFinder.newInstance(classArray, map, (String)object3);
            }
            logger.fine("  not found");
            logger.log(Level.FINE, "Checking system property {0}", string2);
            object3 = AccessController.doPrivileged(new GetPropertyAction(string2));
            if (object3 != null) {
                logger.log(Level.FINE, "  found {0}", object3);
                return ContextFinder.newInstance(classArray, map, (String)object3);
            }
            logger.fine("  not found");
            object3 = ContextFinder.lookupJaxbContextUsingOsgiServiceLoader();
            if (object3 != null) {
                logger.fine("OSGi environment detected");
                return ContextFinder.newInstance(classArray, map, (Class)object3);
            }
            logger.fine("Checking META-INF/services");
            bufferedReader = null;
            string = "META-INF/services/".concat(String.valueOf(string2));
            object2 = ContextFinder.getContextClassLoader();
            object = object2 == null ? ClassLoader.getSystemResource(string) : ((ClassLoader)object2).getResource(string);
            if (object == null) break block18;
            logger.log(Level.FINE, "Reading {0}", object);
            bufferedReader = new BufferedReader(new InputStreamReader(((URL)object).openStream(), "UTF-8"));
            object3 = bufferedReader.readLine();
            if (object3 != null) {
                object3 = ((String)object3).trim();
            }
            object2 = ContextFinder.newInstance(classArray, map, (String)object3);
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, "Unable to close stream", iOException);
            }
            return object2;
        }
        try {
            try {
                logger.log(Level.FINE, "Unable to find: {0}", string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new JAXBException(unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new JAXBException(iOException);
            }
        }
        catch (Throwable throwable) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    logger.log(Level.FINE, "Unable to close stream", iOException);
                }
            }
            throw throwable;
        }
        logger.fine("Trying to create the platform default provider");
        return ContextFinder.newInstance(classArray, map, PLATFORM_DEFAULT_FACTORY_CLASS);
    }

    private static Class lookupJaxbContextUsingOsgiServiceLoader() {
        try {
            Object object = Class.forName("org.glassfish.hk2.osgiresourcelocator.ServiceLoader");
            object = ((Class)object).getMethod("lookupProviderClasses", Class.class);
            object = ((Iterable)((Method)object).invoke(null, JAXBContext.class)).iterator();
            if (object.hasNext()) {
                return (Class)object.next();
            }
            return null;
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Unable to find from OSGi: javax.xml.bind.JAXBContext");
            return null;
        }
    }

    private static Properties loadJAXBProperties(ClassLoader object, String string) {
        Properties properties = null;
        try {
            object = object == null ? ClassLoader.getSystemResource(string) : ((ClassLoader)object).getResource(string);
            if (object != null) {
                logger.log(Level.FINE, "loading props from {0}", object);
                properties = new Properties();
                object = ((URL)object).openStream();
                properties.load((InputStream)object);
                ((InputStream)object).close();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Unable to load " + string, iOException);
            throw new JAXBException(iOException.toString(), iOException);
        }
        return properties;
    }

    static URL which(Class object, ClassLoader classLoader) {
        object = ((Class)object).getName().replace('.', '/') + ".class";
        if (classLoader == null) {
            classLoader = ContextFinder.getSystemClassLoader();
        }
        return classLoader.getResource((String)object);
    }

    static URL which(Class clazz) {
        Class clazz2 = clazz;
        return ContextFinder.which(clazz2, ContextFinder.getClassClassLoader(clazz2));
    }

    private static Class safeLoadClass(String string, ClassLoader classLoader) {
        logger.log(Level.FINE, "Trying to load {0}", string);
        try {
            int n2;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && (n2 = string.lastIndexOf(46)) != -1) {
                securityManager.checkPackageAccess(string.substring(0, n2));
            }
            if (classLoader == null) {
                return Class.forName(string);
            }
            return classLoader.loadClass(string);
        }
        catch (SecurityException securityException) {
            if (PLATFORM_DEFAULT_FACTORY_CLASS.equals(string)) {
                return Class.forName(string);
            }
            throw securityException;
        }
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new ContextFinder$1());
    }

    private static ClassLoader getClassClassLoader(Class clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new ContextFinder$2(clazz));
    }

    private static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new ContextFinder$3());
    }

    static {
        try {
            if (AccessController.doPrivileged(new GetPropertyAction("jaxb.debug")) != null) {
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.ALL);
                ConsoleHandler consoleHandler = new ConsoleHandler();
                consoleHandler.setLevel(Level.ALL);
                logger.addHandler(consoleHandler);
            }
        }
        catch (Throwable throwable) {}
    }
}

