/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.util.Calendar;
import java.util.TimeZone;

final class DatatypeConverterImpl$CalendarFormatter {
    private DatatypeConverterImpl$CalendarFormatter() {
    }

    public static String doFormat(String string, Calendar calendar) {
        int n2 = 0;
        int n3 = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        block9: while (n2 < n3) {
            char c2;
            if ((c2 = string.charAt(n2++)) != '%') {
                stringBuilder.append(c2);
                continue;
            }
            switch (string.charAt(n2++)) {
                case 'Y': {
                    DatatypeConverterImpl$CalendarFormatter.formatYear(calendar, stringBuilder);
                    continue block9;
                }
                case 'M': {
                    DatatypeConverterImpl$CalendarFormatter.formatMonth(calendar, stringBuilder);
                    continue block9;
                }
                case 'D': {
                    DatatypeConverterImpl$CalendarFormatter.formatDays(calendar, stringBuilder);
                    continue block9;
                }
                case 'h': {
                    DatatypeConverterImpl$CalendarFormatter.formatHours(calendar, stringBuilder);
                    continue block9;
                }
                case 'm': {
                    DatatypeConverterImpl$CalendarFormatter.formatMinutes(calendar, stringBuilder);
                    continue block9;
                }
                case 's': {
                    DatatypeConverterImpl$CalendarFormatter.formatSeconds(calendar, stringBuilder);
                    continue block9;
                }
                case 'z': {
                    DatatypeConverterImpl$CalendarFormatter.formatTimeZone(calendar, stringBuilder);
                    continue block9;
                }
            }
            throw new InternalError();
        }
        return stringBuilder.toString();
    }

    private static void formatYear(Calendar calendar, StringBuilder stringBuilder) {
        int n2 = calendar.get(1);
        String string = n2 <= 0 ? Integer.toString(1 - n2) : Integer.toString(n2);
        while (string.length() < 4) {
            string = "0" + string;
        }
        if (n2 <= 0) {
            string = "-" + string;
        }
        stringBuilder.append(string);
    }

    private static void formatMonth(Calendar calendar, StringBuilder stringBuilder) {
        DatatypeConverterImpl$CalendarFormatter.formatTwoDigits(calendar.get(2) + 1, stringBuilder);
    }

    private static void formatDays(Calendar calendar, StringBuilder stringBuilder) {
        DatatypeConverterImpl$CalendarFormatter.formatTwoDigits(calendar.get(5), stringBuilder);
    }

    private static void formatHours(Calendar calendar, StringBuilder stringBuilder) {
        DatatypeConverterImpl$CalendarFormatter.formatTwoDigits(calendar.get(11), stringBuilder);
    }

    private static void formatMinutes(Calendar calendar, StringBuilder stringBuilder) {
        DatatypeConverterImpl$CalendarFormatter.formatTwoDigits(calendar.get(12), stringBuilder);
    }

    private static void formatSeconds(Calendar calendar, StringBuilder stringBuilder) {
        int n2;
        DatatypeConverterImpl$CalendarFormatter.formatTwoDigits(calendar.get(13), stringBuilder);
        if (calendar.isSet(14) && (n2 = calendar.get(14)) != 0) {
            String string = Integer.toString(n2);
            while (string.length() < 3) {
                string = "0" + string;
            }
            stringBuilder.append('.');
            stringBuilder.append(string);
        }
    }

    private static void formatTimeZone(Calendar calendar, StringBuilder stringBuilder) {
        TimeZone timeZone = calendar.getTimeZone();
        if (timeZone == null) {
            return;
        }
        int n2 = timeZone.getOffset(calendar.getTime().getTime());
        if (n2 == 0) {
            stringBuilder.append('Z');
            return;
        }
        if (n2 >= 0) {
            stringBuilder.append('+');
        } else {
            stringBuilder.append('-');
            n2 = -n2;
        }
        DatatypeConverterImpl$CalendarFormatter.formatTwoDigits((n2 /= 60000) / 60, stringBuilder);
        stringBuilder.append(':');
        DatatypeConverterImpl$CalendarFormatter.formatTwoDigits(n2 % 60, stringBuilder);
    }

    private static void formatTwoDigits(int n2, StringBuilder stringBuilder) {
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
    }
}

