/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.helpers;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Unmarshaller$Listener;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.bind.helpers.Messages;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUnmarshallerImpl
implements Unmarshaller {
    private ValidationEventHandler eventHandler = new DefaultValidationEventHandler();
    protected boolean validating = false;
    private XMLReader reader = null;

    protected XMLReader getXMLReader() {
        if (this.reader == null) {
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(true);
                sAXParserFactory.setValidating(false);
                this.reader = sAXParserFactory.newSAXParser().getXMLReader();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new JAXBException(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new JAXBException(sAXException);
            }
        }
        return this.reader;
    }

    @Override
    public Object unmarshal(Source source) {
        if (source == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "source"));
        }
        if (source instanceof SAXSource) {
            return this.unmarshal((SAXSource)source);
        }
        if (source instanceof StreamSource) {
            return this.unmarshal(AbstractUnmarshallerImpl.streamSourceToInputSource((StreamSource)source));
        }
        if (source instanceof DOMSource) {
            return this.unmarshal(((DOMSource)source).getNode());
        }
        throw new IllegalArgumentException();
    }

    private Object unmarshal(SAXSource sAXSource) {
        XMLReader xMLReader = sAXSource.getXMLReader();
        if (xMLReader == null) {
            xMLReader = this.getXMLReader();
        }
        return this.unmarshal(xMLReader, sAXSource.getInputSource());
    }

    protected abstract Object unmarshal(XMLReader var1, InputSource var2);

    @Override
    public final Object unmarshal(InputSource inputSource) {
        if (inputSource == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "source"));
        }
        AbstractUnmarshallerImpl abstractUnmarshallerImpl = this;
        return abstractUnmarshallerImpl.unmarshal(abstractUnmarshallerImpl.getXMLReader(), inputSource);
    }

    private Object unmarshal(String string) {
        return this.unmarshal(new InputSource(string));
    }

    @Override
    public final Object unmarshal(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "url"));
        }
        return this.unmarshal(uRL.toExternalForm());
    }

    @Override
    public final Object unmarshal(File file) {
        if (file == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "file"));
        }
        try {
            String string = file.getAbsolutePath();
            if (File.separatorChar != '/') {
                string = string.replace(File.separatorChar, '/');
            }
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if (!string.endsWith("/") && file.isDirectory()) {
                string = string + "/";
            }
            return this.unmarshal(new URL("file", "", string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException.getMessage());
        }
    }

    @Override
    public final Object unmarshal(InputStream object) {
        if (object == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "is"));
        }
        object = new InputSource((InputStream)object);
        return this.unmarshal((InputSource)object);
    }

    @Override
    public final Object unmarshal(Reader object) {
        if (object == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "reader"));
        }
        object = new InputSource((Reader)object);
        return this.unmarshal((InputSource)object);
    }

    private static InputSource streamSourceToInputSource(StreamSource streamSource) {
        InputSource inputSource = new InputSource();
        inputSource.setSystemId(streamSource.getSystemId());
        inputSource.setByteStream(streamSource.getInputStream());
        inputSource.setCharacterStream(streamSource.getReader());
        return inputSource;
    }

    @Override
    public boolean isValidating() {
        return this.validating;
    }

    @Override
    public void setEventHandler(ValidationEventHandler validationEventHandler) {
        if (validationEventHandler == null) {
            this.eventHandler = new DefaultValidationEventHandler();
            return;
        }
        this.eventHandler = validationEventHandler;
    }

    @Override
    public void setValidating(boolean bl) {
        this.validating = bl;
    }

    @Override
    public ValidationEventHandler getEventHandler() {
        return this.eventHandler;
    }

    protected UnmarshalException createUnmarshalException(SAXException sAXException) {
        Exception exception = sAXException.getException();
        if (exception instanceof UnmarshalException) {
            return (UnmarshalException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception != null) {
            return new UnmarshalException(exception);
        }
        return new UnmarshalException(sAXException);
    }

    @Override
    public void setProperty(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "name"));
        }
        throw new PropertyException(string, object);
    }

    @Override
    public Object getProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "name"));
        }
        throw new PropertyException(string);
    }

    @Override
    public Object unmarshal(XMLEventReader xMLEventReader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object unmarshal(XMLStreamReader xMLStreamReader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> JAXBElement<T> unmarshal(Node node, Class<T> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> JAXBElement<T> unmarshal(Source source, Class<T> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> JAXBElement<T> unmarshal(XMLStreamReader xMLStreamReader, Class<T> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> JAXBElement<T> unmarshal(XMLEventReader xMLEventReader, Class<T> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSchema(Schema schema) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Schema getSchema() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAdapter(XmlAdapter xmlAdapter) {
        if (xmlAdapter == null) {
            throw new IllegalArgumentException();
        }
        this.setAdapter(xmlAdapter.getClass(), xmlAdapter);
    }

    @Override
    public <A extends XmlAdapter> void setAdapter(Class<A> clazz, A a2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends XmlAdapter> A getAdapter(Class<A> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttachmentUnmarshaller(AttachmentUnmarshaller attachmentUnmarshaller) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setListener(Unmarshaller$Listener unmarshaller$Listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Unmarshaller$Listener getListener() {
        throw new UnsupportedOperationException();
    }
}

