/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.helpers;

import java.net.URL;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.Messages;
import org.w3c.dom.Node;

public class DefaultValidationEventHandler
implements ValidationEventHandler {
    public boolean handleEvent(ValidationEvent validationEvent) {
        if (validationEvent == null) {
            throw new IllegalArgumentException();
        }
        String string = null;
        boolean bl = false;
        switch (validationEvent.getSeverity()) {
            case 0: {
                string = Messages.format("DefaultValidationEventHandler.Warning");
                bl = true;
                break;
            }
            case 1: {
                string = Messages.format("DefaultValidationEventHandler.Error");
                bl = false;
                break;
            }
            case 2: {
                string = Messages.format("DefaultValidationEventHandler.FatalError");
                bl = false;
                break;
            }
            default: {
                assert (false) : Messages.format("DefaultValidationEventHandler.UnrecognizedSeverity", validationEvent.getSeverity());
                break;
            }
        }
        String string2 = this.getLocation(validationEvent);
        System.out.println(Messages.format("DefaultValidationEventHandler.SeverityMessage", string, validationEvent.getMessage(), string2));
        return bl;
    }

    private String getLocation(ValidationEvent object) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((object = object.getLocator()) != null) {
            URL uRL = object.getURL();
            Object object2 = object.getObject();
            Node node = object.getNode();
            int n2 = object.getLineNumber();
            if (uRL != null || n2 != -1) {
                stringBuffer.append("line " + n2);
                if (uRL != null) {
                    stringBuffer.append(" of " + uRL);
                }
            } else if (object2 != null) {
                stringBuffer.append(" obj: " + object2.toString());
            } else if (node != null) {
                stringBuffer.append(" node: " + node.toString());
            }
        } else {
            stringBuffer.append(Messages.format("DefaultValidationEventHandler.LocationUnavailable"));
        }
        return stringBuffer.toString();
    }
}

