/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.stream;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.FactoryFinder$ClassLoaderFinder;

class FactoryFinder {
    private static boolean debug = false;

    FactoryFinder() {
    }

    private static void debugPrintln(String string) {
        if (debug) {
            System.err.println("STREAM: " + string);
        }
    }

    private static ClassLoader findClassLoader() {
        Object object;
        try {
            object = Class.forName(FactoryFinder.class.getName() + "$ClassLoaderFinderConcrete");
            object = (FactoryFinder$ClassLoaderFinder)((Class)object).newInstance();
            object = ((FactoryFinder$ClassLoaderFinder)object).getContextClassLoader();
        }
        catch (LinkageError linkageError) {
            object = FactoryFinder.class.getClassLoader();
        }
        catch (ClassNotFoundException classNotFoundException) {
            object = FactoryFinder.class.getClassLoader();
        }
        catch (Exception exception) {
            throw new FactoryConfigurationError(exception.toString(), exception);
        }
        return object;
    }

    private static Object newInstance(String string, ClassLoader clazz) {
        try {
            clazz = clazz == null ? Class.forName(string) : ((ClassLoader)((Object)clazz)).loadClass(string);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new FactoryConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new FactoryConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    static Object find(String string) {
        return FactoryFinder.find(string, null);
    }

    static Object find(String string, String string2) {
        ClassLoader classLoader = FactoryFinder.findClassLoader();
        return FactoryFinder.find(string, string2, classLoader);
    }

    static Object find(String string, String string2, ClassLoader classLoader) {
        block12: {
            Object object;
            Object object2;
            block11: {
                try {
                    object2 = System.getProperty(string);
                    if (object2 != null) {
                        FactoryFinder.debugPrintln("found system property" + (String)object2);
                        return FactoryFinder.newInstance((String)object2, classLoader);
                    }
                }
                catch (SecurityException securityException) {}
                try {
                    object2 = System.getProperty("java.home");
                    object = (String)object2 + File.separator + "lib" + File.separator + "jaxp.properties";
                    object2 = new File((String)object);
                    if (((File)object2).exists()) {
                        object = new Properties();
                        ((Properties)object).load(new FileInputStream((File)object2));
                        object2 = ((Properties)object).getProperty(string);
                        FactoryFinder.debugPrintln("found java.home property " + (String)object2);
                        return FactoryFinder.newInstance((String)object2, classLoader);
                    }
                }
                catch (Exception exception) {
                    if (!debug) break block11;
                    exception.printStackTrace();
                }
            }
            object2 = "META-INF/services/" + string;
            try {
                object = classLoader == null ? ClassLoader.getSystemResourceAsStream((String)object2) : classLoader.getResourceAsStream((String)object2);
                if (object != null) {
                    FactoryFinder.debugPrintln("found " + (String)object2);
                    object2 = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"));
                    object = ((BufferedReader)object2).readLine();
                    ((BufferedReader)object2).close();
                    if (object != null && !"".equals(object)) {
                        FactoryFinder.debugPrintln("loaded from services: " + (String)object);
                        return FactoryFinder.newInstance((String)object, classLoader);
                    }
                }
            }
            catch (Exception exception) {
                if (!debug) break block12;
                exception.printStackTrace();
            }
        }
        if (string2 == null) {
            throw new FactoryConfigurationError("Provider for " + string + " cannot be found", null);
        }
        FactoryFinder.debugPrintln("loaded from fallback value: " + string2);
        return FactoryFinder.newInstance(string2, classLoader);
    }

    static {
        try {
            debug = System.getProperty("xml.stream.debug") != null;
        }
        catch (Exception exception) {}
    }
}

