/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Crc16;
import javazoom.jl.decoder.Header;

public final class Bitstream {
    static byte INITIAL_SYNC = 0;
    static byte STRICT_SYNC = 1;
    private static final int BUFFER_INT_SIZE = 433;
    private final int[] framebuffer = new int[433];
    private int framesize;
    private byte[] frame_bytes = new byte[1732];
    private int wordpointer;
    private int bitindex;
    private int syncword;
    private int header_pos = 0;
    private Float replayGainScale;
    private boolean single_ch_mode;
    private final int[] bitmask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071};
    private final PushbackInputStream source;
    private final Header header = new Header();
    private final byte[] syncbuf = new byte[4];
    private Crc16[] crc = new Crc16[1];
    private byte[] rawid3v2 = null;
    private boolean firstframe = true;
    public static final int BITSTREAM_ERROR = 256;
    public static final int UNKNOWN_ERROR = 256;
    public static final int UNKNOWN_SAMPLE_RATE = 257;
    public static final int STREAM_ERROR = 258;
    public static final int UNEXPECTED_EOF = 259;
    public static final int STREAM_EOF = 260;
    public static final int INVALIDFRAME = 261;
    public static final int BITSTREAM_LAST = 511;

    public Bitstream(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("in");
        }
        inputStream = new BufferedInputStream(inputStream);
        this.loadID3v2(inputStream);
        this.firstframe = true;
        this.source = new PushbackInputStream(inputStream, 1732);
        this.closeFrame();
    }

    public final int header_pos() {
        return this.header_pos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadID3v2(InputStream inputStream) {
        int n2;
        block11: {
            n2 = -1;
            try {
                inputStream.mark(10);
                this.header_pos = n2 = this.readID3v2Header(inputStream);
            }
            catch (IOException iOException) {
                try {
                    inputStream.reset();
                }
                catch (IOException iOException2) {}
                break block11;
            }
            catch (Throwable throwable) {
                try {
                    inputStream.reset();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.reset();
            }
            catch (IOException iOException) {}
        }
        try {
            if (n2 <= 0) return;
            this.rawid3v2 = new byte[n2];
            inputStream.read(this.rawid3v2, 0, this.rawid3v2.length);
            Bitstream bitstream = this;
            bitstream.parseID3v2Frames(bitstream.rawid3v2);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private int readID3v2Header(InputStream inputStream) {
        byte[] byArray = new byte[4];
        int n2 = -10;
        inputStream.read(byArray, 0, 3);
        if (byArray[0] == 73 && byArray[1] == 68 && byArray[2] == 51) {
            inputStream.read(byArray, 0, 3);
            inputStream.read(byArray, 0, 4);
            n2 = (byArray[0] << 21) + (byArray[1] << 14) + (byArray[2] << 7) + byArray[3];
        }
        return n2 + 10;
    }

    public final InputStream getRawID3v2() {
        if (this.rawid3v2 == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.rawid3v2);
        return byteArrayInputStream;
    }

    private void parseID3v2Frames(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        if (!"ID3".equals(new String(byArray, 0, 3))) {
            return;
        }
        int n2 = byArray[3] & 0xFF;
        if (n2 < 2 || n2 > 4) {
            return;
        }
        try {
            int n3;
            Float f2 = null;
            Float f3 = null;
            for (int i2 = 10; i2 < byArray.length && byArray[i2] > 0; i2 += n3) {
                String string;
                Object object;
                if (n2 == 3 || n2 == 4) {
                    object = new String(byArray, i2, 4);
                    n3 = byArray[i2 + 4] << 24 & 0xFF000000 | byArray[i2 + 5] << 16 & 0xFF0000 | byArray[i2 + 6] << 8 & 0xFF00 | byArray[i2 + 7] & 0xFF;
                    i2 += 10;
                    if (!((String)object).equals("TXXX")) continue;
                    object = this.parseText(byArray, i2, n3, 1);
                    if (((String[])(object = ((String)object).split("\u0000"))).length != 2) continue;
                    string = object[0];
                    object = object[1];
                    if (string.equals("replaygain_track_peak")) {
                        f3 = Float.valueOf(Float.parseFloat((String)object));
                        if (f2 == null) continue;
                        break;
                    }
                    if (!string.equals("replaygain_track_gain")) continue;
                    f2 = Float.valueOf(Float.parseFloat(((String)object).replace(" dB", "")) + 3.0f);
                    if (f3 != null) break;
                    continue;
                }
                object = new String(byArray, i2, 3);
                n3 = 0 + (byArray[i2 + 3] << 16) + (byArray[i2 + 4] << 8) + byArray[i2 + 5];
                i2 += 6;
                if (!((String)object).equals("TXXX")) continue;
                object = this.parseText(byArray, i2, n3, 1);
                if (((String[])(object = ((String)object).split("\u0000"))).length != 2) continue;
                string = object[0];
                object = object[1];
                if (string.equals("replaygain_track_peak")) {
                    f3 = Float.valueOf(Float.parseFloat((String)object));
                    if (f2 == null) continue;
                    break;
                }
                if (!string.equals("replaygain_track_gain")) continue;
                f2 = Float.valueOf(Float.parseFloat(((String)object).replace(" dB", "")) + 3.0f);
                if (f3 != null) break;
            }
            if (f2 != null && f3 != null) {
                this.replayGainScale = Float.valueOf((float)Math.pow(10.0, f2.floatValue() / 20.0f));
                this.replayGainScale = Float.valueOf(Math.min(1.0f / f3.floatValue(), this.replayGainScale.floatValue()));
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            return;
        }
    }

    private String parseText(byte[] byArray, int n2, int n3, int n4) {
        String string = null;
        try {
            String[] stringArray = new String[]{"ISO-8859-1", "UTF16", "UTF-16BE", "UTF-8"};
            string = new String(byArray, n2 + n4, n3 - n4, stringArray[byArray[n2]]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return string;
    }

    public final Float getReplayGainScale() {
        return this.replayGainScale;
    }

    public final void close() {
        try {
            this.source.close();
            return;
        }
        catch (IOException iOException) {
            throw this.newBitstreamException(258, iOException);
        }
    }

    public final Header readFrame() {
        Header header;
        block7: {
            header = null;
            try {
                header = this.readNextFrame();
                if (this.firstframe) {
                    header.parseVBR(this.frame_bytes);
                    this.firstframe = false;
                }
            }
            catch (BitstreamException bitstreamException) {
                BitstreamException bitstreamException2 = bitstreamException;
                if (bitstreamException.getErrorCode() == 261) {
                    try {
                        this.closeFrame();
                        header = this.readNextFrame();
                    }
                    catch (BitstreamException bitstreamException3) {
                        bitstreamException2 = bitstreamException3;
                        if (bitstreamException3.getErrorCode() != 260) {
                            throw this.newBitstreamException(bitstreamException2.getErrorCode(), bitstreamException2);
                        }
                        break block7;
                    }
                }
                if (bitstreamException2.getErrorCode() == 260) break block7;
                throw this.newBitstreamException(bitstreamException2.getErrorCode(), bitstreamException2);
            }
        }
        return header;
    }

    private Header readNextFrame() {
        if (this.framesize == -1) {
            this.nextFrame();
        }
        return this.header;
    }

    private void nextFrame() {
        Bitstream bitstream = this;
        this.header.read_header(bitstream, bitstream.crc);
    }

    public final void unreadFrame() {
        if (this.wordpointer == -1 && this.bitindex == -1 && this.framesize > 0) {
            try {
                this.source.unread(this.frame_bytes, 0, this.framesize);
                return;
            }
            catch (IOException iOException) {
                throw this.newBitstreamException(258);
            }
        }
    }

    public final void closeFrame() {
        this.framesize = -1;
        this.wordpointer = -1;
        this.bitindex = -1;
    }

    public final boolean isSyncCurrentPosition(int n2) {
        Bitstream bitstream = this;
        int n3 = bitstream.readBytes(bitstream.syncbuf, 0, 4);
        int n4 = this.syncbuf[0] << 24 & 0xFF000000 | this.syncbuf[1] << 16 & 0xFF0000 | this.syncbuf[2] << 8 & 0xFF00 | this.syncbuf[3] & 0xFF;
        try {
            this.source.unread(this.syncbuf, 0, n3);
        }
        catch (IOException iOException) {}
        boolean bl = false;
        switch (n3) {
            case 0: {
                bl = true;
                break;
            }
            case 4: {
                bl = this.isSyncMark(n4, n2, this.syncword);
            }
        }
        return bl;
    }

    public final int readBits(int n2) {
        return this.get_bits(n2);
    }

    public final int readCheckedBits(int n2) {
        return this.get_bits(n2);
    }

    protected final BitstreamException newBitstreamException(int n2) {
        return new BitstreamException(n2, null);
    }

    protected final BitstreamException newBitstreamException(int n2, Throwable throwable) {
        return new BitstreamException(n2, throwable);
    }

    final int syncHeader(byte by) {
        boolean bl;
        Bitstream bitstream = this;
        int n2 = bitstream.readBytes(bitstream.syncbuf, 0, 3);
        if (n2 != 3) {
            throw this.newBitstreamException(260, null);
        }
        int n3 = this.syncbuf[0] << 16 & 0xFF0000 | this.syncbuf[1] << 8 & 0xFF00 | this.syncbuf[2] & 0xFF;
        do {
            n3 <<= 8;
            Bitstream bitstream2 = this;
            if (bitstream2.readBytes(bitstream2.syncbuf, 3, 1) != 1) {
                throw this.newBitstreamException(260, null);
            }
            bl = this.isSyncMark(n3 |= this.syncbuf[3] & 0xFF, by, this.syncword);
            n2 = bl ? 1 : 0;
        } while (!bl);
        return n3;
    }

    public final boolean isSyncMark(int n2, int n3, int n4) {
        if (n3 == INITIAL_SYNC) {
            n3 = (n2 & 0xFFE00000) == -2097152 ? 1 : 0;
        } else {
            int n5 = (n2 & 0xFFF80C00) == n4 && (n2 & 0xC0) == 192 == this.single_ch_mode ? 1 : (n3 = 0);
        }
        if (n3 != 0) {
            int n6 = n3 = (n2 >>> 10 & 3) != 3 ? 1 : 0;
        }
        if (n3 != 0) {
            int n7 = n3 = (n2 >>> 17 & 3) != 0 ? 1 : 0;
        }
        if (n3 != 0) {
            n3 = (n2 >>> 19 & 3) != 1 ? 1 : 0;
        }
        return n3 != 0;
    }

    final int read_frame_data(int n2) {
        Bitstream bitstream = this;
        int n3 = bitstream.readFully(bitstream.frame_bytes, 0, n2);
        this.framesize = n2;
        this.wordpointer = -1;
        this.bitindex = -1;
        return n3;
    }

    final void parse_frame() {
        int n2 = 0;
        byte[] byArray = this.frame_bytes;
        int n3 = this.framesize;
        for (int i2 = 0; i2 < n3; i2 += 4) {
            byte by = 0;
            byte by2 = 0;
            byte by3 = 0;
            byte by4 = byArray[i2];
            if (i2 + 1 < n3) {
                by = byArray[i2 + 1];
            }
            if (i2 + 2 < n3) {
                by2 = byArray[i2 + 2];
            }
            if (i2 + 3 < n3) {
                by3 = byArray[i2 + 3];
            }
            this.framebuffer[n2++] = by4 << 24 & 0xFF000000 | by << 16 & 0xFF0000 | by2 << 8 & 0xFF00 | by3 & 0xFF;
        }
        this.wordpointer = 0;
        this.bitindex = 0;
    }

    public final int get_bits(int n2) {
        int n3 = this.bitindex + n2;
        if (this.wordpointer < 0) {
            this.wordpointer = 0;
        }
        if (n3 <= 32) {
            int n4 = this.framebuffer[this.wordpointer] >>> 32 - n3 & this.bitmask[n2];
            if ((this.bitindex += n2) == 32) {
                this.bitindex = 0;
                ++this.wordpointer;
            }
            return n4;
        }
        int n5 = this.framebuffer[this.wordpointer] & 0xFFFF;
        ++this.wordpointer;
        int n6 = this.framebuffer[this.wordpointer] & 0xFFFF0000;
        n5 = n5 << 16 & 0xFFFF0000 | n6 >>> 16 & 0xFFFF;
        n5 >>>= 48 - n3;
        this.bitindex = n3 - 32;
        return n5 &= this.bitmask[n2];
    }

    final void set_syncword(int n2) {
        this.syncword = n2 & 0xFFFFFF3F;
        this.single_ch_mode = (n2 & 0xC0) == 192;
    }

    private int readFully(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        try {
            while (n3 > 0) {
                int n5 = this.source.read(byArray, n2, n3);
                if (n5 == -1) {
                    while (n3-- > 0) {
                        byArray[n2++] = 0;
                    }
                    break;
                }
                n4 += n5;
                n2 += n5;
                n3 -= n5;
            }
        }
        catch (IOException iOException) {
            throw this.newBitstreamException(258, iOException);
        }
        return n4;
    }

    private int readBytes(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        try {
            int n5;
            while (n3 > 0 && (n5 = this.source.read(byArray, n2, n3)) != -1) {
                n4 += n5;
                n2 += n5;
                n3 -= n5;
            }
        }
        catch (IOException iOException) {
            throw this.newBitstreamException(258, iOException);
        }
        return n4;
    }
}

