/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Crc16;

public final class Header {
    public static final int[][] frequencies = new int[][]{{22050, 24000, 16000, 1}, {44100, 48000, 32000, 1}, {11025, 12000, 8000, 1}};
    public static final int MPEG2_LSF = 0;
    public static final int MPEG25_LSF = 2;
    public static final int MPEG1 = 1;
    public static final int STEREO = 0;
    public static final int JOINT_STEREO = 1;
    public static final int DUAL_CHANNEL = 2;
    public static final int SINGLE_CHANNEL = 3;
    public static final int FOURTYFOUR_POINT_ONE = 0;
    public static final int FOURTYEIGHT = 1;
    public static final int THIRTYTWO = 2;
    private int h_layer;
    private int h_protection_bit;
    private int h_bitrate_index;
    private int h_padding_bit;
    private int h_mode_extension;
    private int h_version;
    private int h_mode;
    private int h_sample_frequency;
    private int h_number_of_subbands;
    private int h_intensity_stereo_bound;
    private boolean h_copyright;
    private boolean h_original;
    private double[] h_vbr_time_per_frame = new double[]{-1.0, 384.0, 1152.0, 1152.0};
    private boolean h_vbr;
    private int h_vbr_frames;
    private int h_vbr_scale;
    private int h_vbr_bytes;
    private byte[] h_vbr_toc;
    private byte syncmode = Bitstream.INITIAL_SYNC;
    private Crc16 crc;
    public short checksum;
    public int framesize;
    public int nSlots;
    private int _headerstring = -1;
    private static final int[][][] bitrates = new int[][][]{new int[][]{{0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 176000, 192000, 224000, 256000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}}, new int[][]{{0, 32000, 64000, 96000, 128000, 160000, 192000, 224000, 256000, 288000, 320000, 352000, 384000, 416000, 448000, 0}, {0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000, 0}, {0, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 0}}, new int[][]{{0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 176000, 192000, 224000, 256000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}, {0, 8000, 16000, 24000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 144000, 160000, 0}}};
    private static final String[][][] bitrate_str = new String[][][]{{{"free format", "32 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "176 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "forbidden"}, {"free format", "8 kbit/s", "16 kbit/s", "24 kbit/s", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "forbidden"}, {"free format", "8 kbit/s", "16 kbit/s", "24 kbit/s", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "forbidden"}}, {{"free format", "32 kbit/s", "64 kbit/s", "96 kbit/s", "128 kbit/s", "160 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "288 kbit/s", "320 kbit/s", "352 kbit/s", "384 kbit/s", "416 kbit/s", "448 kbit/s", "forbidden"}, {"free format", "32 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "160 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "320 kbit/s", "384 kbit/s", "forbidden"}, {"free format", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "160 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "320 kbit/s", "forbidden"}}, {{"free format", "32 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "176 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "forbidden"}, {"free format", "8 kbit/s", "16 kbit/s", "24 kbit/s", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "forbidden"}, {"free format", "8 kbit/s", "16 kbit/s", "24 kbit/s", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "forbidden"}}};

    Header() {
    }

    public final String toString() {
        CharSequence charSequence = new StringBuffer(200);
        charSequence.append("Layer ");
        charSequence.append(this.layer_string());
        charSequence.append(" frame ");
        charSequence.append(this.mode_string());
        charSequence.append(' ');
        charSequence.append(this.version_string());
        if (!this.checksums()) {
            charSequence.append(" no");
        }
        charSequence.append(" checksums");
        charSequence.append(' ');
        charSequence.append(this.sample_frequency_string());
        charSequence.append(',');
        charSequence.append(' ');
        charSequence.append(this.bitrate_string());
        charSequence = charSequence.toString();
        return charSequence;
    }

    final void read_header(Bitstream bitstream, Crc16[] crc16Array) {
        int n2;
        boolean bl = false;
        do {
            int n3;
            this._headerstring = n2 = bitstream.syncHeader(this.syncmode);
            if (this.syncmode == Bitstream.INITIAL_SYNC) {
                this.h_version = n2 >>> 19 & 1;
                if ((n2 >>> 20 & 1) == 0) {
                    if (this.h_version == 0) {
                        this.h_version = 2;
                    } else {
                        throw bitstream.newBitstreamException(256);
                    }
                }
                if ((this.h_sample_frequency = n2 >>> 10 & 3) == 3) {
                    throw bitstream.newBitstreamException(256);
                }
            }
            this.h_layer = 4 - (n2 >>> 17) & 3;
            this.h_protection_bit = n2 >>> 16 & 1;
            this.h_bitrate_index = n2 >>> 12 & 0xF;
            this.h_padding_bit = n2 >>> 9 & 1;
            this.h_mode = n2 >>> 6 & 3;
            this.h_mode_extension = n2 >>> 4 & 3;
            this.h_intensity_stereo_bound = this.h_mode == 1 ? (this.h_mode_extension << 2) + 4 : 0;
            if ((n2 >>> 3 & 1) == 1) {
                this.h_copyright = true;
            }
            if ((n2 >>> 2 & 1) == 1) {
                this.h_original = true;
            }
            if (this.h_layer == 1) {
                this.h_number_of_subbands = 32;
            } else {
                n3 = this.h_bitrate_index;
                if (this.h_mode != 3) {
                    n3 = n3 == 4 ? 1 : (n3 -= 4);
                }
                this.h_number_of_subbands = n3 == 1 || n3 == 2 ? (this.h_sample_frequency == 2 ? 12 : 8) : (this.h_sample_frequency == 1 || n3 >= 3 && n3 <= 5 ? 27 : 30);
            }
            if (this.h_intensity_stereo_bound > this.h_number_of_subbands) {
                this.h_intensity_stereo_bound = this.h_number_of_subbands;
            }
            this.calculate_framesize();
            n3 = bitstream.read_frame_data(this.framesize);
            if (this.framesize >= 0 && n3 != this.framesize) {
                throw bitstream.newBitstreamException(261);
            }
            if (bitstream.isSyncCurrentPosition(this.syncmode)) {
                if (this.syncmode == Bitstream.INITIAL_SYNC) {
                    this.syncmode = Bitstream.STRICT_SYNC;
                    bitstream.set_syncword(n2 & 0xFFF80CC0);
                }
                bl = true;
                continue;
            }
            bitstream.unreadFrame();
        } while (!bl);
        bitstream.parse_frame();
        if (this.h_protection_bit == 0) {
            this.checksum = (short)bitstream.get_bits(16);
            if (this.crc == null) {
                this.crc = new Crc16();
            }
            this.crc.add_bits(n2, 16);
            crc16Array[0] = this.crc;
        } else {
            crc16Array[0] = null;
        }
    }

    final void parseVBR(byte[] byArray) {
        String string = "Xing";
        byte[] byArray2 = new byte[4];
        int n2 = this.h_version == 1 ? (this.h_mode == 3 ? 17 : 32) : (this.h_mode == 3 ? 9 : 17);
        try {
            System.arraycopy(byArray, n2, byArray2, 0, 4);
            if (string.equals(new String(byArray2))) {
                this.h_vbr = true;
                this.h_vbr_frames = -1;
                this.h_vbr_bytes = -1;
                this.h_vbr_scale = -1;
                this.h_vbr_toc = new byte[100];
                byte[] byArray3 = new byte[4];
                System.arraycopy(byArray, n2 + 4, byArray3, 0, byArray3.length);
                int cfr_ignored_0 = byArray3.length;
                int n3 = 8;
                if ((byArray3[3] & 1) != 0) {
                    System.arraycopy(byArray, n2 + 8, byArray2, 0, byArray2.length);
                    this.h_vbr_frames = byArray2[0] << 24 & 0xFF000000 | byArray2[1] << 16 & 0xFF0000 | byArray2[2] << 8 & 0xFF00 | byArray2[3] & 0xFF;
                    n3 += 4;
                }
                if ((byArray3[3] & 2) != 0) {
                    System.arraycopy(byArray, n2 + n3, byArray2, 0, byArray2.length);
                    this.h_vbr_bytes = byArray2[0] << 24 & 0xFF000000 | byArray2[1] << 16 & 0xFF0000 | byArray2[2] << 8 & 0xFF00 | byArray2[3] & 0xFF;
                    n3 += 4;
                }
                if ((byArray3[3] & 4) != 0) {
                    System.arraycopy(byArray, n2 + n3, this.h_vbr_toc, 0, this.h_vbr_toc.length);
                    n3 += this.h_vbr_toc.length;
                }
                if ((byArray3[3] & 8) != 0) {
                    System.arraycopy(byArray, n2 + n3, byArray2, 0, byArray2.length);
                    this.h_vbr_scale = byArray2[0] << 24 & 0xFF000000 | byArray2[1] << 16 & 0xFF0000 | byArray2[2] << 8 & 0xFF00 | byArray2[3] & 0xFF;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BitstreamException("XingVBRHeader Corrupted", (Throwable)arrayIndexOutOfBoundsException);
        }
        String string2 = "VBRI";
        try {
            System.arraycopy(byArray, 32, byArray2, 0, 4);
            if (string2.equals(new String(byArray2))) {
                this.h_vbr = true;
                this.h_vbr_frames = -1;
                this.h_vbr_bytes = -1;
                this.h_vbr_scale = -1;
                this.h_vbr_toc = new byte[100];
                System.arraycopy(byArray, 42, byArray2, 0, byArray2.length);
                this.h_vbr_bytes = byArray2[0] << 24 & 0xFF000000 | byArray2[1] << 16 & 0xFF0000 | byArray2[2] << 8 & 0xFF00 | byArray2[3] & 0xFF;
                System.arraycopy(byArray, 46, byArray2, 0, byArray2.length);
                this.h_vbr_frames = byArray2[0] << 24 & 0xFF000000 | byArray2[1] << 16 & 0xFF0000 | byArray2[2] << 8 & 0xFF00 | byArray2[3] & 0xFF;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BitstreamException("VBRIVBRHeader Corrupted", (Throwable)arrayIndexOutOfBoundsException);
        }
    }

    public final int version() {
        return this.h_version;
    }

    public final int layer() {
        return this.h_layer;
    }

    public final int bitrate_index() {
        return this.h_bitrate_index;
    }

    public final int sample_frequency() {
        return this.h_sample_frequency;
    }

    public final int frequency() {
        return frequencies[this.h_version][this.h_sample_frequency];
    }

    public final int mode() {
        return this.h_mode;
    }

    public final boolean checksums() {
        return this.h_protection_bit == 0;
    }

    public final boolean copyright() {
        return this.h_copyright;
    }

    public final boolean original() {
        return this.h_original;
    }

    public final boolean vbr() {
        return this.h_vbr;
    }

    public final int vbr_scale() {
        return this.h_vbr_scale;
    }

    public final byte[] vbr_toc() {
        return this.h_vbr_toc;
    }

    public final boolean checksum_ok() {
        return this.checksum == this.crc.checksum();
    }

    public final boolean padding() {
        return this.h_padding_bit != 0;
    }

    public final int slots() {
        return this.nSlots;
    }

    public final int mode_extension() {
        return this.h_mode_extension;
    }

    /*
     * Unable to fully structure code
     */
    public final int calculate_framesize() {
        block5: {
            if (this.h_layer != 1) break block5;
            this.framesize = 12 * Header.bitrates[this.h_version][0][this.h_bitrate_index] / Header.frequencies[this.h_version][this.h_sample_frequency];
            if (this.h_padding_bit != 0) {
                ++this.framesize;
            }
            this.framesize <<= 2;
            ** GOTO lbl-1000
        }
        this.framesize = 144 * Header.bitrates[this.h_version][this.h_layer - 1][this.h_bitrate_index] / Header.frequencies[this.h_version][this.h_sample_frequency];
        if (this.h_version == 0 || this.h_version == 2) {
            this.framesize >>= 1;
        }
        if (this.h_padding_bit != 0) {
            ++this.framesize;
        }
        if (this.h_layer == 3) {
            this.nSlots = this.h_version == 1 ? this.framesize - (this.h_mode == 3 ? 17 : 32) - (this.h_protection_bit != 0 ? 0 : 2) - 4 : this.framesize - (this.h_mode == 3 ? 9 : 17) - (this.h_protection_bit != 0 ? 0 : 2) - 4;
        } else lbl-1000:
        // 2 sources

        {
            this.nSlots = 0;
        }
        this.framesize -= 4;
        return this.framesize;
    }

    public final int max_number_of_frames(int n2) {
        if (this.h_vbr) {
            return this.h_vbr_frames;
        }
        if (this.framesize + 4 - this.h_padding_bit == 0) {
            return 0;
        }
        return n2 / (this.framesize + 4 - this.h_padding_bit);
    }

    public final int min_number_of_frames(int n2) {
        if (this.h_vbr) {
            return this.h_vbr_frames;
        }
        if (this.framesize + 5 - this.h_padding_bit == 0) {
            return 0;
        }
        return n2 / (this.framesize + 5 - this.h_padding_bit);
    }

    public final float ms_per_frame() {
        if (this.h_vbr) {
            double d2 = this.h_vbr_time_per_frame[this.layer()] / (double)this.frequency();
            if (this.h_version == 0 || this.h_version == 2) {
                d2 /= 2.0;
            }
            return (float)(d2 * 1000.0);
        }
        float[][] fArrayArray = new float[][]{{8.707483f, 8.0f, 12.0f}, {26.12245f, 24.0f, 36.0f}, {26.12245f, 24.0f, 36.0f}};
        return fArrayArray[this.h_layer - 1][this.h_sample_frequency];
    }

    public final float total_ms(int n2) {
        return (float)this.max_number_of_frames(n2) * this.ms_per_frame();
    }

    public final int getSyncHeader() {
        return this._headerstring;
    }

    public final String layer_string() {
        switch (this.h_layer) {
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
        }
        return null;
    }

    public final String bitrate_string() {
        if (this.h_vbr) {
            return Integer.toString(this.bitrate() / 1000) + " kb/s";
        }
        return bitrate_str[this.h_version][this.h_layer - 1][this.h_bitrate_index];
    }

    public final int bitrate() {
        if (this.h_vbr) {
            return (int)((float)(this.h_vbr_bytes << 3) / (this.ms_per_frame() * (float)this.h_vbr_frames)) * 1000;
        }
        return bitrates[this.h_version][this.h_layer - 1][this.h_bitrate_index];
    }

    public final int bitrate_instant() {
        return bitrates[this.h_version][this.h_layer - 1][this.h_bitrate_index];
    }

    public final String sample_frequency_string() {
        switch (this.h_sample_frequency) {
            case 2: {
                if (this.h_version == 1) {
                    return "32 kHz";
                }
                if (this.h_version == 0) {
                    return "16 kHz";
                }
                return "8 kHz";
            }
            case 0: {
                if (this.h_version == 1) {
                    return "44.1 kHz";
                }
                if (this.h_version == 0) {
                    return "22.05 kHz";
                }
                return "11.025 kHz";
            }
            case 1: {
                if (this.h_version == 1) {
                    return "48 kHz";
                }
                if (this.h_version == 0) {
                    return "24 kHz";
                }
                return "12 kHz";
            }
        }
        return null;
    }

    public final int getSampleRate() {
        switch (this.h_sample_frequency) {
            case 2: {
                if (this.h_version == 1) {
                    return 32000;
                }
                if (this.h_version == 0) {
                    return 16000;
                }
                return 8000;
            }
            case 0: {
                if (this.h_version == 1) {
                    return 44100;
                }
                if (this.h_version == 0) {
                    return 22050;
                }
                return 11025;
            }
            case 1: {
                if (this.h_version == 1) {
                    return 48000;
                }
                if (this.h_version == 0) {
                    return 24000;
                }
                return 12000;
            }
        }
        return 0;
    }

    public final String mode_string() {
        switch (this.h_mode) {
            case 0: {
                return "Stereo";
            }
            case 1: {
                return "Joint stereo";
            }
            case 2: {
                return "Dual channel";
            }
            case 3: {
                return "Single channel";
            }
        }
        return null;
    }

    public final String version_string() {
        switch (this.h_version) {
            case 1: {
                return "MPEG-1";
            }
            case 0: {
                return "MPEG-2 LSF";
            }
            case 2: {
                return "MPEG-2.5 LSF";
            }
        }
        return null;
    }

    public final int number_of_subbands() {
        return this.h_number_of_subbands;
    }

    public final int intensity_stereo_bound() {
        return this.h_intensity_stereo_bound;
    }
}

