/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Crc16;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.LayerIDecoder;
import javazoom.jl.decoder.LayerIDecoder$Subband;
import javazoom.jl.decoder.SynthesisFilter;

class LayerIDecoder$SubbandLayer1
extends LayerIDecoder$Subband {
    public static final float[] table_factor = new float[]{0.0f, 0.6666667f, 0.2857143f, 0.13333334f, 0.06451613f, 0.031746034f, 0.015748031f, 0.007843138f, 0.0039138943f, 0.0019550342f, 9.770396E-4f, 4.884005E-4f, 2.4417043E-4f, 1.2207776E-4f, 6.103702E-5f};
    public static final float[] table_offset = new float[]{0.0f, -0.6666667f, -0.85714287f, -0.93333334f, -0.9677419f, -0.984127f, -0.992126f, -0.99607843f, -0.99804306f, -0.9990225f, -0.9995115f, -0.9997558f, -0.9998779f, -0.99993896f, -0.9999695f};
    protected int subbandnumber;
    protected int samplenumber;
    protected int allocation;
    protected float scalefactor;
    protected int samplelength;
    protected float sample;
    protected float factor;
    protected float offset;

    public LayerIDecoder$SubbandLayer1(int n2) {
        this.subbandnumber = n2;
        this.samplenumber = 0;
    }

    @Override
    public void read_allocation(Bitstream bitstream, Header header, Crc16 crc16) {
        this.allocation = bitstream.get_bits(4);
        if (this.allocation == 15) {
            throw new DecoderException(514, null);
        }
        if (crc16 != null) {
            crc16.add_bits(this.allocation, 4);
        }
        if (this.allocation != 0) {
            this.samplelength = this.allocation + 1;
            this.factor = table_factor[this.allocation];
            this.offset = table_offset[this.allocation];
        }
    }

    @Override
    public void read_scalefactor(Bitstream bitstream, Header header) {
        if (this.allocation != 0) {
            this.scalefactor = LayerIDecoder.scalefactors[bitstream.get_bits(6)];
        }
    }

    @Override
    public boolean read_sampledata(Bitstream bitstream) {
        if (this.allocation != 0) {
            this.sample = bitstream.get_bits(this.samplelength);
        }
        if (++this.samplenumber == 12) {
            this.samplenumber = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean put_next_sample(int n2, SynthesisFilter synthesisFilter, SynthesisFilter synthesisFilter2) {
        if (this.allocation != 0 && n2 != 2) {
            float f2 = (this.sample * this.factor + this.offset) * this.scalefactor;
            synthesisFilter.input_sample(f2, this.subbandnumber);
        }
        return true;
    }
}

