/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Crc16;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.LayerIDecoder;
import javazoom.jl.decoder.LayerIDecoder$SubbandLayer1;
import javazoom.jl.decoder.SynthesisFilter;

class LayerIDecoder$SubbandLayer1Stereo
extends LayerIDecoder$SubbandLayer1 {
    protected int channel2_allocation;
    protected float channel2_scalefactor;
    protected int channel2_samplelength;
    protected float channel2_sample;
    protected float channel2_factor;
    protected float channel2_offset;

    public LayerIDecoder$SubbandLayer1Stereo(int n2) {
        super(n2);
    }

    @Override
    public void read_allocation(Bitstream bitstream, Header header, Crc16 crc16) {
        this.allocation = bitstream.get_bits(4);
        this.channel2_allocation = bitstream.get_bits(4);
        if (crc16 != null) {
            crc16.add_bits(this.allocation, 4);
            crc16.add_bits(this.channel2_allocation, 4);
        }
        if (this.allocation != 0) {
            this.samplelength = this.allocation + 1;
            this.factor = table_factor[this.allocation];
            this.offset = table_offset[this.allocation];
        }
        if (this.channel2_allocation != 0) {
            this.channel2_samplelength = this.channel2_allocation + 1;
            this.channel2_factor = table_factor[this.channel2_allocation];
            this.channel2_offset = table_offset[this.channel2_allocation];
        }
    }

    @Override
    public void read_scalefactor(Bitstream bitstream, Header header) {
        if (this.allocation != 0) {
            this.scalefactor = LayerIDecoder.scalefactors[bitstream.get_bits(6)];
        }
        if (this.channel2_allocation != 0) {
            this.channel2_scalefactor = LayerIDecoder.scalefactors[bitstream.get_bits(6)];
        }
    }

    @Override
    public boolean read_sampledata(Bitstream bitstream) {
        boolean bl = super.read_sampledata(bitstream);
        if (this.channel2_allocation != 0) {
            this.channel2_sample = bitstream.get_bits(this.channel2_samplelength);
        }
        return bl;
    }

    @Override
    public boolean put_next_sample(int n2, SynthesisFilter synthesisFilter, SynthesisFilter synthesisFilter2) {
        super.put_next_sample(n2, synthesisFilter, synthesisFilter2);
        if (this.channel2_allocation != 0 && n2 != 1) {
            float f2 = (this.channel2_sample * this.channel2_factor + this.channel2_offset) * this.channel2_scalefactor;
            if (n2 == 0) {
                synthesisFilter2.input_sample(f2, this.subbandnumber);
            } else {
                synthesisFilter.input_sample(f2, this.subbandnumber);
            }
        }
        return true;
    }
}

