/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Crc16;
import javazoom.jl.decoder.FrameDecoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.LayerIDecoder$Subband;
import javazoom.jl.decoder.LayerIDecoder$SubbandLayer1;
import javazoom.jl.decoder.LayerIDecoder$SubbandLayer1IntensityStereo;
import javazoom.jl.decoder.LayerIDecoder$SubbandLayer1Stereo;
import javazoom.jl.decoder.OutputBuffer;
import javazoom.jl.decoder.SynthesisFilter;

public class LayerIDecoder
implements FrameDecoder {
    protected Bitstream stream;
    protected Header header;
    protected SynthesisFilter filter1;
    protected SynthesisFilter filter2;
    protected OutputBuffer buffer;
    protected int which_channels;
    protected int mode;
    protected int num_subbands;
    protected LayerIDecoder$Subband[] subbands;
    protected Crc16 crc = new Crc16();
    static final float[] scalefactors = new float[]{2.0f, 1.587401f, 1.2599211f, 1.0f, 0.7937005f, 0.62996054f, 0.5f, 0.39685026f, 0.31498027f, 0.25f, 0.19842513f, 0.15749013f, 0.125f, 0.099212565f, 0.07874507f, 0.0625f, 0.049606282f, 0.039372534f, 0.03125f, 0.024803141f, 0.019686267f, 0.015625f, 0.012401571f, 0.009843133f, 0.0078125f, 0.0062007853f, 0.0049215667f, 0.00390625f, 0.0031003926f, 0.0024607833f, 0.001953125f, 0.0015501963f, 0.0012303917f, 9.765625E-4f, 7.7509816E-4f, 6.1519584E-4f, 4.8828125E-4f, 3.8754908E-4f, 3.0759792E-4f, 2.4414062E-4f, 1.9377454E-4f, 1.5379896E-4f, 1.2207031E-4f, 9.688727E-5f, 7.689948E-5f, 6.1035156E-5f, 4.8443635E-5f, 3.844974E-5f, 3.0517578E-5f, 2.4221818E-5f, 1.922487E-5f, 1.5258789E-5f, 1.2110909E-5f, 9.612435E-6f, 7.6293945E-6f, 6.0554544E-6f, 4.8062175E-6f, 3.8146973E-6f, 3.0277272E-6f, 2.4031087E-6f, 1.9073486E-6f, 1.5138636E-6f, 1.2015544E-6f, 0.0f};

    public void create(Bitstream bitstream, Header header, SynthesisFilter synthesisFilter, SynthesisFilter synthesisFilter2, OutputBuffer outputBuffer, int n2) {
        this.stream = bitstream;
        this.header = header;
        this.filter1 = synthesisFilter;
        this.filter2 = synthesisFilter2;
        this.buffer = outputBuffer;
        this.which_channels = n2;
    }

    @Override
    public void decodeFrame() {
        this.num_subbands = this.header.number_of_subbands();
        this.subbands = new LayerIDecoder$Subband[32];
        this.mode = this.header.mode();
        this.createSubbands();
        this.readAllocation();
        this.readScaleFactorSelection();
        if (this.crc != null || this.header.checksum_ok()) {
            this.readScaleFactors();
            this.readSampleData();
        }
    }

    protected void createSubbands() {
        if (this.mode == 3) {
            for (int i2 = 0; i2 < this.num_subbands; ++i2) {
                this.subbands[i2] = new LayerIDecoder$SubbandLayer1(i2);
            }
        } else if (this.mode == 1) {
            int n2;
            for (n2 = 0; n2 < this.header.intensity_stereo_bound(); ++n2) {
                this.subbands[n2] = new LayerIDecoder$SubbandLayer1Stereo(n2);
            }
            while (n2 < this.num_subbands) {
                this.subbands[n2] = new LayerIDecoder$SubbandLayer1IntensityStereo(n2);
                ++n2;
            }
        } else {
            for (int i3 = 0; i3 < this.num_subbands; ++i3) {
                this.subbands[i3] = new LayerIDecoder$SubbandLayer1Stereo(i3);
            }
        }
    }

    protected void readAllocation() {
        for (int i2 = 0; i2 < this.num_subbands; ++i2) {
            this.subbands[i2].read_allocation(this.stream, this.header, this.crc);
        }
    }

    protected void readScaleFactorSelection() {
    }

    protected void readScaleFactors() {
        for (int i2 = 0; i2 < this.num_subbands; ++i2) {
            this.subbands[i2].read_scalefactor(this.stream, this.header);
        }
    }

    protected void readSampleData() {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = this.header.mode();
        do {
            int n3;
            for (n3 = 0; n3 < this.num_subbands; ++n3) {
                bl = this.subbands[n3].read_sampledata(this.stream);
            }
            do {
                for (n3 = 0; n3 < this.num_subbands; ++n3) {
                    bl2 = this.subbands[n3].put_next_sample(this.which_channels, this.filter1, this.filter2);
                }
                this.filter1.calculate_pcm_samples(this.buffer);
                if (this.which_channels != 0 || n2 == 3) continue;
                this.filter2.calculate_pcm_samples(this.buffer);
            } while (!bl2);
        } while (!bl);
    }
}

