/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Crc16;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.LayerIDecoder;
import javazoom.jl.decoder.LayerIIDecoder$SubbandLayer2;
import javazoom.jl.decoder.SynthesisFilter;

class LayerIIDecoder$SubbandLayer2Stereo
extends LayerIIDecoder$SubbandLayer2 {
    protected int channel2_allocation;
    protected int channel2_scfsi;
    protected float channel2_scalefactor1;
    protected float channel2_scalefactor2;
    protected float channel2_scalefactor3;
    protected int[] channel2_codelength = new int[]{0};
    protected float[] channel2_factor = new float[]{0.0f};
    protected float[] channel2_samples;
    protected float[] channel2_c = new float[]{0.0f};
    protected float[] channel2_d = new float[]{0.0f};

    public LayerIIDecoder$SubbandLayer2Stereo(int n2) {
        super(n2);
        this.channel2_samples = new float[3];
    }

    @Override
    public void read_allocation(Bitstream bitstream, Header header, Crc16 crc16) {
        int n2 = this.get_allocationlength(header);
        this.allocation = bitstream.get_bits(n2);
        this.channel2_allocation = bitstream.get_bits(n2);
        if (crc16 != null) {
            crc16.add_bits(this.allocation, n2);
            crc16.add_bits(this.channel2_allocation, n2);
        }
    }

    @Override
    public void read_scalefactor_selection(Bitstream bitstream, Crc16 crc16) {
        if (this.allocation != 0) {
            this.scfsi = bitstream.get_bits(2);
            if (crc16 != null) {
                crc16.add_bits(this.scfsi, 2);
            }
        }
        if (this.channel2_allocation != 0) {
            this.channel2_scfsi = bitstream.get_bits(2);
            if (crc16 != null) {
                crc16.add_bits(this.channel2_scfsi, 2);
            }
        }
    }

    @Override
    public void read_scalefactor(Bitstream bitstream, Header header) {
        super.read_scalefactor(bitstream, header);
        if (this.channel2_allocation != 0) {
            switch (this.channel2_scfsi) {
                case 0: {
                    this.channel2_scalefactor1 = LayerIDecoder.scalefactors[bitstream.get_bits(6)];
                    this.channel2_scalefactor2 = LayerIDecoder.scalefactors[bitstream.get_bits(6)];
                    this.channel2_scalefactor3 = LayerIDecoder.scalefactors[bitstream.get_bits(6)];
                    break;
                }
                case 1: {
                    LayerIIDecoder$SubbandLayer2Stereo layerIIDecoder$SubbandLayer2Stereo = this;
                    layerIIDecoder$SubbandLayer2Stereo.channel2_scalefactor1 = layerIIDecoder$SubbandLayer2Stereo.channel2_scalefactor2 = LayerIDecoder.scalefactors[bitstream.get_bits(6)];
                    this.channel2_scalefactor3 = LayerIDecoder.scalefactors[bitstream.get_bits(6)];
                    break;
                }
                case 2: {
                    LayerIIDecoder$SubbandLayer2Stereo layerIIDecoder$SubbandLayer2Stereo = this;
                    layerIIDecoder$SubbandLayer2Stereo.channel2_scalefactor2 = this.channel2_scalefactor3 = LayerIDecoder.scalefactors[bitstream.get_bits(6)];
                    layerIIDecoder$SubbandLayer2Stereo.channel2_scalefactor1 = this.channel2_scalefactor3;
                    break;
                }
                case 3: {
                    this.channel2_scalefactor1 = LayerIDecoder.scalefactors[bitstream.get_bits(6)];
                    LayerIIDecoder$SubbandLayer2Stereo layerIIDecoder$SubbandLayer2Stereo = this;
                    layerIIDecoder$SubbandLayer2Stereo.channel2_scalefactor2 = layerIIDecoder$SubbandLayer2Stereo.channel2_scalefactor3 = LayerIDecoder.scalefactors[bitstream.get_bits(6)];
                }
            }
            this.prepare_sample_reading(header, this.channel2_allocation, 1, this.channel2_factor, this.channel2_codelength, this.channel2_c, this.channel2_d);
        }
    }

    @Override
    public boolean read_sampledata(Bitstream bitstream) {
        boolean bl = super.read_sampledata(bitstream);
        if (this.channel2_allocation != 0) {
            if (this.groupingtable[1] != null) {
                int n2 = bitstream.get_bits(this.channel2_codelength[0]);
                n2 += n2 << 1;
                float[] fArray = this.channel2_samples;
                float[] fArray2 = this.groupingtable[1];
                int n3 = n2;
                fArray[0] = fArray2[n2];
                fArray[1] = fArray2[++n3];
                fArray[2] = fArray2[++n3];
            } else {
                this.channel2_samples[0] = (float)((double)((float)bitstream.get_bits(this.channel2_codelength[0]) * this.channel2_factor[0]) - 1.0);
                this.channel2_samples[1] = (float)((double)((float)bitstream.get_bits(this.channel2_codelength[0]) * this.channel2_factor[0]) - 1.0);
                this.channel2_samples[2] = (float)((double)((float)bitstream.get_bits(this.channel2_codelength[0]) * this.channel2_factor[0]) - 1.0);
            }
        }
        return bl;
    }

    @Override
    public boolean put_next_sample(int n2, SynthesisFilter synthesisFilter, SynthesisFilter synthesisFilter2) {
        boolean bl = super.put_next_sample(n2, synthesisFilter, synthesisFilter2);
        if (this.channel2_allocation != 0 && n2 != 1) {
            float f2 = this.channel2_samples[this.samplenumber - 1];
            if (this.groupingtable[1] == null) {
                f2 = (f2 + this.channel2_d[0]) * this.channel2_c[0];
            }
            f2 = this.groupnumber <= 4 ? (f2 *= this.channel2_scalefactor1) : (this.groupnumber <= 8 ? (f2 *= this.channel2_scalefactor2) : (f2 *= this.channel2_scalefactor3));
            if (n2 == 0) {
                synthesisFilter2.input_sample(f2, this.subbandnumber);
            } else {
                synthesisFilter.input_sample(f2, this.subbandnumber);
            }
        }
        return bl;
    }
}

