/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.decoder;

public class OutputBuffer {
    public static final int BUFFERSIZE = 2304;
    private static final int MAXCHANNELS = 2;
    private Float replayGainScale;
    private int channels;
    private byte[] buffer;
    private int[] channelPointer;
    private boolean isBigEndian;

    public OutputBuffer(int n2, boolean bl) {
        this.channels = n2;
        this.isBigEndian = bl;
        this.buffer = new byte[n2 * 2304];
        this.channelPointer = new int[n2];
        this.reset();
    }

    private void append(int n2, short s2) {
        byte by;
        if (this.isBigEndian) {
            by = (byte)(s2 >>> 8);
            s2 = (byte)s2;
        } else {
            by = (byte)s2;
            s2 = (byte)(s2 >>> 8);
        }
        this.buffer[this.channelPointer[n2]] = by;
        this.buffer[this.channelPointer[n2] + 1] = s2;
        int n3 = n2;
        this.channelPointer[n3] = this.channelPointer[n3] + (this.channels << 1);
    }

    public void appendSamples(int n2, float[] fArray) {
        if (this.replayGainScale != null) {
            int n3 = 0;
            while (n3 < 32) {
                short s2 = this.clip(fArray[n3++] * this.replayGainScale.floatValue());
                this.append(n2, s2);
            }
            return;
        }
        int n4 = 0;
        while (n4 < 32) {
            short s3 = this.clip(fArray[n4++]);
            this.append(n2, s3);
        }
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int reset() {
        int n2;
        int n3;
        try {
            n3 = this.channels - 1;
            n3 = this.channelPointer[n3] - (n3 << 1);
            n2 = 0;
        }
        catch (Throwable throwable) {
            int n4 = 0;
            while (n4 < this.channels) {
                int n5 = n4++;
                this.channelPointer[n5] = n5 << 1;
            }
            throw throwable;
        }
        while (n2 < this.channels) {
            int n6 = n2++;
            this.channelPointer[n6] = n6 << 1;
        }
        return n3;
    }

    public void setReplayGainScale(Float f2) {
        this.replayGainScale = f2;
    }

    public boolean isStereo() {
        return this.channelPointer[1] == 2;
    }

    private final short clip(float f2) {
        if (f2 > 32767.0f) {
            return Short.MAX_VALUE;
        }
        if (f2 < -32768.0f) {
            return Short.MIN_VALUE;
        }
        return (short)f2;
    }
}

