/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.NodeFilter;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.XPath;
import org.dom4j.rule.Pattern;
import org.dom4j.tree.DefaultAttribute;
import org.dom4j.tree.DefaultCDATA;
import org.dom4j.tree.DefaultComment;
import org.dom4j.tree.DefaultDocument;
import org.dom4j.tree.DefaultDocumentType;
import org.dom4j.tree.DefaultElement;
import org.dom4j.tree.DefaultEntity;
import org.dom4j.tree.DefaultProcessingInstruction;
import org.dom4j.tree.DefaultText;
import org.dom4j.tree.QNameCache;
import org.dom4j.util.SimpleSingleton;
import org.dom4j.util.SingletonStrategy;
import org.dom4j.xpath.DefaultXPath;
import org.dom4j.xpath.XPathPattern;
import org.jaxen.VariableContext;

public class DocumentFactory
implements Serializable {
    private static SingletonStrategy<DocumentFactory> singleton = null;
    protected transient QNameCache cache;
    private Map<String, String> xpathNamespaceURIs;

    private static SingletonStrategy<DocumentFactory> createSingleton() {
        Object object;
        String string;
        try {
            string = System.getProperty("org.dom4j.factory", "org.dom4j.DocumentFactory");
        }
        catch (Exception exception) {
            string = "org.dom4j.DocumentFactory";
        }
        try {
            object = System.getProperty("org.dom4j.DocumentFactory.singleton.strategy", "org.dom4j.util.SimpleSingleton");
            object = Class.forName((String)object);
            object = (SingletonStrategy)((Class)object).newInstance();
        }
        catch (Exception exception) {
            object = new SimpleSingleton();
        }
        object.setSingletonClassName(string);
        return object;
    }

    public DocumentFactory() {
        this.init();
    }

    public static synchronized DocumentFactory getInstance() {
        if (singleton == null) {
            singleton = DocumentFactory.createSingleton();
        }
        return singleton.instance();
    }

    public Document createDocument() {
        DefaultDocument defaultDocument = new DefaultDocument();
        defaultDocument.setDocumentFactory(this);
        return defaultDocument;
    }

    public Document createDocument(String string) {
        Document document = this.createDocument();
        document.setXMLEncoding(string);
        return document;
    }

    public Document createDocument(Element element) {
        Document document = this.createDocument();
        document.setRootElement(element);
        return document;
    }

    public DocumentType createDocType(String string, String string2, String string3) {
        return new DefaultDocumentType(string, string2, string3);
    }

    public Element createElement(QName qName) {
        return new DefaultElement(qName);
    }

    public Element createElement(String string) {
        DocumentFactory documentFactory = this;
        return documentFactory.createElement(documentFactory.createQName(string));
    }

    public Element createElement(String string, String string2) {
        DocumentFactory documentFactory = this;
        return documentFactory.createElement(documentFactory.createQName(string, string2));
    }

    public Attribute createAttribute(Element element, QName qName, String string) {
        return new DefaultAttribute(qName, string);
    }

    public Attribute createAttribute(Element element, String string, String string2) {
        return this.createAttribute(element, this.createQName(string), string2);
    }

    public CDATA createCDATA(String string) {
        return new DefaultCDATA(string);
    }

    public Comment createComment(String string) {
        return new DefaultComment(string);
    }

    public Text createText(String string) {
        if (string == null) {
            string = "Adding text to an XML document must not be null";
            throw new IllegalArgumentException(string);
        }
        return new DefaultText(string);
    }

    public Entity createEntity(String string, String string2) {
        return new DefaultEntity(string, string2);
    }

    public Namespace createNamespace(String string, String string2) {
        return Namespace.get(string, string2);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) {
        return new DefaultProcessingInstruction(string, string2);
    }

    public ProcessingInstruction createProcessingInstruction(String string, Map<String, String> map) {
        return new DefaultProcessingInstruction(string, map);
    }

    public QName createQName(String string, Namespace namespace) {
        return this.cache.get(string, namespace);
    }

    public QName createQName(String string) {
        return this.cache.get(string);
    }

    public QName createQName(String string, String string2, String string3) {
        return this.cache.get(string, Namespace.get(string2, string3));
    }

    public QName createQName(String string, String string2) {
        return this.cache.get(string, string2);
    }

    public XPath createXPath(String object) {
        object = new DefaultXPath((String)object);
        if (this.xpathNamespaceURIs != null) {
            ((DefaultXPath)object).setNamespaceURIs(this.xpathNamespaceURIs);
        }
        return object;
    }

    public XPath createXPath(String object, VariableContext variableContext) {
        object = this.createXPath((String)object);
        object.setVariableContext(variableContext);
        return object;
    }

    public NodeFilter createXPathFilter(String object, VariableContext variableContext) {
        object = this.createXPath((String)object);
        object.setVariableContext(variableContext);
        return object;
    }

    public NodeFilter createXPathFilter(String string) {
        return this.createXPath(string);
    }

    public Pattern createPattern(String string) {
        return new XPathPattern(string);
    }

    public List<QName> getQNames() {
        return this.cache.getQNames();
    }

    public Map<String, String> getXPathNamespaceURIs() {
        return this.xpathNamespaceURIs;
    }

    public void setXPathNamespaceURIs(Map<String, String> map) {
        this.xpathNamespaceURIs = map;
    }

    protected static DocumentFactory createSingleton(String string) {
        try {
            Class<?> clazz = Class.forName(string, true, DocumentFactory.class.getClassLoader());
            return (DocumentFactory)clazz.newInstance();
        }
        catch (Throwable throwable) {
            System.out.println("WARNING: Cannot load DocumentFactory: " + string);
            return new DocumentFactory();
        }
    }

    protected QName intern(QName qName) {
        return this.cache.intern(qName);
    }

    protected QNameCache createQNameCache() {
        return new QNameCache(this);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.init();
    }

    protected void init() {
        this.cache = this.createQNameCache();
    }
}

