/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.dom4j.DocumentFactory;
import org.dom4j.Namespace;
import org.dom4j.tree.QNameCache;
import org.dom4j.util.SingletonStrategy;

public class QName
implements Serializable {
    private static SingletonStrategy<QNameCache> singleton = null;
    private static final String NAME_START_CHAR = "_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd";
    private static final String NAME_CHAR = "_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd-.0-9\u00b7\u0300-\u036f\u203f-\u2040";
    private static final String NCNAME = "[_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd][_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd-.0-9\u00b7\u0300-\u036f\u203f-\u2040]*";
    private static final Pattern RE_NAME = Pattern.compile("[:_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd][:_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd-.0-9\u00b7\u0300-\u036f\u203f-\u2040]*");
    private static final Pattern RE_NCNAME = Pattern.compile("[_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd][_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd-.0-9\u00b7\u0300-\u036f\u203f-\u2040]*");
    private static final Pattern RE_QNAME = Pattern.compile("(?:[_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd][_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd-.0-9\u00b7\u0300-\u036f\u203f-\u2040]*:)?[_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd][_A-Za-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd-.0-9\u00b7\u0300-\u036f\u203f-\u2040]*");
    private String name;
    private String qualifiedName;
    private transient Namespace namespace;
    private int hashCode;
    private DocumentFactory documentFactory;

    public QName(String string) {
        this(string, Namespace.NO_NAMESPACE);
    }

    public QName(String string, Namespace namespace) {
        this.name = string == null ? "" : string;
        Namespace namespace2 = this.namespace = namespace == null ? Namespace.NO_NAMESPACE : namespace;
        if (this.namespace.equals(Namespace.NO_NAMESPACE)) {
            QName.validateName(this.name);
            return;
        }
        QName.validateNCName(this.name);
    }

    public QName(String string, Namespace namespace, String string2) {
        this.name = string == null ? "" : string;
        this.qualifiedName = string2;
        this.namespace = namespace == null ? Namespace.NO_NAMESPACE : namespace;
        QName.validateNCName(this.name);
        QName.validateQName(this.qualifiedName);
    }

    public static QName get(String string) {
        return QName.getCache().get(string);
    }

    public static QName get(String string, Namespace namespace) {
        return QName.getCache().get(string, namespace);
    }

    public static QName get(String string, String string2, String string3) {
        if ((string2 == null || string2.length() == 0) && string3 == null) {
            return QName.get(string);
        }
        if (string2 == null || string2.length() == 0) {
            return QName.getCache().get(string, Namespace.get(string3));
        }
        if (string3 == null) {
            return QName.get(string);
        }
        return QName.getCache().get(string, Namespace.get(string2, string3));
    }

    public static QName get(String string, String string2) {
        if (string2 == null) {
            return QName.getCache().get(string);
        }
        return QName.getCache().get(string, string2);
    }

    public static QName get(String string, Namespace namespace, String string2) {
        return QName.getCache().get(string, namespace, string2);
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            String string = this.getNamespacePrefix();
            this.qualifiedName = string != null && string.length() > 0 ? string + ":" + this.name : this.name;
        }
        return this.qualifiedName;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getNamespacePrefix() {
        if (this.namespace == null) {
            return "";
        }
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        if (this.namespace == null) {
            return "";
        }
        return this.namespace.getURI();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.getName().hashCode() ^ this.getNamespaceURI().hashCode();
            if (this.hashCode == 0) {
                this.hashCode = 47806;
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof QName) {
            object = (QName)object;
            if (this.hashCode() == ((QName)object).hashCode()) {
                return this.getName().equals(((QName)object).getName()) && this.getNamespaceURI().equals(((QName)object).getNamespaceURI());
            }
        }
        return false;
    }

    public String toString() {
        return super.toString() + " [name: " + this.getName() + " namespace: \"" + this.getNamespace() + "\"]";
    }

    public DocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.namespace.getPrefix());
        objectOutputStream.writeObject(this.namespace.getURI());
    }

    private void readObject(ObjectInputStream object) {
        ((ObjectInputStream)object).defaultReadObject();
        String string = (String)((ObjectInputStream)object).readObject();
        object = (String)((ObjectInputStream)object).readObject();
        this.namespace = Namespace.get(string, (String)object);
    }

    private static QNameCache getCache() {
        QNameCache qNameCache = singleton.instance();
        return qNameCache;
    }

    private static void validateName(String string) {
        if (!RE_NAME.matcher(string).matches()) {
            throw new IllegalArgumentException(String.format("Illegal character in name: '%s'.", string));
        }
    }

    protected static void validateNCName(String string) {
        if (!RE_NCNAME.matcher(string).matches()) {
            throw new IllegalArgumentException(String.format("Illegal character in local name: '%s'.", string));
        }
    }

    private static void validateQName(String string) {
        if (!RE_QNAME.matcher(string).matches()) {
            throw new IllegalArgumentException(String.format("Illegal character in qualified name: '%s'.", string));
        }
    }

    static {
        try {
            String string = "org.dom4j.util.SimpleSingleton";
            Class<?> clazz = null;
            try {
                String string2 = string;
                string2 = System.getProperty("org.dom4j.QName.singleton.strategy", string2);
                clazz = Class.forName(string2);
            }
            catch (Exception exception) {
                try {
                    clazz = Class.forName(string);
                }
                catch (Exception exception2) {}
            }
            singleton = (SingletonStrategy)clazz.newInstance();
            singleton.setSingletonClassName(QNameCache.class.getName());
        }
        catch (Exception exception) {}
    }
}

