/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.bean;

import java.util.AbstractList;
import org.dom4j.Attribute;
import org.dom4j.QName;
import org.dom4j.bean.BeanAttribute;
import org.dom4j.bean.BeanElement;
import org.dom4j.bean.BeanMetaData;
import org.dom4j.tree.AbstractAttribute;
import org.dom4j.tree.AbstractElement;

public class BeanAttributeList
extends AbstractList<Attribute> {
    private BeanElement parent;
    private BeanMetaData beanMetaData;
    private BeanAttribute[] attributes;

    public BeanAttributeList(BeanElement beanElement, BeanMetaData beanMetaData) {
        this.parent = beanElement;
        this.beanMetaData = beanMetaData;
        this.attributes = new BeanAttribute[beanMetaData.attributeCount()];
    }

    public BeanAttributeList(BeanElement clazz) {
        this.parent = clazz;
        clazz = ((AbstractElement)((Object)clazz)).getData();
        clazz = clazz != null ? clazz.getClass() : null;
        this.beanMetaData = BeanMetaData.get(clazz);
        this.attributes = new BeanAttribute[this.beanMetaData.attributeCount()];
    }

    public BeanAttribute attribute(String string) {
        int n2 = this.beanMetaData.getIndex(string);
        return this.attribute(n2);
    }

    public BeanAttribute attribute(QName qName) {
        int n2 = this.beanMetaData.getIndex(qName);
        return this.attribute(n2);
    }

    public BeanAttribute attribute(int n2) {
        if (n2 >= 0 && n2 <= this.attributes.length) {
            BeanAttribute beanAttribute = this.attributes[n2];
            if (beanAttribute == null) {
                BeanAttributeList beanAttributeList = this;
                this.attributes[n2] = beanAttribute = beanAttributeList.createAttribute(beanAttributeList.parent, n2);
            }
            return beanAttribute;
        }
        return null;
    }

    public BeanElement getParent() {
        return this.parent;
    }

    public QName getQName(int n2) {
        return this.beanMetaData.getQName(n2);
    }

    public Object getData(int n2) {
        return this.beanMetaData.getData(n2, ((AbstractElement)this.parent).getData());
    }

    public void setData(int n2, Object object) {
        this.beanMetaData.setData(n2, ((AbstractElement)this.parent).getData(), object);
    }

    @Override
    public int size() {
        return this.attributes.length;
    }

    @Override
    public BeanAttribute get(int n2) {
        BeanAttribute beanAttribute = this.attributes[n2];
        if (beanAttribute == null) {
            BeanAttributeList beanAttributeList = this;
            this.attributes[n2] = beanAttribute = beanAttributeList.createAttribute(beanAttributeList.parent, n2);
        }
        return beanAttribute;
    }

    @Override
    public boolean add(BeanAttribute beanAttribute) {
        throw new UnsupportedOperationException("add(Object) unsupported");
    }

    @Override
    public void add(int n2, BeanAttribute beanAttribute) {
        throw new UnsupportedOperationException("add(int,Object) unsupported");
    }

    @Override
    public BeanAttribute set(int n2, BeanAttribute beanAttribute) {
        throw new UnsupportedOperationException("set(int,Object) unsupported");
    }

    @Override
    public boolean remove(Object object) {
        return false;
    }

    @Override
    public BeanAttribute remove(int n2) {
        BeanAttribute beanAttribute = this.get(n2);
        ((AbstractAttribute)beanAttribute).setValue(null);
        return beanAttribute;
    }

    @Override
    public void clear() {
        BeanAttribute[] beanAttributeArray = this.attributes;
        int n2 = this.attributes.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            BeanAttribute beanAttribute = beanAttributeArray[i2];
            if (beanAttribute == null) continue;
            ((AbstractAttribute)beanAttribute).setValue(null);
        }
    }

    protected BeanAttribute createAttribute(BeanElement beanElement, int n2) {
        return new BeanAttribute(this, n2);
    }
}

