/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.bean;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.DocumentFactory;
import org.dom4j.QName;
import org.dom4j.bean.BeanAttributeList;
import org.dom4j.bean.BeanDocumentFactory;
import org.dom4j.bean.BeanElement;

public class BeanMetaData {
    protected static final Object[] NULL_ARGS = new Object[0];
    private static Map<Class<?>, BeanMetaData> singletonCache = new HashMap();
    private static final DocumentFactory DOCUMENT_FACTORY = BeanDocumentFactory.getInstance();
    private Class<?> beanClass;
    private PropertyDescriptor[] propertyDescriptors;
    private QName[] qNames;
    private Method[] readMethods;
    private Method[] writeMethods;
    private Map<Object, Integer> nameMap = new HashMap<Object, Integer>();

    public BeanMetaData(Class<?> object) {
        this.beanClass = object;
        if (object != null) {
            try {
                object = Introspector.getBeanInfo(object);
                this.propertyDescriptors = object.getPropertyDescriptors();
            }
            catch (IntrospectionException introspectionException) {
                this.handleException(introspectionException);
            }
        }
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = new PropertyDescriptor[0];
        }
        int n2 = this.propertyDescriptors.length;
        this.qNames = new QName[n2];
        this.readMethods = new Method[n2];
        this.writeMethods = new Method[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            QName qName;
            PropertyDescriptor propertyDescriptor = this.propertyDescriptors[i2];
            String string = propertyDescriptor.getName();
            this.qNames[i2] = qName = DOCUMENT_FACTORY.createQName(string);
            this.readMethods[i2] = propertyDescriptor.getReadMethod();
            this.writeMethods[i2] = propertyDescriptor.getWriteMethod();
            this.nameMap.put(string, i2);
            this.nameMap.put(qName, i2);
        }
    }

    public static BeanMetaData get(Class<?> clazz) {
        BeanMetaData beanMetaData = singletonCache.get(clazz);
        if (beanMetaData == null) {
            beanMetaData = new BeanMetaData(clazz);
            singletonCache.put(clazz, beanMetaData);
        }
        return beanMetaData;
    }

    public int attributeCount() {
        return this.propertyDescriptors.length;
    }

    public BeanAttributeList createAttributeList(BeanElement beanElement) {
        return new BeanAttributeList(beanElement, this);
    }

    public QName getQName(int n2) {
        return this.qNames[n2];
    }

    public int getIndex(String object) {
        if ((object = this.nameMap.get(object)) != null) {
            return (Integer)object;
        }
        return -1;
    }

    public int getIndex(QName serializable) {
        if ((serializable = this.nameMap.get(serializable)) != null) {
            return (Integer)serializable;
        }
        return -1;
    }

    public Object getData(int n2, Object object) {
        try {
            Method method = this.readMethods[n2];
            return method.invoke(object, NULL_ARGS);
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    public void setData(int n2, Object object, Object objectArray) {
        try {
            Method method = this.writeMethods[n2];
            objectArray = new Object[]{objectArray};
            method.invoke(object, objectArray);
            return;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return;
        }
    }

    protected void handleException(Exception exception) {
    }
}

