/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.datatype;

import com.sun.msv.datatype.DatabindableDatatype;
import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.XSDatatype;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.tree.AbstractAttribute;
import org.dom4j.tree.AbstractNode;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

public class DatatypeAttribute
extends AbstractAttribute
implements SerializationContext,
ValidationContext {
    private Element parent;
    private QName qname;
    private XSDatatype datatype;
    private Object data;
    private String text;

    public DatatypeAttribute(QName qName, XSDatatype xSDatatype) {
        this.qname = qName;
        this.datatype = xSDatatype;
    }

    public DatatypeAttribute(QName qName, XSDatatype xSDatatype, String string) {
        this.qname = qName;
        this.datatype = xSDatatype;
        this.text = string;
        this.data = this.convertToValue(string);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + this.hashCode() + " [Attribute: name " + this.getQualifiedName() + " value \"" + this.getValue() + "\" data: " + ((AbstractAttribute)this).getData() + "]";
    }

    public XSDatatype getXSDatatype() {
        return this.datatype;
    }

    @Override
    public String getNamespacePrefix(String object) {
        Element element = ((AbstractNode)this).getParent();
        if (element != null && (object = element.getNamespaceForURI((String)object)) != null) {
            return ((Namespace)object).getPrefix();
        }
        return null;
    }

    @Override
    public String getBaseUri() {
        return null;
    }

    @Override
    public boolean isNotation(String string) {
        return false;
    }

    @Override
    public boolean isUnparsedEntity(String string) {
        return true;
    }

    @Override
    public String resolveNamespacePrefix(String object) {
        if (((String)object).equals(this.getNamespacePrefix())) {
            return this.getNamespaceURI();
        }
        Element element = ((AbstractNode)this).getParent();
        if (element != null && (object = element.getNamespaceForPrefix((String)object)) != null) {
            return ((Namespace)object).getURI();
        }
        return null;
    }

    @Override
    public QName getQName() {
        return this.qname;
    }

    @Override
    public String getValue() {
        return this.text;
    }

    @Override
    public void setValue(String string) {
        this.validate(string);
        this.text = string;
        this.data = this.convertToValue(string);
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setData(Object object) {
        String string = this.datatype.convertToLexicalValue(object, this);
        this.validate(string);
        this.text = string;
        this.data = object;
    }

    @Override
    public Element getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Element element) {
        this.parent = element;
    }

    @Override
    public boolean supportsParent() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    protected void validate(String string) {
        try {
            this.datatype.checkValid(string, this);
            return;
        }
        catch (DatatypeException datatypeException) {
            throw new IllegalArgumentException(datatypeException.getMessage());
        }
    }

    protected Object convertToValue(String string) {
        if (this.datatype instanceof DatabindableDatatype) {
            XSDatatype xSDatatype = this.datatype;
            return xSDatatype.createJavaObject(string, this);
        }
        return this.datatype.createValue(string, this);
    }
}

