/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.datatype;

import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.datatype.DatatypeElementFactory;
import org.dom4j.datatype.InvalidSchemaException;
import org.dom4j.datatype.SchemaParser;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class DatatypeDocumentFactory
extends DocumentFactory {
    private static final boolean DO_INTERN_QNAME = false;
    protected static transient DatatypeDocumentFactory singleton = new DatatypeDocumentFactory();
    private static final Namespace XSI_NAMESPACE = Namespace.get("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    private static final QName XSI_SCHEMA_LOCATION = QName.get("schemaLocation", XSI_NAMESPACE);
    private static final QName XSI_NO_SCHEMA_LOCATION = QName.get("noNamespaceSchemaLocation", XSI_NAMESPACE);
    private SchemaParser schemaBuilder;
    private SAXReader xmlSchemaReader = new SAXReader();
    private boolean autoLoadSchema = true;

    public DatatypeDocumentFactory() {
        this.schemaBuilder = new SchemaParser(this);
    }

    public static DocumentFactory getInstance() {
        return singleton;
    }

    public void loadSchema(Document document) {
        this.schemaBuilder.build(document);
    }

    public void loadSchema(Document document, Namespace namespace) {
        this.schemaBuilder.build(document, namespace);
    }

    public DatatypeElementFactory getElementFactory(QName serializable) {
        DatatypeElementFactory datatypeElementFactory = null;
        if ((serializable = serializable.getDocumentFactory()) instanceof DatatypeElementFactory) {
            datatypeElementFactory = (DatatypeElementFactory)serializable;
        }
        return datatypeElementFactory;
    }

    @Override
    public Attribute createAttribute(Element element, QName qName, String string) {
        if (this.autoLoadSchema && qName.equals(XSI_NO_SCHEMA_LOCATION)) {
            Document document = element != null ? element.getDocument() : null;
            this.loadSchema(document, string);
        } else if (this.autoLoadSchema && qName.equals(XSI_SCHEMA_LOCATION)) {
            Document document = element != null ? element.getDocument() : null;
            Object object = string.substring(0, string.indexOf(32));
            object = element.getNamespaceForURI((String)object);
            String string2 = string;
            this.loadSchema(document, string2.substring(string2.indexOf(32) + 1), (Namespace)object);
        }
        return super.createAttribute(element, qName, string);
    }

    protected void loadSchema(Document object, String string) {
        try {
            object = object.getEntityResolver();
            if (object == null) {
                String string2 = "No EntityResolver available for resolving URI: ";
                throw new InvalidSchemaException(string2 + string);
            }
            InputSource inputSource = object.resolveEntity(null, string);
            if (object == null) {
                throw new InvalidSchemaException("Could not resolve the URI: " + string);
            }
            object = this.xmlSchemaReader.read(inputSource);
            this.loadSchema((Document)object);
            return;
        }
        catch (Exception exception) {
            System.out.println("Failed to load schema: " + string);
            System.out.println("Caught: " + exception);
            exception.printStackTrace();
            throw new InvalidSchemaException("Failed to load schema: " + string);
        }
    }

    protected void loadSchema(Document object, String string, Namespace namespace) {
        try {
            object = object.getEntityResolver();
            if (object == null) {
                String string2 = "No EntityResolver available for resolving URI: ";
                throw new InvalidSchemaException(string2 + string);
            }
            InputSource inputSource = object.resolveEntity(null, string);
            if (object == null) {
                throw new InvalidSchemaException("Could not resolve the URI: " + string);
            }
            object = this.xmlSchemaReader.read(inputSource);
            this.loadSchema((Document)object, namespace);
            return;
        }
        catch (Exception exception) {
            System.out.println("Failed to load schema: " + string);
            System.out.println("Caught: " + exception);
            exception.printStackTrace();
            throw new InvalidSchemaException("Failed to load schema: " + string);
        }
    }
}

